/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.api.model;

import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.model.BoxParameters;
import com.minelittlepony.mson.api.model.CoordinateFixture;
import com.minelittlepony.mson.api.model.Cube;
import com.minelittlepony.mson.api.model.Face;
import com.minelittlepony.mson.api.model.PartBuilder;
import com.minelittlepony.mson.api.model.QuadsBuilder;
import com.minelittlepony.mson.api.model.Rect;
import com.minelittlepony.mson.api.model.Texture;
import com.minelittlepony.mson.api.model.Vert;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public final class BoxBuilder {
    public static final Set<class_2350> ALL_DIRECTIONS = EnumSet.allOf(class_2350.class);
    public final PartBuilder parent;
    public BoxParameters parameters = new BoxParameters();
    public CoordinateFixture fixture = CoordinateFixture.unfixed();
    public QuadsBuilder quads = QuadsBuilder.BOX;

    public BoxBuilder(PartBuilder parent) {
        this.parent = parent;
    }

    public BoxBuilder(ModelContext context) {
        this.parent = (PartBuilder)context.getThis();
        this.dilate(context.getLocals().getDilation());
        this.tex(this.parent.texture);
        System.arraycopy(this.parent.mirror, 0, this.parameters.mirror, 0, 3);
    }

    public BoxBuilder fix(CoordinateFixture fixture) {
        this.fixture = fixture;
        return this;
    }

    public BoxBuilder pos(float ... pos) {
        System.arraycopy(pos, 0, this.parameters.position, 0, 3);
        return this;
    }

    public BoxBuilder tex(Texture tex) {
        this.parameters.uv = tex;
        return this;
    }

    public BoxBuilder size(float ... size) {
        System.arraycopy(size, 0, this.parameters.size, 0, 3);
        return this;
    }

    public BoxBuilder size(Face.Axis axis, float ... dimension) {
        return this.size(axis.getWidth().getFloat(dimension), axis.getHeight().getFloat(dimension), axis.getDepth().getFloat(dimension));
    }

    public BoxBuilder dilate(float ... dilate) {
        this.parameters.dilation[0] = this.parameters.dilation[0] + dilate[0];
        this.parameters.dilation[1] = this.parameters.dilation[1] + dilate[1];
        this.parameters.dilation[2] = this.parameters.dilation[2] + dilate[2];
        return this;
    }

    public BoxBuilder mirror(Face.Axis axis, boolean ... mirror) {
        this.parameters.mirror[0] = axis.getWidth().getBoolean(mirror);
        this.parameters.mirror[1] = axis.getHeight().getBoolean(mirror);
        this.parameters.mirror[2] = axis.getDepth().getBoolean(mirror);
        return this;
    }

    public BoxBuilder mirror(Face.Axis axis, Optional<Boolean> mirror) {
        mirror.ifPresent(m -> {
            this.parameters.mirror[axis.ordinal()] = m;
        });
        return this;
    }

    public Vert vert(float x, float y, float z, int u, int v) {
        return (Vert)new class_630.class_618(x, y, z, (float)u, (float)v);
    }

    public Vert vert(int[] parameters, float[][] positionMatrix) {
        return (Vert)new class_630.class_618(positionMatrix[parameters[0]][0], positionMatrix[parameters[1]][1], positionMatrix[parameters[2]][2], (float)parameters[3], (float)parameters[4]);
    }

    public BoxBuilder quads(QuadsBuilder quads) {
        this.quads = quads;
        return this;
    }

    public class_630.class_628 build() {
        if (this.quads.getId() == QuadsBuilder.CUBE) {
            return this.quads.getBoxParameters(this).build(this.parent, this.quads.getFaces(this));
        }
        BoxParameters pars = this.quads.getBoxParameters(this);
        class_630.class_628 box = pars.build(this.parent, this.quads.getFaces(this));
        ((Cube)box).setSides((Rect[])this.collectQuads(pars).stream().map(Quad::rect).toArray(Rect[]::new));
        return box;
    }

    public List<Quad> collectQuads() {
        return this.collectQuads(this.quads.getBoxParameters(this));
    }

    private List<Quad> collectQuads(BoxParameters pars) {
        final ArrayList<Quad> quads = new ArrayList<Quad>();
        this.quads.build(pars, this, new QuadsBuilder.QuadBuffer(){
            private final class_630.class_618 emptyVertex = new class_630.class_618(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            private final class_630.class_618[] defaultVertices = new class_630.class_618[]{this.emptyVertex, this.emptyVertex, this.emptyVertex, this.emptyVertex};

            @Override
            public boolean getDefaultMirror() {
                return BoxBuilder.this.parameters.mirror[0];
            }

            @Override
            public void quad(float u, float v, float w, float h, class_2350 direction, boolean mirror, boolean remap, @Nullable Quaternionf rotation, Vert ... vertices) {
                class_630.class_618[] verts = new class_630.class_618[vertices.length];
                System.arraycopy(vertices, 0, verts, 0, vertices.length);
                Rect rect = (Rect)new class_630.class_593(remap ? verts : this.defaultVertices, u, v, u + w, v + h, (float)BoxBuilder.this.parent.texture.width(), (float)BoxBuilder.this.parent.texture.height(), mirror, direction);
                if (!remap) {
                    rect.setVertices(mirror, vertices);
                }
                if (rotation != null) {
                    rect.rotate(rotation);
                }
                quads.add(new Quad(rect, direction));
            }
        });
        return quads;
    }

    public record Quad(Rect rect, class_2350 direction) {
    }

    public static interface RenderLayerSetter {
        public Function<class_2960, class_1921> getRenderLayerFactory();

        public void setRenderLayerFactory(Function<class_2960, class_1921> var1);
    }
}

