/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.api.model;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.minelittlepony.mson.api.model.Corner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2350;
import net.minecraft.class_243;

public enum Face {
    NONE(Axis.Y, class_2350.field_11036),
    UP(Axis.Y, class_2350.field_11036),
    DOWN(Axis.Y, class_2350.field_11033),
    WEST(Axis.X, class_2350.field_11039),
    EAST(Axis.X, class_2350.field_11034),
    NORTH(Axis.Z, class_2350.field_11043),
    SOUTH(Axis.Z, class_2350.field_11035);

    private final Axis axis;
    private final class_2350 lighting;
    public static final Set<Face> VALUES;
    private static final Map<String, Face> REGISTRY;

    private Face(Axis axis, class_2350 lighting) {
        this.axis = axis;
        this.lighting = lighting;
    }

    public class_2350 getNormal() {
        return this.axis == Axis.Y ? this.lighting.method_10153() : this.lighting;
    }

    public float applyFixtures(float stretch) {
        return (float)(this.getAxis() == Axis.Y ? -1 : 1) * stretch;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public boolean isInside(float[] position, float[] dimensions, class_243 vertex) {
        float x = position[0];
        float y = position[1];
        float z = position[2];
        float dx = this.getAxis().getWidth().getFloat(dimensions);
        float dy = this.getAxis().getHeight().getFloat(dimensions);
        float dz = this.getAxis().getDepth().getFloat(dimensions);
        return Face.isBetween(vertex.field_1352, x, x + dx) && Face.isBetween(vertex.field_1351, y, y + dy) && Face.isBetween(vertex.field_1350, z, z + dz);
    }

    private static boolean isBetween(double value, double min, double max) {
        return value >= min && value <= max;
    }

    public Stream<Corner> getVertices(float[] position, float[] dimensions, Axis axis, float dilate) {
        class_243 min = new class_243((double)position[0], (double)position[1], (double)position[2]);
        class_243 max = new class_243((double)this.getAxis().getWidth().getFloat(dimensions), (double)this.getAxis().getHeight().getFloat(dimensions), (double)this.getAxis().getDepth().getFloat(dimensions));
        class_243 str = dilate == 0.0f ? class_243.field_1353 : new class_243((double)(axis == Axis.X ? dilate : 0.0f), (double)(axis == Axis.Y ? dilate : 0.0f), (double)(axis == Axis.Z ? dilate : 0.0f));
        class_243 stretchedMin = dilate == 0.0f ? min : min.method_1020(str);
        class_243 stretchedMax = dilate == 0.0f ? max : max.method_1019(str.method_1021(2.0));
        return Arrays.stream(Corner.CORNERS).map(corner -> {
            class_243 cornerVec = min.method_1019(max.method_18806(corner));
            class_243 stretched = dilate == 0.0f ? cornerVec : stretchedMin.method_1019(stretchedMax.method_18806(corner));
            return new Corner(cornerVec, stretched);
        }).distinct();
    }

    public static Face of(String s) {
        return REGISTRY.getOrDefault(Strings.nullToEmpty((String)s).toUpperCase(), NONE);
    }

    static {
        VALUES = ImmutableSet.copyOf((Object[])Face.values());
        REGISTRY = new HashMap<String, Face>();
        VALUES.forEach(f -> REGISTRY.put(f.name(), (Face)((Object)f)));
    }

    public static enum Axis {
        X(-1, 1, 0),
        Y(0, -1, 1),
        Z(0, 1, -1);

        private final Parameter widthIndex;
        private final Parameter heightIndex;
        private final Parameter depthIndex;

        private Axis(int w, int h, int d) {
            this.widthIndex = new Parameter(w);
            this.heightIndex = new Parameter(h);
            this.depthIndex = new Parameter(d);
        }

        public Parameter getWidth() {
            return this.widthIndex;
        }

        public Parameter getHeight() {
            return this.heightIndex;
        }

        public Parameter getDepth() {
            return this.depthIndex;
        }

        public static final class Parameter {
            private final int index;

            private Parameter(int index) {
                this.index = index;
            }

            public float getFloat(float[] dimensions) {
                if (this.index < 0) {
                    return 0.0f;
                }
                return dimensions[this.index];
            }

            public boolean getBoolean(boolean[] dimensions) {
                if (this.index < 0) {
                    return false;
                }
                return dimensions[this.index];
            }
        }
    }
}

