/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.api.parser;

import com.minelittlepony.mson.api.InstanceCreator;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.export.ModelFileWriter;
import com.minelittlepony.mson.api.parser.FileContent;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public interface ModelComponent<T>
extends ModelFileWriter.Writeable {
    default public <K> Optional<K> tryExportTreeNodes(ModelContext context, Class<K> type) {
        return this.tryExport(context, type);
    }

    default public <K> Optional<K> tryExport(ModelContext context, Class<K> type) {
        T s;
        try {
            s = this.export(context);
        }
        catch (Exception e) {
            return Optional.empty();
        }
        if (s != null && type.isAssignableFrom(s.getClass())) {
            return Optional.of(s);
        }
        return Optional.empty();
    }

    @Nullable
    public T export(ModelContext var1);

    default public <K> Optional<K> export(ModelContext context, InstanceCreator<K> customType) {
        return Optional.empty();
    }

    @FunctionalInterface
    public static interface Factory<T, Data> {
        public ModelComponent<? extends T> load(FileContent<Data> var1, String var2, Data var3);
    }
}

