/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.api.parser.locals;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

public enum Operation implements BiFunction<Float, Float, Float>
{
    ADD("+", (one, two) -> Float.valueOf(one.floatValue() + two.floatValue())),
    SUBTRACT("-", (one, two) -> Float.valueOf(one.floatValue() - two.floatValue())),
    MULTIPLY("*", (one, two) -> Float.valueOf(one.floatValue() * two.floatValue())),
    DIVIDE("/", (one, two) -> Float.valueOf(one.floatValue() / two.floatValue())),
    MODULUS("%", (one, two) -> Float.valueOf(one.floatValue() % two.floatValue())),
    EXPONENT("^", (one, two) -> Float.valueOf((float)Math.pow(one.floatValue(), two.floatValue()))),
    VAR("", (one, two) -> {
        throw new RuntimeException("Impossible Operation");
    });

    static List<Operation> VALUES;
    static Map<String, Operation> REGISTRY;
    private final String op;
    private final BiFunction<Float, Float, Float> function;

    private Operation(String op, BiFunction<Float, Float, Float> function) {
        this.op = op;
        this.function = function;
    }

    @Override
    public Float apply(Float one, Float two) {
        return this.function.apply(one, two);
    }

    public static Operation of(String op) {
        return REGISTRY.getOrDefault(op, VAR);
    }

    static {
        VALUES = Lists.newArrayList((Object[])Operation.values());
        REGISTRY = new HashMap<String, Operation>();
        VALUES.forEach(v -> REGISTRY.put(v.op, (Operation)v));
    }
}

