/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl;

import com.minelittlepony.mson.impl.MsonImpl;
import com.minelittlepony.mson.impl.PendingEntityRendererRegistry;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11890;
import net.minecraft.class_11901;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_5617;
import net.minecraft.class_897;

public class AppliedEntityRendererRegistry {
    private final Map<class_1299<?>, Map<Predicate<class_10017>, class_897<? extends class_1297, ?>>> customEntityStateRenderers = new HashMap();
    private final Map<class_2960, Map.Entry<Predicate<?>, class_1007<?>>> customStateRenderers = new HashMap();
    private final Map<class_1299<?>, Map<Predicate<class_1297>, class_897<? extends class_1297, ?>>> customEntityRenderers = new HashMap();
    private final Map<class_2960, Map.Entry<Predicate<? super class_11901>, class_1007<?>>> customModelRenderers = new HashMap();

    public AppliedEntityRendererRegistry(Map<class_1299<?>, class_897<? extends class_1297, ?>> renderers, class_5617.class_5618 context) {
        PendingEntityRendererRegistry pendingRegistrations = MsonImpl.INSTANCE.getEntityRendererRegistry();
        pendingRegistrations.player.publish((id, entry) -> {
            try {
                this.customModelRenderers.put((class_2960)id, (Map.Entry<Predicate<class_11901>, class_1007<?>>)Map.entry((Predicate)entry.getKey(), (class_1007)((Function)entry.getValue()).apply(context)));
            }
            catch (Exception e) {
                MsonImpl.LOGGER.error("Error whilst adding player renderer with id " + String.valueOf(id) + ": " + e.getMessage(), (Throwable)e);
            }
        });
        pendingRegistrations.playerState.publish((id, entry) -> {
            try {
                this.customStateRenderers.put((class_2960)id, (Map.Entry<Predicate<?>, class_1007<?>>)Map.entry((Predicate)entry.getKey(), (class_1007)((Function)entry.getValue()).apply(context)));
            }
            catch (Exception e) {
                MsonImpl.LOGGER.error("Error whilst adding player renderer for render state with id " + String.valueOf(id) + ": " + e.getMessage(), (Throwable)e);
            }
        });
        pendingRegistrations.entity.publish((type, entry) -> {
            try {
                ((Either)entry.getKey()).ifLeft(unit -> renderers.put((class_1299<?>)type, (class_897<? extends class_1297, ?>)((class_897)((Function)entry.getValue()).apply(context)))).ifRight(condition -> this.customEntityRenderers.computeIfAbsent((class_1299<?>)type, t -> new HashMap()).put(condition, (class_897)((Function)entry.getValue()).apply(context)));
            }
            catch (Exception e) {
                MsonImpl.LOGGER.error("Error whilst updating entity renderer with custom condition for entity type " + String.valueOf(class_1299.method_5890((class_1299)type)) + ": " + e.getMessage(), (Throwable)e);
            }
        });
        pendingRegistrations.entityState.publish((type, entry) -> {
            try {
                this.customEntityStateRenderers.computeIfAbsent((class_1299<?>)type, t -> new HashMap()).put((Predicate)entry.getKey(), (class_897)((Function)entry.getValue()).apply(context));
            }
            catch (Exception e) {
                MsonImpl.LOGGER.error("Error whilst updating entity renderer with custom condition for entity render state " + String.valueOf(class_1299.method_5890((class_1299)type)) + ": " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public Optional<class_897<?, ?>> getRenderer(class_1297 entity) {
        class_11890 player;
        if (entity instanceof class_11890 && (player = (class_11890)entity) instanceof class_11901) {
            class_11901 p = (class_11901)player;
            if (!this.customModelRenderers.isEmpty()) {
                return this.customModelRenderers.values().stream().filter(entry -> ((Predicate)entry.getKey()).test(p)).findFirst().map(Map.Entry::getValue);
            }
        } else if (!this.customEntityRenderers.isEmpty()) {
            return this.customEntityRenderers.getOrDefault(entity.method_5864(), Map.of()).entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(entity)).findFirst().map(Map.Entry::getValue);
        }
        return Optional.empty();
    }

    public <S extends class_10017> Optional<class_897<?, ?>> getRenderer(S state) {
        if (state instanceof class_10055 && (state.field_58171 == class_1299.field_6097 || state.field_58171 == class_1299.field_62515)) {
            if (!this.customStateRenderers.isEmpty()) {
                return this.customStateRenderers.values().stream().filter(entry -> ((Predicate)entry.getKey()).test(state)).findFirst().map(Map.Entry::getValue);
            }
        } else if (!this.customEntityStateRenderers.isEmpty() && state.field_58171 != null) {
            return this.customEntityStateRenderers.getOrDefault(state.field_58171, Map.of()).entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(state)).findFirst().map(Map.Entry::getValue);
        }
        return Optional.empty();
    }
}

