/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl;

import com.google.common.io.Files;
import com.minelittlepony.mson.api.ModelKey;
import com.minelittlepony.mson.api.exception.FutureAwaitException;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelFormat;
import com.minelittlepony.mson.api.parser.ModelLoader;
import com.minelittlepony.mson.impl.LoadWorker;
import com.minelittlepony.mson.impl.MsonImpl;
import com.minelittlepony.mson.impl.PathUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

class ModelFoundry
implements ModelLoader {
    private final AtomicReference<LoadWorker<FileContent<?>>> worker = new AtomicReference(LoadWorker.sync());
    private final Map<class_2960, CompletableFuture<FileContent<?>>> loadedFiles = new HashMap();
    private final MsonImpl mson;
    private static final CompletableFuture<FileContent<?>> EMPTY_FILE = CompletableFuture.completedFuture(FileContent.empty());

    public ModelFoundry(MsonImpl mson) {
        this.mson = mson;
    }

    @Override
    public class_3300 getResourceManager() {
        return class_310.method_1551().method_1478();
    }

    CompletableFuture<Void> load() {
        Set<String> extensions = this.mson.handlersByExtension.keySet();
        this.getResourceManager().method_14488("models/entity", id -> {
            String path = id.method_12832();
            return extensions.stream().anyMatch(extension -> path.endsWith("." + extension));
        }).entrySet().stream().map(this::loadModel);
        return CompletableFuture.allOf((CompletableFuture[])this.loadedFiles.values().stream().toArray(CompletableFuture[]::new));
    }

    ModelFoundry setWorker(LoadWorker<FileContent<?>> worker) {
        this.worker.set(worker);
        return this;
    }

    LoadWorker<FileContent<?>> getWorker() {
        return this.worker.get();
    }

    public Optional<FileContent<?>> getOrLoadModelData(ModelKey<?> key) throws InterruptedException, ExecutionException, FutureAwaitException {
        return this.getModelData(key).or(() -> Optional.ofNullable(this.loadModel(key.getId(), this.mson.getDefaultFormatHandler()).get())).filter(m -> m != FileContent.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<FileContent<?>> getModelData(ModelKey<?> key) throws InterruptedException, ExecutionException {
        Map<class_2960, CompletableFuture<FileContent<?>>> map = this.loadedFiles;
        synchronized (map) {
            if (!this.loadedFiles.containsKey(key.getId())) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.loadedFiles.get(key.getId()).get()).filter(m -> m != FileContent.empty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<FileContent<?>> loadModel(class_2960 id, class_2960 file, class_3298 resource) {
        Map<class_2960, CompletableFuture<FileContent<?>>> map = this.loadedFiles;
        synchronized (map) {
            if (!this.loadedFiles.containsKey(id)) {
                this.loadedFiles.put(id, this.getWorker().load(() -> this.mson.getHandlers(Files.getFileExtension((String)file.method_12832())).flatMap(handler -> handler.loadModel(id, file, resource, true, this).stream()).findFirst().orElseGet(() -> {
                    MsonImpl.LOGGER.error("Could not load model for {}", (Object)file);
                    return FileContent.empty();
                }), "Loading MSON model - " + String.valueOf(id)));
            }
            return this.loadedFiles.get(id);
        }
    }

    public CompletableFuture<FileContent<?>> loadModel(Map.Entry<class_2960, class_3298> entry) {
        String extension = Files.getFileExtension((String)entry.getKey().method_12832());
        return this.loadModel(entry.getKey().method_45134(p -> p.replace("models/entity/", "").replace("." + extension, "")), entry.getKey(), entry.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<FileContent<?>> loadModel(class_2960 modelId, @Nullable ModelFormat<?> preferredFormat) {
        class_2960 preferredFile;
        Map<class_2960, CompletableFuture<FileContent<?>>> map = this.loadedFiles;
        synchronized (map) {
            if (this.loadedFiles.containsKey(modelId)) {
                return this.loadedFiles.get(modelId);
            }
        }
        class_2960 file = class_2960.method_60655((String)modelId.method_12836(), (String)("models/entity/" + modelId.method_12832()));
        Map resources = this.getResourceManager().method_14488("models/entity", id -> id.method_12836().equals(file.method_12836()) && PathUtil.removeExtension(id).contentEquals(PathUtil.removeExtension(file)));
        if (resources.size() > 1) {
            MsonImpl.LOGGER.warn("Ambiguous reference: {} could refer to [{}]", (Object)file, (Object)String.join((CharSequence)",", (CharSequence[])resources.keySet().stream().map(class_2960::toString).toArray(String[]::new)));
        }
        if (resources.isEmpty()) {
            Map<class_2960, CompletableFuture<FileContent<?>>> map2 = this.loadedFiles;
            synchronized (map2) {
                this.loadedFiles.put(modelId, EMPTY_FILE);
                return EMPTY_FILE;
            }
        }
        class_2960 first = (class_2960)resources.keySet().stream().sorted().toList().get(0);
        if (preferredFormat != null && resources.containsKey(preferredFile = file.method_45134(p -> p + "." + preferredFormat.getFileExtension()))) {
            return this.loadModel(modelId, preferredFile, (class_3298)resources.get(preferredFile));
        }
        return this.loadModel(modelId, first, (class_3298)resources.get(first));
    }
}

