/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl;

import com.minelittlepony.mson.api.EntityRendererRegistry;
import com.minelittlepony.mson.impl.MsonImpl;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_10017;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11890;
import net.minecraft.class_11901;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_5614;
import net.minecraft.class_5617;
import net.minecraft.class_827;
import net.minecraft.class_897;
import org.jetbrains.annotations.Nullable;

final class PendingEntityRendererRegistry
implements EntityRendererRegistry {
    final PendingRegistrations<class_2960, Map.Entry<Predicate<class_11901>, Function<class_5617.class_5618, ? extends class_1007<?>>>> player = new PendingRegistrations(this, MsonImpl.id("renderers/player"));
    final PendingRegistrations<class_2960, Map.Entry<Predicate<class_10055>, Function<class_5617.class_5618, ? extends class_1007<?>>>> playerState = new PendingRegistrations(this, MsonImpl.id("renderers/player_render_state"));
    final PendingRegistrations<class_1299<?>, Map.Entry<Either<class_3902, Predicate<class_1297>>, Function<class_5617.class_5618, ? extends class_897<?, ?>>>> entity = new PendingRegistrations(this, MsonImpl.id("renderers/entity"));
    final PendingRegistrations<class_1299<?>, Map.Entry<Predicate<class_10017>, Function<class_5617.class_5618, ? extends class_897<?, ?>>>> entityState = new PendingRegistrations(this, MsonImpl.id("renderers/entity_render_state"));
    final PendingRegistrations<class_2591<?>, Function<class_5614.class_5615, ? extends class_827<?, ?>>> block = new PendingRegistrations(this, MsonImpl.id("renderers/block"));

    PendingEntityRendererRegistry() {
    }

    @Override
    public <E extends class_11890, T extends class_1007<E>> void registerPlayerRenderer(class_2960 skinType, Predicate<? super E> playerPredicate, Function<class_5617.class_5618, T> constructor) {
        this.player.register(skinType, Map.entry(playerPredicate, constructor));
    }

    @Override
    public <E extends class_11890, T extends class_1007<E>> void registerPlayerStateRenderer(class_2960 skinType, Predicate<class_10055> statePredicate, Function<class_5617.class_5618, T> constructor) {
        this.playerState.register(skinType, Map.entry(statePredicate, constructor));
    }

    @Override
    public <T extends class_1297, R extends class_897<?, ?>> void registerEntityRenderer(class_1299<T> type, Function<class_5617.class_5618, R> constructor) {
        this.entity.register(type, Map.entry(Either.left((Object)class_3902.field_17274), constructor));
    }

    @Override
    public <T extends class_1297, R extends class_897<?, ?>> void registerEntityRenderer(class_1299<T> type, Predicate<? super T> condition, Function<class_5617.class_5618, R> constructor) {
        this.entity.register(type, Map.entry(Either.right(condition), constructor));
    }

    @Override
    public <T extends class_1297, R extends class_897<?, ?>> void registerEntityStateRenderer(class_1299<T> type, Predicate<class_10017> condition, Function<class_5617.class_5618, R> constructor) {
        this.entityState.register(type, Map.entry(condition, constructor));
    }

    @Override
    public <P extends class_2586, R extends class_827<?, ?>> void registerBlockRenderer(class_2591<P> type, Function<class_5614.class_5615, R> constructor) {
        this.block.register(type, constructor);
    }

    void initialize() {
        this.player.reload();
        this.playerState.reload();
        this.entity.reload();
        this.entityState.reload();
        this.block.reload();
    }

    public class PendingRegistrations<Key, Entry> {
        private final HashMap<Key, Entry> entries = new HashMap();
        private boolean waiting;
        @Nullable
        private BiConsumer<Key, Entry> runtimeRegistry;
        private final class_2960 registryId;

        public PendingRegistrations(PendingEntityRendererRegistry this$0, class_2960 registryId) {
            this.registryId = registryId;
        }

        public void register(Key key, Entry entry) {
            this.entries.put(key, entry);
            if (this.runtimeRegistry != null && !this.waiting) {
                this.runtimeRegistry.accept(key, entry);
            }
        }

        void reload() {
            boolean delayed = this.waiting;
            this.waiting = false;
            if (this.runtimeRegistry != null) {
                MsonImpl.LOGGER.info(delayed ? "Running delayed initialization for registry '{}'" : "Initializing registry '{}'", (Object)this.registryId);
                this.entries.forEach(this.runtimeRegistry);
            } else {
                MsonImpl.LOGGER.info("Registry '{}' queued for delayed initialization", (Object)this.registryId);
                this.waiting = true;
            }
        }

        public void publish(BiConsumer<Key, Entry> runtimeRegistry) {
            this.runtimeRegistry = runtimeRegistry;
            if (this.waiting) {
                this.reload();
            }
        }

        static interface Registerable<Key, Entry> {
            public void register(BiConsumer<Key, Entry> var1, Key var2, Entry var3);
        }
    }
}

