/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.bbmodel;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.mson.api.export.ModelSerializer;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelComponent;
import com.minelittlepony.mson.api.parser.ModelFormat;
import com.minelittlepony.mson.api.parser.ModelLoader;
import com.minelittlepony.mson.impl.MsonImpl;
import com.minelittlepony.mson.impl.model.bbmodel.BBModelWriter;
import com.minelittlepony.mson.impl.model.bbmodel.BlockBenchFileContent;
import com.minelittlepony.mson.impl.model.bbmodel.elements.BbCube;
import com.minelittlepony.mson.impl.model.bbmodel.elements.BbPart;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3518;

public class BBModelFormat
implements ModelFormat<JsonElement> {
    public static final ModelFormat<JsonElement> INSTANCE = new BBModelFormat();
    private static final Gson GSON = new Gson();
    private final Map<class_2960, ModelComponent.Factory<?, JsonElement>> componentTypes = new HashMap();
    private final Set<String> acceptableModelFormats = Set.of("modded_entity", "java_block");

    private BBModelFormat() {
        this.registerComponentType(BbCube.ID, BbCube::new);
        this.registerComponentType(BbPart.ID, BbPart::new);
    }

    @Override
    public String getFileExtension() {
        return "bbmodel";
    }

    @Override
    public Optional<ModelSerializer<FileContent<?>>> createSerializer() {
        return Optional.of(new BBModelWriter());
    }

    @Override
    public Optional<FileContent<JsonElement>> loadModel(class_2960 modelId, ModelLoader loader) {
        class_2960 file = modelId.method_45134(p -> p + "." + this.getFileExtension());
        return loader.getResourceManager().method_14486(file).flatMap(resource -> this.loadModel(modelId, file, (class_3298)resource, true, loader));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<FileContent<JsonElement>> loadModel(class_2960 modelId, class_2960 file, class_3298 resource, boolean failHard, ModelLoader loader) {
        try (InputStreamReader reader = new InputStreamReader(resource.method_14482(), Charsets.UTF_8);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            JsonObject meta = class_3518.method_15281((JsonObject)json, (String)"meta", (JsonObject)new JsonObject());
            String modelFormat = class_3518.method_15253((JsonObject)meta, (String)"model_format", (String)"").toLowerCase(Locale.ROOT);
            if (!this.acceptableModelFormats.contains(modelFormat)) {
                Optional<FileContent<JsonElement>> optional = Optional.empty();
                return optional;
            }
            Optional<FileContent<JsonElement>> optional = Optional.of(new BlockBenchFileContent(modelFormat, this, modelId, json));
            return optional;
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    @Override
    public void registerComponentType(class_2960 id, ModelComponent.Factory<?, JsonElement> constructor) {
        Objects.requireNonNull(id, "Id must not be null");
        Objects.requireNonNull(constructor, "Constructor must not be null");
        MsonImpl.checkNamespace(id.method_12836());
        Preconditions.checkArgument((!this.componentTypes.containsKey(id) ? 1 : 0) != 0, (String)"A component with the id `%s` was already registered", (Object)id);
        this.componentTypes.put(id, constructor);
    }

    @Override
    public <T> Optional<ModelComponent<T>> loadComponent(String name, JsonElement data, class_2960 defaultAs, FileContent<JsonElement> context) {
        if (!data.isJsonObject()) {
            return Optional.empty();
        }
        JsonObject json = data.getAsJsonObject();
        class_2960 id = class_2960.method_60654((String)json.get("type").getAsString());
        String fname = Strings.nullToEmpty((String)name).trim();
        if (id.method_12836().equalsIgnoreCase("minecraft")) {
            id = class_2960.method_60655((String)"blockbench", (String)id.method_12832());
        }
        return Optional.ofNullable(this.componentTypes.get(id)).map(c -> c.load(context, fname, json));
    }
}

