/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.bbmodel;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.export.JsonBuffer;
import com.minelittlepony.mson.api.export.ModelFileWriter;
import com.minelittlepony.mson.api.export.ModelSerializer;
import com.minelittlepony.mson.api.model.BoxBuilder;
import com.minelittlepony.mson.api.model.PartBuilder;
import com.minelittlepony.mson.api.model.QuadsBuilder;
import com.minelittlepony.mson.api.model.Vert;
import com.minelittlepony.mson.api.parser.FileContent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

class BBModelWriter
extends ModelSerializer<FileContent<?>>
implements ModelFileWriter {
    private final List<JsonBuffer.JsonConvertable> elements = new ArrayList<JsonBuffer.JsonConvertable>();
    private PartStack stack = new PartStack();

    BBModelWriter() {
    }

    @Override
    public JsonElement writeToJsonElement(FileContent<?> content) {
        this.close();
        JsonBuffer buffer = JsonBuffer.INSTANCE;
        return buffer.of(root -> {
            buffer.object((JsonObject)root, "meta", (JsonElement)buffer.of(meta -> {
                meta.addProperty("format_version", "4.0");
                meta.addProperty("creation_time", (Number)System.currentTimeMillis());
                meta.addProperty("model_format", "free");
                meta.addProperty("box_uv", Boolean.valueOf(true));
            }));
            root.addProperty("modded_entity_flip_y", Boolean.valueOf(true));
            root.addProperty("name", content.getLocals().getModelId().toString());
            ModelContext context = content.createContext(null, null, content.getLocals().bake());
            buffer.object((JsonObject)root, "resolution", (JsonElement)buffer.of(resolution -> {
                resolution.addProperty("width", (Number)context.getLocals().getTexture().width());
                resolution.addProperty("height", (Number)context.getLocals().getTexture().height());
            }));
            this.writePart("root", new PartBuilder(), (writer, p) -> {
                this.writeTree(context, content);
                root.add("outliner", (JsonElement)buffer.of(this.stack.part().children().stream().map(part -> part.toJson(buffer))));
            });
            root.add("elements", (JsonElement)buffer.of(this.elements));
            root.add("textures", (JsonElement)buffer.of(new float[0]));
        });
    }

    @Override
    public ModelFileWriter write(ModelContext context, ModelFileWriter.Writeable element) {
        element.write(context, this);
        return this;
    }

    @Override
    public ModelFileWriter write(String name, ModelContext context, ModelFileWriter.Writeable element) {
        if (this.stack.shouldWrite(element)) {
            this.stack.pushName(name);
            element.write(context, this);
            this.stack.popName();
        }
        return this;
    }

    @Override
    public ModelFileWriter writePart(String name, PartBuilder part, BiConsumer<ModelFileWriter, PartBuilder> content) {
        this.stack.pushPart(name, part);
        content.accept(this, part);
        this.stack.popPart();
        return this;
    }

    @Override
    public ModelFileWriter writeBox(BoxBuilder box) {
        if (box.quads.getId() == QuadsBuilder.CUBE) {
            this.generateStandardCube(box.quads.getId(), box);
        } else {
            this.generateMesh(box.quads.getId(), box);
        }
        return this;
    }

    private void generateStandardCube(class_2960 type, final BoxBuilder box) {
        PartStack.Part part = this.stack.part();
        final EnumMap faces = new EnumMap(class_2350.class);
        float[] emptyDilation = new float[box.parameters.dilation.length];
        boolean isAxisDilated = this.isUsingPerAxisDilation(box.parameters.dilation);
        float[] dilate = isAxisDilated ? box.parameters.dilation : emptyDilation;
        float inflate = isAxisDilated ? 0.0f : box.parameters.dilation[0];
        box.parameters.dilation = emptyDilation;
        final boolean[] mirroring = new boolean[]{false};
        QuadsBuilder.BOX.build(QuadsBuilder.BOX.getBoxParameters(box), box, new QuadsBuilder.QuadBuffer(){

            @Override
            public boolean getDefaultMirror() {
                return box.parameters.mirror[0];
            }

            @Override
            public void quad(float u, float v, float w, float h, class_2350 direction, boolean mirror, boolean remap, @Nullable Quaternionf rotation, Vert ... vertices) {
                mirroring[0] = mirroring[0] | mirror;
                faces.computeIfAbsent(direction, d -> new ArrayList()).add(buffer -> buffer.of(face -> {
                    face.add("uv", (JsonElement)buffer.of(u - (float)box2.parameters.uv.u(), v - (float)box2.parameters.uv.v(), w - (float)box2.parameters.uv.u(), h - (float)box2.parameters.uv.v()));
                    face.addProperty("texture", (Number)0);
                }));
            }
        });
        faces.values().stream().mapToInt(List::size).max().ifPresent(maxCubes -> {
            int i = 0;
            while (i < maxCubes) {
                int ordinal = i++;
                UUID id = UUID.randomUUID();
                part.elements().add(id);
                this.elements.add(buffer -> buffer.of(elementJson -> {
                    elementJson.addProperty("name", part.isRedundant() ? part.name() : type.method_12832());
                    elementJson.addProperty("type", "cube");
                    elementJson.addProperty("uuid", id.toString());
                    elementJson.addProperty("rescale", Boolean.valueOf(false));
                    elementJson.addProperty("locked", Boolean.valueOf(false));
                    elementJson.addProperty("inflate", (Number)Float.valueOf(inflate));
                    elementJson.addProperty("mirror_uv", Boolean.valueOf(mirroring[0]));
                    elementJson.addProperty("visibility", Boolean.valueOf(!part.hidden()));
                    if (part.isRedundant()) {
                        part.writeTransform((JsonObject)elementJson, buffer);
                    }
                    float[] pivot = part.pivot();
                    elementJson.add("from", (JsonElement)buffer.of(box.parameters.position[0] + pivot[0] - dilate[0], -box.parameters.position[1] - box.parameters.size[1] - pivot[1] - dilate[1], box.parameters.position[2] + pivot[2] - dilate[2]));
                    elementJson.add("to", (JsonElement)buffer.of(box.parameters.position[0] + box.parameters.size[0] + pivot[0] + dilate[0], -box.parameters.position[1] - pivot[1] + dilate[1], box.parameters.position[2] + box.parameters.size[2] + pivot[2] + dilate[2]));
                    elementJson.add("uv_offset", (JsonElement)buffer.of(box.parameters.uv.u(), box.parameters.uv.v()));
                    buffer.object((JsonObject)elementJson, "faces", (JsonElement)buffer.of(facesJson -> BoxBuilder.ALL_DIRECTIONS.forEach(direction -> facesJson.add(direction.name().toLowerCase(Locale.ROOT), faces.getOrDefault(direction, List.of()).stream().map(face -> face.toJson(buffer)).skip(ordinal).findFirst().orElseGet(() -> buffer.of(face -> {
                        buffer.array((JsonObject)face, "uv", 0.0f, 0.0f, 0.0f, 0.0f);
                        face.addProperty("texture", (Number)0);
                    }))))));
                }));
            }
        });
    }

    private boolean isUsingPerAxisDilation(float[] dilate) {
        for (int i = 0; i < dilate.length; ++i) {
            if (dilate[i] == dilate[0]) continue;
            return true;
        }
        return false;
    }

    private void generateMesh(class_2960 type, BoxBuilder box) {
        PartStack.Part part = this.stack.part();
        float[] pivot = part.pivot();
        float[] size = new float[]{box.parameters.size[0], box.parameters.size[1], box.parameters.size[2]};
        box.pos(box.parameters.position[0] + pivot[0], -box.parameters.position[1] - size[1] - pivot[1], box.parameters.position[2] + pivot[2]);
        UUID id = UUID.randomUUID();
        part.meshes().add(id);
        this.elements.add(buffer -> buffer.of(elementJson -> {
            List<BoxBuilder.Quad> quads = box.collectQuads();
            List<class_2350> directions = quads.stream().map(BoxBuilder.Quad::direction).distinct().toList();
            elementJson.addProperty("name", (String)(part.isRedundant() ? part.name() : (String)(directions.size() == 1 ? directions.get(0).method_15434() + "_" : "") + type.method_12832()));
            elementJson.addProperty("type", "mesh");
            elementJson.addProperty("uuid", id.toString());
            elementJson.addProperty("rescale", Boolean.valueOf(false));
            elementJson.addProperty("locked", Boolean.valueOf(false));
            elementJson.addProperty("visibility", Boolean.valueOf(!part.hidden()));
            elementJson.add("uv_offset", (JsonElement)buffer.of(box.parameters.uv.u(), box.parameters.uv.v()));
            Map verticesCache = quads.stream().flatMap(quad -> Arrays.stream(quad.rect().getVertices())).distinct().collect(Collectors.toMap(Function.identity(), vv -> UUID.randomUUID()));
            buffer.object((JsonObject)elementJson, "faces", (JsonElement)buffer.of(facesJson -> buffer.object((JsonObject)facesJson, UUID.randomUUID().toString(), (JsonElement)buffer.of(faceJson -> {
                buffer.object((JsonObject)faceJson, "uv", (JsonElement)buffer.of(uvJson -> verticesCache.forEach((vert, vertId) -> uvJson.add(vertId.toString(), (JsonElement)buffer.of(vert.getU() * (float)box.parent.texture.width(), vert.getV() * (float)box.parent.texture.height())))));
                faceJson.add("vertices", (JsonElement)buffer.of(verticesCache.values().stream().map(UUID::toString).map(JsonPrimitive::new)));
                faceJson.addProperty("texture", (Number)0);
            }))));
            buffer.object((JsonObject)elementJson, "vertices", (JsonElement)buffer.of(verticesJson -> verticesCache.forEach((vert, vertId) -> {
                if (part.isRedundant()) {
                    verticesJson.add(vertId.toString(), (JsonElement)buffer.of(vert.getPos().x() + part.part().pivot[0], vert.getPos().y() + part.part().pivot[1], vert.getPos().z() + part.part().pivot[2]));
                } else {
                    verticesJson.add(vertId.toString(), (JsonElement)buffer.of(vert.getPos().x(), vert.getPos().y(), vert.getPos().z()));
                }
            })));
        }));
    }

    @Override
    public ModelFileWriter writeTree(String name, FileContent<?> content, ModelContext context) {
        return this.writePart(name, new PartBuilder(), (writer, part) -> this.writeTree(context, content));
    }

    private final void writeTree(ModelContext context, FileContent<?> content) {
        try {
            this.stack.pushFile(content);
            for (String name : content.getComponentNames().get()) {
                this.write(name, context, content.getComponent(name).get());
            }
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
        finally {
            this.stack.popFile();
        }
    }

    @Override
    public void close() {
        this.stack = new PartStack();
        this.elements.clear();
    }

    record PartStack(Stack<ContentRoot> currentFile, Stack<Part> currentPart, Stack<String> currentName) {
        public PartStack() {
            this(new Stack<ContentRoot>(), new Stack<Part>(), new Stack<String>());
        }

        public void pushName(String name) {
            this.currentName.push(name);
        }

        public void popName() {
            this.currentName.pop();
        }

        public void pushFile(FileContent<?> content) {
            this.currentFile.push(new ContentRoot(content, new Stack<Part>(), new HashSet<ModelFileWriter.Writeable>()));
        }

        public void popFile() {
            this.currentFile.pop();
        }

        public void pushPart(String name, PartBuilder part) {
            Part childPart;
            if (name == null || name.isEmpty()) {
                name = this.name();
            }
            if ((childPart = new Part(UUID.randomUUID(), name, part, new ArrayList<UUID>(), new ArrayList<UUID>(), new ArrayList<Part>(), this.currentPart.empty() ? null : this.part())).parent() != null) {
                childPart.parent().children().add(childPart);
            }
            this.currentPart.push(childPart);
            if (!this.currentFile.empty()) {
                this.currentFile.peek().localPart().push(childPart);
            }
        }

        public void popPart() {
            this.currentPart.pop();
            if (!this.currentFile.empty()) {
                this.currentFile.peek().localPart().pop();
            }
        }

        public Part part() {
            return this.currentPart.peek();
        }

        public FileContent<?> file() {
            return this.currentFile.peek().content();
        }

        public String name() {
            return this.currentName.empty() ? "" : this.currentName.peek();
        }

        public boolean shouldWrite(ModelFileWriter.Writeable element) {
            return this.currentFile.empty() || this.currentFile.peek().shouldWrite(element);
        }

        record ContentRoot(FileContent<?> content, Stack<Part> localPart, Set<ModelFileWriter.Writeable> writtenElements) {
            public boolean isAtRoot() {
                return this.localPart.size() < 2;
            }

            public boolean shouldWrite(ModelFileWriter.Writeable element) {
                return this.writtenElements.add(element) || !this.isAtRoot();
            }
        }

        record Part(UUID id, String name, PartBuilder part, List<UUID> elements, List<UUID> meshes, List<Part> children, @Nullable Part parent) implements JsonBuffer.JsonConvertable
        {
            @Override
            public JsonElement toJson(JsonBuffer buffer) {
                if (this.isRedundant()) {
                    return new JsonPrimitive(this.elements.get(0).toString());
                }
                return buffer.of(elementJson -> {
                    elementJson.addProperty("name", this.name);
                    elementJson.addProperty("color", (Number)0);
                    elementJson.addProperty("uuid", this.id.toString());
                    elementJson.addProperty("export", Boolean.valueOf(true));
                    elementJson.addProperty("isOpen", Boolean.valueOf(false));
                    elementJson.addProperty("locked", Boolean.valueOf(false));
                    elementJson.addProperty("visibility", Boolean.valueOf(!this.hidden()));
                    this.writeTransform((JsonObject)elementJson, buffer);
                    elementJson.addProperty("autouv", (Number)0);
                    elementJson.add("children", (JsonElement)buffer.of(Streams.concat((Stream[])new Stream[]{this.elements.stream().map(UUID::toString).map(JsonPrimitive::new), this.meshes.stream().map(UUID::toString).map(JsonPrimitive::new), this.children.stream().map(c -> c.toJson(buffer))})));
                });
            }

            void writeTransform(JsonObject elementJson, JsonBuffer buffer) {
                float[] pivot = this.pivot();
                elementJson.add("origin", (JsonElement)buffer.of(pivot[0], -pivot[1], pivot[2]));
                float[] rotate = this.rotate();
                elementJson.add("rotation", (JsonElement)buffer.of(-rotate[0] / ((float)Math.PI / 180), rotate[1] / ((float)Math.PI / 180), -rotate[2] / ((float)Math.PI / 180)));
            }

            boolean isRedundant() {
                return this.elements.size() == 1 && this.children.isEmpty() && this.meshes.isEmpty();
            }

            boolean hidden() {
                return this.part.hidden || this.parent != null && this.parent.hidden();
            }

            float[] pivot() {
                float[] pivot = this.parent == null ? new float[3] : this.parent.pivot();
                pivot[0] = pivot[0] + this.part.pivot[0];
                pivot[1] = pivot[1] + this.part.pivot[1];
                pivot[2] = pivot[2] + this.part.pivot[2];
                return pivot;
            }

            float[] rotate() {
                float[] rotation;
                rotation = new float[]{rotation[0] + this.part.rotate[0], rotation[1] + this.part.rotate[1], rotation[2] + this.part.rotate[2]};
                return rotation;
            }
        }
    }
}

