/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.bbmodel;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.mson.api.Incomplete;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.ModelView;
import com.minelittlepony.mson.api.json.JsonContext;
import com.minelittlepony.mson.api.model.Texture;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelComponent;
import com.minelittlepony.mson.api.parser.ModelFormat;
import com.minelittlepony.mson.impl.ModelContextImpl;
import com.minelittlepony.mson.impl.model.FileContentLocalsImpl;
import com.minelittlepony.mson.impl.model.RootContext;
import com.minelittlepony.mson.impl.model.bbmodel.elements.BbCube;
import com.minelittlepony.mson.impl.model.bbmodel.elements.BbPart;
import com.minelittlepony.mson.util.JsonUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3879;

class BlockBenchFileContent
implements JsonContext {
    private final ModelFormat<JsonElement> format;
    public final Map<UUID, ModelComponent<?>> cubes = new HashMap();
    private final Map<String, ModelComponent<?>> elements = new HashMap();
    private final FileContent.Locals locals;

    public BlockBenchFileContent(String formatVariant, ModelFormat<JsonElement> format, class_2960 id, JsonObject json) {
        this.format = format;
        this.locals = new RootVariables(id, json);
        JsonUtil.require(json, "elements", id).getAsJsonArray().asList().stream().forEach(element -> this.loadComponent(element, BbCube.ID).ifPresent(component -> {
            ModelComponent patt0$temp = component;
            if (patt0$temp instanceof BbCube) {
                BbCube cube = (BbCube)patt0$temp;
                cube.uuid.ifPresent(uuid -> this.cubes.put((UUID)uuid, cube));
            }
        }));
        JsonUtil.accept(json, "outliner").map(JsonElement::getAsJsonArray).stream().flatMap(e -> e.asList().stream()).map(JsonElement::getAsJsonObject).forEach(element -> this.loadComponent(element, BbPart.ID).ifPresent(component -> {
            ModelComponent patt0$temp = component;
            if (patt0$temp instanceof BbPart) {
                BbPart part = (BbPart)patt0$temp;
                this.elements.put(part.name, part);
            }
        }));
        if ("java_block".equalsIgnoreCase(formatVariant) && this.elements.isEmpty()) {
            this.elements.put("root", new BbPart(this.cubes.values(), "root"));
        }
    }

    @Override
    public ModelFormat<JsonElement> getFormat() {
        return this.format;
    }

    @Override
    public CompletableFuture<Set<String>> getComponentNames() {
        return CompletableFuture.completedFuture(this.elements.keySet());
    }

    @Override
    public CompletableFuture<ModelComponent<?>> getComponent(String name) {
        return CompletableFuture.completedFuture(this.elements.getOrDefault(name, null));
    }

    @Override
    public <T> void addNamedComponent(String name, ModelComponent<T> component) {
        if (!Strings.isNullOrEmpty((String)name)) {
            this.elements.put(name, component);
        }
    }

    @Override
    public <T> Optional<ModelComponent<T>> loadComponent(String name, JsonElement json, class_2960 defaultAs) {
        if (!json.isJsonObject()) {
            try {
                ModelComponent cube = this.cubes.getOrDefault(UUID.fromString(json.getAsString()), null);
                if (cube != null) {
                    return Optional.of(cube);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return JsonContext.super.loadComponent(name, json, defaultAs);
    }

    @Override
    public CompletableFuture<FileContent<?>> resolve(JsonElement json) {
        return CompletableFuture.completedFuture(FileContent.empty());
    }

    @Override
    public ModelContext createContext(class_3879<?> model, Object thisObj, ModelView.Locals locals) {
        return new RootContext(model, thisObj, (ModelContextImpl)FileContent.empty().createContext(model, thisObj, locals), this.elements, locals);
    }

    @Override
    public FileContent.Locals getLocals() {
        return this.locals;
    }

    public static class RootVariables
    implements FileContentLocalsImpl {
        private final class_2960 id;
        private final CompletableFuture<Texture> texture;
        private final CompletableFuture<float[]> dilate = CompletableFuture.completedFuture(new float[]{1.0f, 1.0f, 1.0f});

        RootVariables(class_2960 id, JsonObject json) {
            this.id = id;
            this.texture = CompletableFuture.completedFuture(JsonUtil.accept(json, "resolution").map(JsonElement::getAsJsonObject).map(resolution -> new Texture(0, 0, class_3518.method_15282((JsonObject)resolution, (String)"width", (int)64), class_3518.method_15282((JsonObject)resolution, (String)"height", (int)64))).orElse(Texture.EMPTY));
        }

        @Override
        public class_2960 getModelId() {
            return this.id;
        }

        @Override
        public CompletableFuture<float[]> getDilation() {
            return this.dilate;
        }

        @Override
        public CompletableFuture<Texture> getTexture() {
            return this.texture;
        }

        @Override
        public CompletableFuture<Incomplete<Float>> getLocal(String name, float defaultValue) {
            return CompletableFuture.completedFuture(Incomplete.completed(Float.valueOf(defaultValue)));
        }

        @Override
        public CompletableFuture<Set<String>> keys() {
            return CompletableFuture.completedFuture(new HashSet());
        }
    }
}

