/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.json;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelComponent;
import com.minelittlepony.mson.api.parser.ModelFormat;
import com.minelittlepony.mson.api.parser.ModelLoader;
import com.minelittlepony.mson.impl.MsonImpl;
import com.minelittlepony.mson.impl.model.json.JsonFileContent;
import com.minelittlepony.mson.impl.model.json.elements.JsonBox;
import com.minelittlepony.mson.impl.model.json.elements.JsonCompound;
import com.minelittlepony.mson.impl.model.json.elements.JsonCone;
import com.minelittlepony.mson.impl.model.json.elements.JsonImport;
import com.minelittlepony.mson.impl.model.json.elements.JsonLink;
import com.minelittlepony.mson.impl.model.json.elements.JsonPlanar;
import com.minelittlepony.mson.impl.model.json.elements.JsonPlane;
import com.minelittlepony.mson.impl.model.json.elements.JsonQuads;
import com.minelittlepony.mson.impl.model.json.elements.JsonSlot;
import com.minelittlepony.mson.util.JsonUtil;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import org.jetbrains.annotations.VisibleForTesting;

public class MsonModelFormat
implements ModelFormat<JsonElement> {
    public static final ModelFormat<JsonElement> INSTANCE = new MsonModelFormat();
    private static final Gson GSON = new Gson();
    private final Map<class_2960, ModelComponent.Factory<?, JsonElement>> componentTypes = new HashMap();

    private MsonModelFormat() {
        this.componentTypes.put(JsonCompound.ID, JsonCompound::new);
        this.componentTypes.put(JsonBox.ID, JsonBox::new);
        this.componentTypes.put(JsonPlane.ID, JsonPlane::new);
        this.componentTypes.put(JsonPlanar.ID, JsonPlanar::new);
        this.componentTypes.put(JsonSlot.ID, JsonSlot::new);
        this.componentTypes.put(JsonCone.ID, JsonCone::new);
        this.componentTypes.put(JsonQuads.ID, JsonQuads::new);
        this.componentTypes.put(JsonImport.ID, JsonImport::new);
    }

    @Override
    public String getFileExtension() {
        return "json";
    }

    @Override
    public Optional<FileContent<JsonElement>> loadModel(class_2960 modelId, ModelLoader loader) {
        class_2960 file = modelId.method_45134(p -> "models/" + p + "." + this.getFileExtension());
        return loader.getResourceManager().method_14486(file).flatMap(resource -> this.loadModel(modelId, file, (class_3298)resource, true, loader));
    }

    @Override
    public Optional<FileContent<JsonElement>> loadModel(class_2960 modelId, class_2960 file, class_3298 resource, boolean failHard, ModelLoader loader) {
        Optional<FileContent<JsonElement>> optional;
        InputStreamReader reader = new InputStreamReader(resource.method_14482(), Charsets.UTF_8);
        try {
            optional = Optional.of(new JsonFileContent(loader, this, modelId, (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                MsonImpl.LOGGER.fatal("Exception whilst loading model file {}", (Object)modelId, (Object)e);
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    @VisibleForTesting
    public Optional<FileContent<JsonElement>> loadModel(class_2960 modelId, Path file, ModelLoader loader) {
        Optional<FileContent<JsonElement>> optional;
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), Charsets.UTF_8);
        try {
            optional = Optional.of(new JsonFileContent(loader, this, modelId, (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class)));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                MsonImpl.LOGGER.fatal("Exception whilst loading model file {}", (Object)modelId, (Object)e);
                return Optional.empty();
            }
        }
        reader.close();
        return optional;
    }

    @Override
    public void registerComponentType(class_2960 id, ModelComponent.Factory<?, JsonElement> constructor) {
        Objects.requireNonNull(id, "Id must not be null");
        Objects.requireNonNull(constructor, "Constructor must not be null");
        MsonImpl.checkNamespace(id.method_12836());
        Preconditions.checkArgument((!this.componentTypes.containsKey(id) ? 1 : 0) != 0, (String)"A component with the id `%s` was already registered", (Object)id);
        this.componentTypes.put(id, constructor);
    }

    @Override
    public <T> Optional<ModelComponent<T>> loadComponent(String name, JsonElement json, class_2960 defaultAs, FileContent<JsonElement> context) {
        JsonPrimitive prim;
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            String fname = Strings.nullToEmpty((String)name).trim();
            if (!o.has("type") && o.has("data")) {
                return Optional.of(new JsonSlot(context, name, o));
            }
            return Optional.ofNullable(this.componentTypes.get(JsonUtil.accept(o, "type").map(JsonElement::getAsString).map(class_2960::method_60654).orElse(defaultAs))).map(c -> c.load(context, fname, json));
        }
        if (json.isJsonPrimitive() && (prim = json.getAsJsonPrimitive()).isString()) {
            String s = prim.getAsString();
            if (s.startsWith("#")) {
                return Optional.of(new JsonLink(s));
            }
            return Optional.of(new JsonImport(context, name, prim));
        }
        throw new UnsupportedOperationException("Json was not a js object and could not be resolved to a #link or model reference");
    }
}

