/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.json.elements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.mson.api.Incomplete;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.ModelView;
import com.minelittlepony.mson.api.exception.FutureAwaitException;
import com.minelittlepony.mson.api.export.ModelFileWriter;
import com.minelittlepony.mson.api.model.PartBuilder;
import com.minelittlepony.mson.api.model.Texture;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelComponent;
import com.minelittlepony.mson.api.parser.locals.Local;
import com.minelittlepony.mson.impl.MsonImpl;
import com.minelittlepony.mson.impl.model.json.elements.JsonTexture;
import com.minelittlepony.mson.util.JsonUtil;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_4431;
import net.minecraft.class_630;

public abstract class AbstractJsonParent
implements ModelComponent<class_630> {
    public static final class_2960 ID = MsonImpl.id("compound");
    private static final float RADS_DEGS_FACTOR = (float)Math.PI / 180;
    private final Incomplete<float[]> pivot;
    protected final Incomplete<float[]> dilate;
    private final Incomplete<float[]> rotate;
    private final boolean[] mirror = new boolean[3];
    private final boolean visible;
    protected final Incomplete<Texture> texture;
    protected final String name;

    public AbstractJsonParent(FileContent<JsonElement> context, String name, JsonObject json) {
        this.pivot = Local.array(json, "pivot", 3, context.getLocals().getModelId());
        this.dilate = Local.array(json, "dilate", 3, context.getLocals().getModelId());
        this.rotate = Local.array(json, "rotate", 3, context.getLocals().getModelId());
        JsonUtil.acceptBooleans(json, "mirror", this.mirror);
        this.visible = class_4431.method_21548((String)"visible", (JsonObject)json, (boolean)true);
        this.texture = JsonTexture.incomplete(JsonUtil.accept(json, "texture"));
        this.name = JsonUtil.accept(json, "name").map(JsonElement::getAsString).map(n -> {
            context.addNamedComponent((String)n, this);
            return n;
        }).orElse("");
    }

    @Override
    public class_630 export(ModelContext context) {
        return context.computeIfAbsent(this.name, key -> {
            PartBuilder builder = this.createBuilder(context);
            this.export(context.bind(builder, x$0 -> new Locals((ModelView.Locals)x$0)), builder);
            return builder.build();
        });
    }

    @Override
    public void write(ModelContext context, ModelFileWriter writer) {
        writer.writePart(this.name, this.createBuilder(context), (w, builder) -> this.write(context.bind(builder, x$0 -> new Locals((ModelView.Locals)x$0)), (PartBuilder)builder, (ModelFileWriter)w));
    }

    protected void export(ModelContext context, PartBuilder builder) throws FutureAwaitException {
    }

    protected void write(ModelContext context, PartBuilder builder, ModelFileWriter writer) {
    }

    protected PartBuilder createBuilder(ModelContext context) throws FutureAwaitException {
        float[] rotate = this.rotate.complete(context);
        PartBuilder builder = new PartBuilder();
        builder.hidden(!this.visible).pivot(this.pivot.complete(context)).mirror(this.mirror).rotate(rotate[0] * ((float)Math.PI / 180), rotate[1] * ((float)Math.PI / 180), rotate[2] * ((float)Math.PI / 180)).tex(this.texture.complete(context));
        return builder;
    }

    protected class Locals
    implements ModelView.Locals {
        private final ModelView.Locals parent;

        Locals(ModelView.Locals parent) {
            this.parent = parent;
        }

        @Override
        public class_2960 getModelId() {
            return this.parent.getModelId();
        }

        @Override
        public float[] getDilation() {
            float[] inherited = this.parent.getDilation();
            float[] dilation = AbstractJsonParent.this.dilate.complete(this.parent);
            return new float[]{inherited[0] + dilation[0], inherited[1] + dilation[1], inherited[2] + dilation[2]};
        }

        @Override
        public Texture getTexture() {
            return AbstractJsonParent.this.texture.complete(this.parent);
        }

        @Override
        public float getLocal(String name, float defaultValue) {
            return this.parent.getLocal(name, defaultValue);
        }

        @Override
        public Set<String> keys() {
            return this.parent.keys();
        }
    }
}

