/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.json.elements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.export.ModelFileWriter;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelComponent;
import com.minelittlepony.mson.api.parser.locals.LocalBlock;
import com.minelittlepony.mson.impl.MsonImpl;
import com.minelittlepony.mson.util.JsonUtil;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2960;
import net.minecraft.class_630;

public class JsonImport
implements ModelComponent<class_630> {
    public static final class_2960 ID = MsonImpl.id("import");
    private final CompletableFuture<FileContent<?>> file;
    private final Optional<LocalBlock> locals;
    private final String name;

    public JsonImport(FileContent<JsonElement> context, String name, JsonPrimitive file) {
        this.name = name;
        this.file = context.resolve((JsonElement)file);
        this.locals = Optional.empty();
    }

    public JsonImport(FileContent<JsonElement> context, String name, JsonElement json) {
        this(context, name, json.getAsJsonObject());
    }

    public JsonImport(FileContent<JsonElement> context, String name, JsonObject json) {
        this.name = name.isEmpty() ? JsonUtil.accept(json, "name").map(JsonElement::getAsString).orElse("") : name;
        this.file = context.resolve(json.get("data"));
        this.locals = Optional.of(LocalBlock.of(JsonUtil.accept(json, "locals")));
        context.addNamedComponent(this.name, this);
    }

    @Override
    public class_630 export(ModelContext context) {
        return context.computeIfAbsent(this.name, key -> this.convertContextToTree(context.extendWith(this.file.get(), parent -> parent.extendWith(parent.getModelId(), this.locals.map(l -> l.bind(context.getLocals())), Optional.empty()))));
    }

    @Override
    public void write(ModelContext context, ModelFileWriter writer) {
        try {
            FileContent<?> fileContent = this.file.get();
            Set<String> components = fileContent.getComponentNames().get();
            if (components.size() != 1) {
                throw new JsonParseException("Imported file must define exactly one part.");
            }
            String name = (String)components.stream().findFirst().get();
            ModelContext boundContext = context.extendWith(this.file.get(), parent -> parent.extendWith(parent.getModelId(), this.locals.map(l -> l.bind(context.getLocals())), Optional.empty()));
            writer.write(name, boundContext, fileContent.getComponent(name).get());
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    private class_630 convertContextToTree(ModelContext context) {
        HashMap<String, class_630> tree = new HashMap<String, class_630>();
        context.getTree(tree);
        if (tree.size() != 1) {
            throw new JsonParseException("Imported file must define exactly one part.");
        }
        return (class_630)tree.values().stream().findFirst().get();
    }
}

