/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.json.elements;

import com.google.common.collect.Streams;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.export.ModelFileWriter;
import com.minelittlepony.mson.api.model.BoxBuilder;
import com.minelittlepony.mson.api.model.BoxParameters;
import com.minelittlepony.mson.api.model.QuadsBuilder;
import com.minelittlepony.mson.api.model.Texture;
import com.minelittlepony.mson.api.model.Vert;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelComponent;
import com.minelittlepony.mson.impl.MsonImpl;
import com.minelittlepony.mson.util.JsonUtil;
import java.util.List;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4431;
import net.minecraft.class_630;

public class JsonQuads
implements ModelComponent<class_630.class_628>,
QuadsBuilder {
    public static final class_2960 ID = MsonImpl.id("quads");
    private final List<JsonQuad> quads;
    private final int texU;
    private final int texV;

    public JsonQuads(FileContent<JsonElement> context, String name, JsonElement json) {
        this(context, name, json.getAsJsonObject());
    }

    public JsonQuads(FileContent<JsonElement> context, String name, JsonObject json) {
        this.texU = JsonUtil.require(json, "u", ID, context.getLocals().getModelId()).getAsInt();
        this.texV = JsonUtil.require(json, "v", ID, context.getLocals().getModelId()).getAsInt();
        List<JsonVertex> vertices = Streams.stream((Iterable)JsonUtil.require(json, "vertices", ID, context.getLocals().getModelId()).getAsJsonArray()).map(JsonVertex::fromJson).toList();
        this.quads = Streams.stream((Iterable)JsonUtil.require(json, "faces", ID, context.getLocals().getModelId()).getAsJsonArray()).map(v -> JsonQuad.fromJson(context, vertices, v)).toList();
    }

    @Override
    public class_630.class_628 export(ModelContext context) {
        return new BoxBuilder(context).tex(new Texture(this.texU, this.texV, 0, 0)).quads(this).build();
    }

    @Override
    public void write(ModelContext context, ModelFileWriter writer) {
        writer.writeBox(new BoxBuilder(context).tex(new Texture(this.texU, this.texV, 0, 0)).quads(this));
    }

    @Override
    public void build(BoxParameters pars, BoxBuilder box, QuadsBuilder.QuadBuffer buffer) {
        this.quads.forEach(q -> q.build(box, buffer));
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    record JsonQuad(int x, int y, int w, int h, List<JsonVertex> verts) {
        static JsonQuad fromJson(FileContent<JsonElement> context, List<JsonVertex> vertices, JsonElement json) {
            JsonObject o = json.getAsJsonObject();
            return new JsonQuad(class_4431.method_21545((String)"x", (JsonObject)o, (int)0), class_4431.method_21545((String)"y", (JsonObject)o, (int)0), class_4431.method_21545((String)"w", (JsonObject)o, (int)0), class_4431.method_21545((String)"h", (JsonObject)o, (int)0), Streams.stream((Iterable)JsonUtil.require(o, "vertices", ID, context.getLocals().getModelId()).getAsJsonArray()).map(JsonElement::getAsInt).map(vertices::get).toList());
        }

        void build(BoxBuilder builder, QuadsBuilder.QuadBuffer buffer) {
            buffer.quad(class_2350.field_11036, (float)this.x, (float)this.y, (float)this.w, (float)this.h, builder.parameters.mirror[0], (Vert[])this.verts.stream().map(v -> v.build(builder)).toArray(Vert[]::new));
        }
    }

    record JsonVertex(float x, float y, float z, int u, int v) {
        static JsonVertex fromJson(JsonElement json) {
            if (json.isJsonArray()) {
                JsonArray arr = json.getAsJsonArray();
                return new JsonVertex(arr.get(0).getAsFloat(), arr.get(1).getAsFloat(), arr.get(2).getAsFloat(), arr.get(3).getAsInt(), arr.get(4).getAsInt());
            }
            JsonObject o = json.getAsJsonObject();
            return new JsonVertex(JsonUtil.getFloatOr("x", o, 0.0f), JsonUtil.getFloatOr("y", o, 0.0f), JsonUtil.getFloatOr("z", o, 0.0f), class_4431.method_21545((String)"u", (JsonObject)o, (int)0), class_4431.method_21545((String)"v", (JsonObject)o, (int)0));
        }

        Vert build(BoxBuilder builder) {
            return builder.vert(this.x, this.y, this.z, this.u, this.v);
        }
    }
}

