/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.json.elements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minelittlepony.mson.api.InstanceCreator;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.export.ModelFileWriter;
import com.minelittlepony.mson.api.model.Texture;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelComponent;
import com.minelittlepony.mson.api.parser.locals.LocalBlock;
import com.minelittlepony.mson.impl.MsonImpl;
import com.minelittlepony.mson.impl.model.json.elements.JsonTexture;
import com.minelittlepony.mson.util.JsonUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2960;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public class JsonSlot<T>
implements ModelComponent<T> {
    public static final class_2960 ID = MsonImpl.id("slot");
    private final Optional<InstanceCreator<T>> implementation;
    private final CompletableFuture<FileContent<?>> data;
    private final LocalBlock locals;
    private final Optional<Texture> texture;
    private final String name;
    private final class_2960 id;

    public JsonSlot(FileContent<JsonElement> context, String name, JsonElement json) {
        this(context, name, json.getAsJsonObject());
    }

    public JsonSlot(FileContent<JsonElement> context, String name, JsonObject json) {
        this.implementation = JsonUtil.accept(json, "implementation").map(JsonElement::getAsString).map(InstanceCreator::byName);
        this.data = context.resolve(json.get("data"));
        this.name = name.isEmpty() ? JsonUtil.require(json, "name", ID, context.getLocals().getModelId()).getAsString() : name;
        this.texture = JsonUtil.accept(json, "texture").map(JsonTexture::of);
        this.id = class_2960.method_60655((String)"dynamic", (String)(context.getLocals().getModelId().method_12832() + "/" + this.name));
        this.locals = LocalBlock.of(JsonUtil.accept(json, "locals"));
        context.addNamedComponent(this.name, this);
    }

    @Override
    public <K> Optional<K> tryExportTreeNodes(ModelContext context, Class<K> type) {
        if (this.implementation.isPresent() && !this.implementation.get().isCompatible(type)) {
            return Optional.empty();
        }
        Optional<K> value = this.tryExport(context, type);
        if (!this.implementation.isPresent()) {
            return Optional.empty();
        }
        return value;
    }

    @Override
    @Nullable
    public T export(ModelContext context) {
        return this.compile(context).result();
    }

    @Override
    public <K> Optional<K> export(ModelContext context, InstanceCreator<K> customType) {
        CompiledSlot compiled = this.compile(context);
        if (this.implementation.filter(i -> i.isCompatible(customType)).isPresent()) {
            return Optional.ofNullable(compiled.result());
        }
        return Optional.ofNullable(customType.createInstance(compiled.sourceContext(), ctx -> compiled.tree()));
    }

    private CompiledSlot<T> compile(ModelContext context) {
        return context.computeIfAbsent(this.name, key -> {
            ModelContext subContext = context.extendWith(this.data.get(), parent -> parent.extendWith(this.id, Optional.of(this.locals.bind(context.getLocals())), this.texture));
            class_630 tree = subContext.toTree();
            Object result = this.implementation.map(type -> type.createInstance(subContext, ctx -> tree)).orElse(null);
            return new CompiledSlot<Object>(result, tree, subContext);
        });
    }

    @Override
    public void write(ModelContext context, ModelFileWriter writer) {
        try {
            FileContent<?> content = this.data.get();
            writer.writeTree(this.name, content, context.extendWith(content, parent -> parent.extendWith(this.id, Optional.of(this.locals.bind(context.getLocals())), this.texture)));
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    record CompiledSlot<T>(@Nullable T result, class_630 tree, ModelContext sourceContext) {
    }
}

