/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.api;

import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.impl.key.ReflectedModelKey;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;

public interface InstanceCreator<T> {
    public static final InstanceCreator<class_630> DEFAULT = InstanceCreator.ofFunction(class_630.class, Function.identity());

    public static <T> InstanceCreator<T> ofPart() {
        return DEFAULT;
    }

    public static <T> InstanceCreator<T> byName(String className) {
        return ReflectedModelKey.byName(className);
    }

    public static <T> InstanceCreator<T> ofType(Class<T> type) {
        return ReflectedModelKey.byType(type);
    }

    public static <T> InstanceCreator<T> ofFunction(Class<T> type, Function<class_630, T> function) {
        return new ReflectedModelKey(Optional.empty(), Optional.of(function), type);
    }

    public static <T> InstanceCreator<T> ofFactory(Class<T> type, Function<ModelContext, T> factory) {
        return new ReflectedModelKey<T>(Optional.of(factory), Optional.empty(), type);
    }

    public static <T> InstanceCreator<T> ofSupplier(Class<T> type, Supplier<T> supplier) {
        return new ReflectedModelKey(Optional.of(ctx -> supplier.get()), Optional.of(tree -> supplier.get()), type);
    }

    @Nullable
    public Class<T> type();

    public boolean isCompatible(Class<?> var1);

    default public boolean isCompatible(InstanceCreator<?> toType) {
        return this.isCompatible(toType.type());
    }

    public T createInstance(ModelContext var1);

    public T createInstance(ModelContext var1, Function<ModelContext, class_630> var2);
}

