/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.api.model;

import com.minelittlepony.mson.api.model.BoxBuilder;
import com.minelittlepony.mson.api.model.BoxParameters;
import com.minelittlepony.mson.api.model.Face;
import com.minelittlepony.mson.api.model.Texture;
import com.minelittlepony.mson.api.model.Vert;
import com.minelittlepony.mson.impl.MsonImpl;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public interface QuadsBuilder {
    public static final class_2960 CONE = MsonImpl.id("cone");
    public static final class_2960 PLANE = MsonImpl.id("plane");
    public static final class_2960 CUBE = MsonImpl.id("cube");
    public static final int[][] FACE_VERTEX_OFFSETS = new int[][]{new int[0], {2, 3, 7, 6, 0, 2}, {5, 4, 0, 1, 0, 2}, {0, 4, 7, 3, 2, 1}, {5, 1, 2, 6, 2, 1}, {1, 0, 3, 2, 0, 1}, {4, 5, 6, 7, 0, 1}};
    public static final int[][] VERTEX_MATRIX = new int[][]{{0, 0, 0, 0, 0}, {1, 0, 0, 0, 8}, {1, 1, 0, 8, 8}, {0, 1, 0, 8, 0}, {0, 0, 1, 0, 0}, {1, 0, 1, 0, 8}, {1, 1, 1, 8, 8}, {0, 1, 1, 8, 0}};
    public static final QuadsBuilder BOX = QuadsBuilder.of(CUBE, QuadsBuilder.cone(0.0f)::build);

    public static QuadsBuilder cone(float tipInset) {
        return QuadsBuilder.of(CONE, (pars, ctx, buffer) -> {
            float xMax = pars.position[0] + pars.size[0] + pars.dilation[0];
            float yMax = pars.position[1] + pars.size[1] + pars.dilation[1];
            float zMax = pars.position[2] + pars.size[2] + pars.dilation[2];
            float xMin = pars.position[0] - pars.dilation[0];
            float yMin = pars.position[1] - pars.dilation[1];
            float zMin = pars.position[2] - pars.dilation[2];
            if (pars.mirror[0]) {
                float v = xMax;
                xMax = xMin;
                xMin = v;
            }
            float tipXmin = xMin + ctx.parameters.size[0] * tipInset;
            float tipZmin = zMin + ctx.parameters.size[2] * tipInset;
            float tipXMax = xMax - ctx.parameters.size[0] * tipInset;
            float tipZMax = zMax - ctx.parameters.size[2] * tipInset;
            Vert _0 = ctx.vert(tipXmin, yMin, tipZmin, 0, 0);
            Vert _1 = ctx.vert(tipXMax, yMin, tipZmin, 0, 8);
            Vert _2 = ctx.vert(xMax, yMax, zMin, 8, 8);
            Vert _3 = ctx.vert(xMin, yMax, zMin, 8, 0);
            Vert _4 = ctx.vert(tipXmin, yMin, tipZMax, 0, 0);
            Vert _5 = ctx.vert(tipXMax, yMin, tipZMax, 0, 8);
            Vert _6 = ctx.vert(xMax, yMax, zMax, 8, 8);
            Vert _7 = ctx.vert(xMin, yMax, zMax, 8, 0);
            float u = ctx.parameters.uv.u();
            float v = ctx.parameters.uv.v();
            float dX = ctx.parameters.size[0];
            float dY = ctx.parameters.size[1];
            float dZ = ctx.parameters.size[2];
            float col1 = u;
            float col2 = col1 + dZ;
            float col3 = col2 + dX;
            float col4 = col3 + dZ;
            float row1 = v;
            float row2 = row1 + dZ;
            buffer.quad(class_2350.field_11036, col3, row2, dX, -dZ, _2, _3, _7, _6);
            buffer.quad(class_2350.field_11033, col2, row1, dX, dZ, _5, _4, _0, _1);
            buffer.quad(class_2350.field_11039, col1, row2, dZ, dY, _0, _4, _7, _3);
            buffer.quad(class_2350.field_11034, col3, row2, dZ, dY, _5, _1, _2, _6);
            buffer.quad(class_2350.field_11043, col2, row2, dX, dY, _1, _0, _3, _2);
            buffer.quad(class_2350.field_11035, col4, row2, dX, dY, _4, _5, _6, _7);
        });
    }

    public static QuadsBuilder plane(Face face) {
        return QuadsBuilder.of(PLANE, (pars, ctx, buffer) -> {
            float[][] positionMatrix = new float[][]{pars.position, {pars.position[0] + pars.size[0], pars.position[1] + pars.size[1], pars.position[2] + pars.size[2]}};
            int[] vertexIndices = FACE_VERTEX_OFFSETS[face.ordinal()];
            buffer.quad(face.getNormal(), (float)ctx.parameters.uv.u(), (float)ctx.parameters.uv.v(), ctx.parameters.size[vertexIndices[4]], ctx.parameters.size[vertexIndices[5]], false, ctx.vert(VERTEX_MATRIX[vertexIndices[0]], positionMatrix), ctx.vert(VERTEX_MATRIX[vertexIndices[1]], positionMatrix), ctx.vert(VERTEX_MATRIX[vertexIndices[2]], positionMatrix), ctx.vert(VERTEX_MATRIX[vertexIndices[3]], positionMatrix));
        }, ctx -> {
            BoxParameters pars = ctx.parameters;
            float xMax = pars.position[0] + pars.size[0];
            float yMax = pars.position[1] + pars.size[1];
            float zMax = pars.position[2] + pars.size[2];
            xMax = ctx.fixture.stretchCoordinate(Face.Axis.X, xMax, yMax, zMax, pars.dilation[0]);
            yMax = ctx.fixture.stretchCoordinate(Face.Axis.Y, xMax, yMax, zMax, face.applyFixtures(pars.dilation[1]));
            zMax = ctx.fixture.stretchCoordinate(Face.Axis.Z, xMax, yMax, zMax, pars.dilation[2]);
            float xMin = ctx.fixture.stretchCoordinate(Face.Axis.X, pars.position[0], pars.position[1], pars.position[2], -pars.dilation[0]);
            float yMin = ctx.fixture.stretchCoordinate(Face.Axis.Y, pars.position[0], pars.position[1], pars.position[2], face.applyFixtures(-pars.dilation[1]));
            float zMin = ctx.fixture.stretchCoordinate(Face.Axis.Z, pars.position[0], pars.position[1], pars.position[2], -pars.dilation[2]);
            pars = new BoxParameters(new float[]{xMin, yMin, zMin}, new float[]{xMax - xMin, yMax - yMin, zMax - zMin}, new float[3], pars.uv);
            if (ctx.parameters.mirror[0]) {
                pars.flip(Face.Axis.X);
            }
            if (ctx.parameters.mirror[1]) {
                pars.flip(Face.Axis.Y);
            }
            if (ctx.parameters.mirror[2]) {
                pars.flip(Face.Axis.Z);
            }
            pars.uv = new Texture((int)((float)pars.uv.u() - pars.getBoxFrameUOffset(face.getNormal())), (int)((float)pars.uv.v() - pars.getBoxFrameVOffset(face.getNormal())), pars.uv.width(), pars.uv.height());
            return pars;
        }, ctx -> Set.of(face.getNormal()));
    }

    public void build(BoxParameters var1, BoxBuilder var2, QuadBuffer var3);

    public class_2960 getId();

    default public Set<class_2350> getFaces(BoxBuilder ctx) {
        return Set.of();
    }

    default public BoxParameters getBoxParameters(BoxBuilder ctx) {
        return ctx.parameters;
    }

    public static QuadsBuilder of(final class_2960 id, final QuadGenerator constructor, final Function<BoxBuilder, BoxParameters> parameters, final Function<BoxBuilder, Set<class_2350>> faces) {
        return new QuadsBuilder(){

            @Override
            public void build(BoxParameters params, BoxBuilder ctx, QuadBuffer buffer) {
                constructor.accept(params, ctx, buffer);
            }

            @Override
            public class_2960 getId() {
                return id;
            }

            @Override
            public Set<class_2350> getFaces(BoxBuilder ctx) {
                return (Set)faces.apply(ctx);
            }

            @Override
            public BoxParameters getBoxParameters(BoxBuilder ctx) {
                return (BoxParameters)parameters.apply(ctx);
            }
        };
    }

    public static QuadsBuilder of(class_2960 id, QuadGenerator constructor) {
        return QuadsBuilder.of(id, constructor, ctx -> ctx.parameters, ctx -> BoxBuilder.ALL_DIRECTIONS);
    }

    public static interface QuadGenerator {
        public void accept(BoxParameters var1, BoxBuilder var2, QuadBuffer var3);
    }

    public static interface QuadBuffer {
        public boolean getDefaultMirror();

        default public void quad(class_2350 direction, float u, float v, float w, float h, boolean mirror, boolean remap, Vert ... vertices) {
            this.quad(u, v, w, h, direction, mirror, remap, null, vertices);
        }

        default public void quad(class_2350 direction, float u, float v, float w, float h, boolean mirror, Vert ... vertices) {
            this.quad(direction, u, v, w, h, mirror, true, vertices);
        }

        default public void quad(class_2350 direction, float u, float v, float w, float h, Vert ... vertices) {
            this.quad(direction, u, v, w, h, this.getDefaultMirror(), vertices);
        }

        public void quad(float var1, float var2, float var3, float var4, class_2350 var5, boolean var6, boolean var7, @Nullable Quaternionf var8, Vert ... var9);
    }
}

