/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.api.parser.locals;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.minelittlepony.mson.api.Incomplete;
import com.minelittlepony.mson.api.ModelView;
import com.minelittlepony.mson.api.exception.FutureAwaitException;
import com.minelittlepony.mson.api.parser.locals.Operation;
import com.minelittlepony.mson.util.JsonUtil;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public class Local
implements Incomplete<Float> {
    private final Incomplete<Float> left;
    private final Operation operation;
    private final Incomplete<Float> right;

    private Local(JsonArray tokens) {
        if (tokens.size() != 3) {
            throw new JsonParseException(String.format("Saw a local of %d members. Expected 3 of (left, op, right).", tokens.size()));
        }
        this.operation = Operation.of(tokens.get(1).getAsString());
        if (this.operation == Operation.VAR) {
            throw new JsonParseException("Invalid operation. One of [+,-,*,/]");
        }
        this.left = Local.create(tokens.get(0));
        this.right = Local.create(tokens.get(2));
    }

    @Override
    public Float complete(ModelView.Locals locals) throws FutureAwaitException {
        return this.operation.apply(this.left.complete(locals), this.right.complete(locals));
    }

    public static Incomplete<Float> create(JsonElement json) {
        if (json.isJsonPrimitive()) {
            return Local.ref(json.getAsJsonPrimitive());
        }
        if (json.isJsonArray()) {
            return new Local(json.getAsJsonArray());
        }
        throw new JsonParseException("Unsupported local type. A local must be either a value (number) string (#variable) or an array");
    }

    public static Incomplete<Float> ref(JsonPrimitive prim) {
        if (prim.isNumber()) {
            return Incomplete.completed(Float.valueOf(prim.getAsFloat()));
        }
        if (prim.isString()) {
            String variableName = prim.getAsString();
            if (variableName.startsWith("#")) {
                String name = variableName.substring(1);
                return local -> Float.valueOf(local.getLocal(name, 0.0f));
            }
            return Incomplete.ZERO;
        }
        throw new JsonParseException("Unsupported local value type: " + prim.toString());
    }

    public static Incomplete<float[]> array(JsonPrimitive ... arr) {
        return Local.toFloats((Incomplete[])Stream.of(arr).map(Local::ref).toArray(Incomplete[]::new));
    }

    public static Incomplete<float[]> array(JsonObject json, String member, int len, class_2960 modelId) {
        return Local.toFloats(JsonUtil.accept(json, member).map(js -> {
            Object[] output = Local.zeros(len);
            if (!js.isJsonArray()) {
                Arrays.fill(output, Local.ref(js.getAsJsonPrimitive()));
            } else {
                JsonArray arr = js.getAsJsonArray();
                for (int i = 0; i < len && i < arr.size(); ++i) {
                    if (!arr.get(i).isJsonPrimitive()) {
                        throw new JsonParseException(String.format("Non-primitive type found in array for model %s. Can only be values (Number) or variable references (#variable). %s", modelId, arr));
                    }
                    output[i] = Local.ref(arr.get(i).getAsJsonPrimitive());
                }
            }
            return output;
        }).orElseGet(() -> Local.zeros(len)));
    }

    public static Incomplete<Float> ref(JsonObject json, String member, class_2960 modelId) {
        JsonElement js = JsonUtil.require(json, member, "Locals", modelId);
        if (!js.isJsonPrimitive()) {
            throw new JsonParseException(String.format("Non-primitive type found in member %s for model %s. Can only be values (Number) or variable references (#variable). %s", member, modelId, js));
        }
        return Local.ref(js.getAsJsonPrimitive());
    }

    private static Incomplete<Float>[] zeros(int len) {
        Object[] output = new Incomplete[len];
        Arrays.fill(output, Incomplete.ZERO);
        return output;
    }

    private static Incomplete<float[]> toFloats(Incomplete<Float>[] input) {
        return locals -> {
            float[] result = new float[input.length];
            for (int i = 0; i < input.length; ++i) {
                result[i] = ((Float)input[i].complete(locals)).floatValue();
            }
            return result;
        };
    }
}

