/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl;

import com.minelittlepony.mson.api.ModelView;
import com.minelittlepony.mson.api.exception.FutureAwaitException;
import com.minelittlepony.mson.api.model.Texture;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.util.Maps;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_2960;

public final class ModelLocalsImpl
implements ModelView.Locals {
    private final FileContent.Locals context;
    private final Map<String, CompletableFuture<Float>> precalculatedValues = new TreeMap<String, CompletableFuture<Float>>();

    public ModelLocalsImpl(FileContent.Locals context) {
        this.context = context;
    }

    @Override
    public class_2960 getModelId() {
        return this.context.getModelId();
    }

    @Override
    public float[] getDilation() {
        try {
            return this.context.getDilation().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new FutureAwaitException(e);
        }
    }

    @Override
    public Texture getTexture() {
        try {
            return this.context.getTexture().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new FutureAwaitException(e);
        }
    }

    @Override
    public float getLocal(String name, float defaultValue) {
        try {
            return ((Float)Maps.computeIfAbsent(this.precalculatedValues, name, n -> this.context.getLocal((String)n, defaultValue).thenApplyAsync(value -> (Float)value.complete(new StackFrame(this, (String)n)))).get()).floatValue();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new FutureAwaitException(e);
        }
    }

    @Override
    public Set<String> keys() {
        try {
            return this.context.keys().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new FutureAwaitException(e);
        }
    }

    public String toString() {
        return "[ModelLocalsImpl id=" + this.context.getModelId().toString() + "]";
    }

    private static final class StackFrame
    implements ModelView.Locals {
        private final String currentVariableRef;
        private final ModelView.Locals parent;

        private StackFrame(ModelView.Locals parent, String currentVariableRef) {
            this.currentVariableRef = currentVariableRef;
            this.parent = parent;
        }

        @Override
        public class_2960 getModelId() {
            return this.parent.getModelId();
        }

        @Override
        public Texture getTexture() {
            return this.parent.getTexture();
        }

        @Override
        public float[] getDilation() {
            return this.parent.getDilation();
        }

        @Override
        public float getLocal(String name, float defaultValue) {
            if (this.currentVariableRef.equalsIgnoreCase(name)) {
                throw new RuntimeException("Cyclical reference. " + this.toString());
            }
            return this.parent.getLocal(name, defaultValue);
        }

        @Override
        public Set<String> keys() {
            return this.parent.keys();
        }

        public String toString() {
            return this.parent.toString() + " -> " + this.currentVariableRef;
        }
    }
}

