/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.ModelKey;
import com.minelittlepony.mson.api.Mson;
import com.minelittlepony.mson.api.MsonModel;
import com.minelittlepony.mson.api.exception.FutureAwaitException;
import com.minelittlepony.mson.api.model.traversal.SkeletonisedModel;
import com.minelittlepony.mson.api.model.traversal.Traversable;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelFormat;
import com.minelittlepony.mson.impl.LoadWorker;
import com.minelittlepony.mson.impl.ModelFoundry;
import com.minelittlepony.mson.impl.MsonMod;
import com.minelittlepony.mson.impl.PendingEntityRendererRegistry;
import com.minelittlepony.mson.impl.Test;
import com.minelittlepony.mson.impl.key.AbstractModelKeyImpl;
import com.minelittlepony.mson.impl.mixin.ModelListAccessor;
import com.minelittlepony.mson.impl.model.RootContext;
import com.minelittlepony.mson.impl.model.bbmodel.BBModelFormat;
import com.minelittlepony.mson.impl.model.json.MsonModelFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3302;
import net.minecraft.class_3879;
import net.minecraft.class_630;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MsonImpl
implements Mson,
class_3302 {
    public static final Logger LOGGER = LogManager.getLogger((String)"Mson");
    public static final MsonImpl INSTANCE = new MsonImpl();
    public static final class_2960 RELOADER_ID = MsonImpl.id("models");
    private final PendingEntityRendererRegistry renderers = new PendingEntityRendererRegistry();
    private final Map<class_2960, Key<?>> registeredModels = new HashMap();
    final Map<class_2960, ModelFormat<?>> formatHandlers = new HashMap();
    final Map<String, Set<ModelFormat<?>>> handlersByExtension = new HashMap();
    private final AtomicReference<ModelFoundry> foundry = new AtomicReference<ModelFoundry>(new ModelFoundry(this));
    @Nullable
    private volatile CompletableFuture<Void> vanillaModelsReloadTask = null;

    public static class_2960 id(String name) {
        return class_2960.method_60655((String)"mson", (String)name);
    }

    private MsonImpl() {
        this.registerModelFormatHandler(ModelFormat.MSON, MsonModelFormat.INSTANCE);
        this.registerModelFormatHandler(ModelFormat.BBMODEL, BBModelFormat.INSTANCE);
    }

    public Stream<ModelFormat<?>> getHandlers(String extension) {
        return this.handlersByExtension.getOrDefault(extension, Set.of()).stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVanillaModelsPrepared(CompletableFuture<Void> reloadTask) {
        MsonImpl msonImpl = this;
        synchronized (msonImpl) {
            this.vanillaModelsReloadTask = reloadTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVanillaModelsApplied() {
        MsonImpl msonImpl = this;
        synchronized (msonImpl) {
            ((ModelListAccessor)class_310.method_1551().method_31974()).getModelParts().forEach((layer, vanilla) -> {
                class_2960 id = layer.comp_2995().method_45134(p -> String.format("mson/%s", p));
                ((KeyHolder)vanilla).setKey(this.registeredModels.computeIfAbsent(id, x$0 -> new VanillaKey(this, (class_2960)x$0)));
            });
            if (MsonMod.DEBUG) {
                Test.exportVanillaModels(this.foundry.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> requireVanillaModels(class_3302.class_11558 store, Executor computeExecutor, class_3302.class_4045 sync, Executor applyExecutor) {
        MsonImpl msonImpl = this;
        synchronized (msonImpl) {
            if (this.vanillaModelsReloadTask == null) {
                LOGGER.info("Vanilla models are not ready, preparing them ourselves...");
                class_310.method_1551().method_1554().method_25931(store, computeExecutor, sync, applyExecutor);
                if (this.vanillaModelsReloadTask == null) {
                    LOGGER.info("Vanilla models did not prepare. Some errors may occur");
                    return CompletableFuture.completedFuture(null);
                }
            }
            if (this.vanillaModelsReloadTask.isDone()) {
                return CompletableFuture.completedFuture(null);
            }
            LOGGER.info("Vanilla models are still preparing. Apply stage will be delayed until vanilla models are ready.");
            return this.vanillaModelsReloadTask;
        }
    }

    public CompletableFuture<Void> method_25931(class_3302.class_11558 store, Executor computeExecutor, class_3302.class_4045 sync, Executor applyExecutor) {
        ModelFoundry loadingFoundry = new ModelFoundry(this).setWorker(LoadWorker.async(computeExecutor));
        return ((CompletableFuture)((CompletableFuture)loadingFoundry.load().thenCompose(arg_0 -> ((class_3302.class_4045)sync).method_18352(arg_0))).thenComposeAsync(v -> this.requireVanillaModels(store, computeExecutor, sync, applyExecutor), computeExecutor)).thenRunAsync(() -> {
            this.foundry.set(loadingFoundry.setWorker(LoadWorker.sync()));
            this.renderers.initialize();
            if (MsonMod.DEBUG) {
                Test.exportBbModels(this.registeredModels.values());
            }
        }, applyExecutor);
    }

    @Override
    public PendingEntityRendererRegistry getEntityRendererRegistry() {
        return this.renderers;
    }

    @Override
    public <T extends class_3879<?>> ModelKey<T> registerModel(class_2960 id, MsonModel.Factory<T> constructor) {
        Objects.requireNonNull(id, "Id must not be null");
        Objects.requireNonNull(constructor, "Implementation class must not be null");
        MsonImpl.checkNamespace(id.method_12836());
        Preconditions.checkArgument((!this.registeredModels.containsKey(id) ? 1 : 0) != 0, (String)"A model with the id `%s` was already registered", (Object)id);
        return this.registeredModels.computeIfAbsent(id, i -> new Key(id, constructor));
    }

    public static void checkNamespace(String namespace) {
        Preconditions.checkArgument((!"minecraft".equalsIgnoreCase(namespace) ? 1 : 0) != 0, (Object)"Id must have a namespace other than `minecraft`.");
        Preconditions.checkArgument((!"mson".equalsIgnoreCase(namespace) ? 1 : 0) != 0, (Object)"`mson` is a reserved namespace.");
        Preconditions.checkArgument((!"dynamic".equalsIgnoreCase(namespace) ? 1 : 0) != 0, (Object)"`dynamic` is a reserved namespace.");
    }

    @Override
    public ModelFormat<JsonElement> getDefaultFormatHandler() {
        return MsonModelFormat.INSTANCE;
    }

    @Override
    public <Data, T extends ModelFormat<Data>> T registerModelFormatHandler(class_2960 id, T format) {
        Objects.requireNonNull(id, "Id must not be null");
        Objects.requireNonNull(format, "Format must not be null");
        Objects.requireNonNull(format.getFileExtension(), "Format must have a valid, non-null, non-empty file extension");
        Preconditions.checkArgument((!format.getFileExtension().isEmpty() ? 1 : 0) != 0, (Object)"Format must have a valid, non-null, non-empty file extension");
        Preconditions.checkArgument((!format.getFileExtension().startsWith(".") ? 1 : 0) != 0, (Object)"Extension must not have a leading decimal (.)");
        if (this.formatHandlers.containsKey(id)) {
            LOGGER.warn("A format handler with id `{}`and extension {} and has already been registered.", (Object)id, (Object)this.formatHandlers.get(id).getFileExtension());
            return (T)this.formatHandlers.get(id);
        }
        this.formatHandlers.put(id, format);
        this.handlersByExtension.computeIfAbsent(format.getFileExtension(), e -> new HashSet()).add(format);
        return format;
    }

    @Override
    public <Data> Optional<ModelFormat<Data>> getFormatHandler(class_2960 id) {
        return Optional.ofNullable(this.formatHandlers.get(id));
    }

    private class Key<T extends class_3879<?>>
    extends AbstractModelKeyImpl<T> {
        private final MsonModel.Factory<T> constr;

        public Key(class_2960 id, MsonModel.Factory<T> constr) {
            this.id = id;
            this.constr = constr;
        }

        @Override
        public <V extends T> V createModel() {
            return (V)this.createModel(this.constr);
        }

        @Override
        public Optional<class_630> createTree() {
            return this.getModelData().map(context -> context.createContext(null, null, context.getLocals().bake()).toTree());
        }

        @Override
        public <V extends T> V createModel(MsonModel.Factory<V> factory) {
            Preconditions.checkNotNull(factory, (Object)"Factory should not be null");
            return (V)this.getModelData().map(context -> {
                ModelContext ctx = context.createContext(null, null, context.getLocals().bake());
                class_630 root = ctx.toTree();
                class_3879 t = (class_3879)factory.create(root);
                if (t instanceof SkeletonisedModel) {
                    SkeletonisedModel sk = (SkeletonisedModel)t;
                    sk.setSkeleton(context.getSkeleton().map(arg_0 -> root.ordered(arg_0)).orElse((Traversable)root));
                }
                if (t instanceof MsonModel) {
                    MsonModel mm = (MsonModel)t;
                    if (ctx instanceof RootContext) {
                        RootContext c = (RootContext)ctx;
                        c.setModel(t);
                    }
                    mm.init(ctx);
                }
                return t;
            }).orElseThrow(() -> new IllegalStateException("Model file for " + String.valueOf(this.getId()) + " was not loaded!"));
        }

        @Override
        public Optional<FileContent<?>> getModelData() {
            try {
                return MsonImpl.this.foundry.get().getOrLoadModelData(this);
            }
            catch (FutureAwaitException | InterruptedException | ExecutionException e) {
                throw new RuntimeException("Could not create model", e);
            }
        }
    }

    public static interface KeyHolder {
        public void setKey(ModelKey<?> var1);
    }

    private final class VanillaKey<T extends class_3879<?>>
    extends Key<T> {
        VanillaKey(MsonImpl msonImpl, class_2960 id) {
            super(id, null);
        }

        @Override
        public <V extends T> V createModel() {
            throw new IllegalStateException("Cannot create a model for a key (" + String.valueOf(this.getId()) + ") with unknown type. For built-in models please use createModel(factory)");
        }
    }
}

