/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.fast;

import com.minelittlepony.mson.api.model.Cube;
import com.minelittlepony.mson.impl.fast.PartAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class FastModelPart
extends class_630 {
    static final float SCALE_FACTOR = 0.0625f;
    private boolean compiled;
    private boolean empty;
    private class_630[] parts;
    private ResettableVertex[] vertices;
    private ResettableVertex[] normals;
    private Fragment[] fragments;

    public FastModelPart(List<class_630.class_628> cuboids, Map<String, class_630> children, float[] rotate, float[] pivot, boolean hidden) {
        super(cuboids, children);
        this.method_33425(rotate[0], rotate[1], rotate[2]);
        this.method_2851(pivot[0], pivot[1], pivot[2]);
        this.method_41918(this.method_32084());
        this.field_3665 = !hidden;
    }

    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, int color) {
        this.computeContents();
        if (!this.field_3665 || this.empty) {
            return;
        }
        matrices.method_22903();
        this.method_22703(matrices);
        if (!this.field_38456) {
            class_4587.class_4665 entry = matrices.method_23760();
            this.fastRenderCuboids(entry, vertices, light, overlay, color);
        }
        for (class_630 modelPart : this.parts) {
            modelPart.method_22699(matrices, vertices, light, overlay, color);
        }
        matrices.method_22909();
    }

    private void computeContents() {
        if (this.compiled) {
            return;
        }
        PartAccessor accessor = (PartAccessor)((Object)this);
        this.empty = accessor.getCuboids().isEmpty() && accessor.getChildren().isEmpty();
        this.parts = (class_630[])accessor.getChildren().values().toArray(class_630[]::new);
        HashMap vertices = new HashMap();
        HashMap normals = new HashMap();
        ArrayList<Fragment> fragments = new ArrayList<Fragment>();
        for (class_630.class_628 cube : accessor.getCuboids()) {
            Cube cu = (Cube)cube;
            for (int i = 0; i < cu.sideCount(); ++i) {
                class_630.class_593 quad = (class_630.class_593)cu.getSide(i);
                for (class_630.class_618 vert2 : quad.comp_3184()) {
                    fragments.add(new Fragment(vert2.comp_3187(), vert2.comp_3188(), (Vector3f)vertices.computeIfAbsent(new Vector3f(vert2.getPos()), Function.identity()), (Vector3f)normals.computeIfAbsent(new Vector3f(quad.comp_3185()), Function.identity())));
                }
            }
        }
        this.fragments = (Fragment[])fragments.toArray(Fragment[]::new);
        this.vertices = (ResettableVertex[])vertices.keySet().stream().map(vert -> new ResettableVertex((Vector3f)vert, new Vector3f((Vector3fc)vert).mul(0.0625f))).toArray(ResettableVertex[]::new);
        this.normals = (ResettableVertex[])normals.keySet().stream().map(norm -> new ResettableVertex((Vector3f)norm, new Vector3f((Vector3fc)norm))).toArray(ResettableVertex[]::new);
        this.compiled = true;
    }

    private void fastRenderCuboids(class_4587.class_4665 entry, class_4588 vertexConsumer, int light, int overlay, int color) {
        Matrix4f positionMatrix = entry.method_23761();
        Matrix3f normalMatrix = entry.method_23762();
        Vector4f position = new Vector4f();
        for (ResettableVertex resettableVertex : this.vertices) {
            resettableVertex.transformPosition(positionMatrix, position);
        }
        for (ResettableVertex resettableVertex : this.normals) {
            resettableVertex.transformNormal(normalMatrix);
        }
        for (Record record : this.fragments) {
            Vector3f pos = ((Fragment)record).pos();
            Vector3f norm = ((Fragment)record).norm();
            vertexConsumer.method_23919(pos.x, pos.y, pos.z, color, ((Fragment)record).u(), ((Fragment)record).v(), overlay, light, norm.x, norm.y, norm.z);
        }
    }

    private record Fragment(float u, float v, Vector3f pos, Vector3f norm) {
    }

    private record ResettableVertex(Vector3f vertex, Vector3f pos) {
        void transformPosition(Matrix4f matrix, Vector4f rotationSpace) {
            matrix.transform(rotationSpace.set((Vector3fc)this.pos, 1.0f));
            this.vertex.set(rotationSpace.x(), rotationSpace.y(), rotationSpace.z());
        }

        void transformNormal(Matrix3f matrix) {
            matrix.transform(this.vertex.set((Vector3fc)this.pos));
        }
    }
}

