/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.bbmodel.elements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.export.ModelFileWriter;
import com.minelittlepony.mson.api.model.BoxBuilder;
import com.minelittlepony.mson.api.model.BoxParameters;
import com.minelittlepony.mson.api.model.Face;
import com.minelittlepony.mson.api.model.QuadsBuilder;
import com.minelittlepony.mson.api.model.Texture;
import com.minelittlepony.mson.api.model.Vert;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelComponent;
import com.minelittlepony.mson.util.JsonUtil;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_630;
import org.joml.Quaternionf;

public class BbCube
implements ModelComponent<class_630.class_628>,
QuadsBuilder {
    public static final class_2960 ID = class_2960.method_60655((String)"blockbench", (String)"cube");
    private final boolean boxUv;
    private final float[] from = new float[3];
    private final float[] to = new float[3];
    private final float[] origin = new float[3];
    private final Map<Face, CubeFace> faces;
    private final Texture texture;
    public final Optional<UUID> uuid;

    public BbCube(FileContent<JsonElement> context, String name, JsonElement json) {
        this(context, name, json.getAsJsonObject());
    }

    public BbCube(FileContent<JsonElement> context, String name, JsonObject json) {
        this.boxUv = class_3518.method_15258((JsonObject)json, (String)"box_uv", (boolean)true);
        JsonUtil.acceptFloats(json, "from", this.from);
        JsonUtil.acceptFloats(json, "to", this.to);
        JsonUtil.acceptFloats(json, "origin", this.origin);
        float[] uvOffset = new float[2];
        JsonUtil.acceptFloats(json, "uv_offset", uvOffset);
        this.uuid = JsonUtil.accept(json, "uuid").map(JsonElement::getAsString).map(UUID::fromString);
        JsonObject faces = class_3518.method_15281((JsonObject)json, (String)"faces", (JsonObject)new JsonObject());
        this.faces = Face.VALUES.stream().filter(face -> face != Face.NONE).collect(Collectors.toMap(Function.identity(), face -> new CubeFace((Face)((Object)face), class_3518.method_15296((JsonObject)faces, (String)face.name().toLowerCase(Locale.ROOT))), (a, b) -> b, () -> new EnumMap(Face.class)));
        this.texture = new Texture((int)uvOffset[0], (int)uvOffset[1], 0, 0);
    }

    @Override
    public class_630.class_628 export(ModelContext context) {
        return this.createBuilder(context).build();
    }

    @Override
    public void write(ModelContext context, ModelFileWriter writer) {
        writer.writeBox(this.createBuilder(context));
    }

    private BoxBuilder createBuilder(ModelContext context) {
        if (this.boxUv) {
            return new BoxBuilder(context).tex(this.texture).pos(this.origin).size(this.to[0] - this.from[0], this.to[1] - this.from[1], this.to[2] - this.from[2]).dilate(0.0f, 0.0f, 0.0f);
        }
        return new BoxBuilder(context).pos(this.origin).size(this.to[0] - this.from[0], this.to[1] - this.from[1], this.to[2] - this.from[2]).dilate(0.0f, 0.0f, 0.0f).quads(this);
    }

    @Override
    public void build(BoxParameters pars, BoxBuilder ctx, QuadsBuilder.QuadBuffer buffer) {
        float xMax = pars.position[0] + pars.size[0] + pars.dilation[0];
        float yMax = pars.position[1] + pars.size[1] + pars.dilation[1];
        float zMax = ctx.parameters.position[2] + pars.size[2] + pars.dilation[2];
        float xMin = pars.position[0] - pars.dilation[0];
        float yMin = pars.position[1] - pars.dilation[1];
        float zMin = pars.position[2] - pars.dilation[2];
        if (ctx.parameters.mirror[0]) {
            float v = xMax;
            xMax = xMin;
            xMin = v;
        }
        Vert wds = ctx.vert(xMin, yMin, zMax, 0, 0);
        Vert eds = ctx.vert(xMax, yMin, zMin, 0, 8);
        Vert eus = ctx.vert(xMax, yMax, zMin, 8, 8);
        Vert wus = ctx.vert(xMin, yMax, zMin, 8, 0);
        Vert wdn = ctx.vert(xMin, yMin, zMax, 0, 0);
        Vert edn = ctx.vert(xMax, yMin, zMax, 0, 8);
        Vert eun = ctx.vert(xMax, yMax, zMax, 8, 8);
        Vert wun = ctx.vert(xMin, yMax, zMax, 8, 0);
        this.faces.get((Object)Face.EAST).createRect(ctx, buffer, edn, eds, eus, eun);
        this.faces.get((Object)Face.WEST).createRect(ctx, buffer, wds, wdn, wun, wus);
        this.faces.get((Object)Face.UP).createRect(ctx, buffer, edn, wdn, wds, eds);
        this.faces.get((Object)Face.DOWN).createRect(ctx, buffer, eus, wus, wun, eun);
        this.faces.get((Object)Face.NORTH).createRect(ctx, buffer, eds, wds, wus, eus);
        this.faces.get((Object)Face.SOUTH).createRect(ctx, buffer, wdn, edn, eun, wun);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    record CubeFace(Face face, float[] uv, int texture, float rotation) {
        CubeFace(Face face, JsonObject json) {
            this(face, new float[4], json.get("texture").getAsInt(), json.get("rotation").getAsFloat() * ((float)Math.PI / 180));
            JsonUtil.acceptFloats(json, "uv", this.uv());
        }

        public void createRect(BoxBuilder builder, QuadsBuilder.QuadBuffer buffer, Vert a, Vert b, Vert c, Vert d) {
            Face.Axis axis = this.face.getAxis();
            buffer.quad(this.uv[0], this.uv[1], this.uv[2], this.uv[3], this.face.getNormal(), builder.parameters.mirror[0], true, new Quaternionf().rotateXYZ(axis == Face.Axis.X ? this.rotation : 0.0f, axis == Face.Axis.Y ? this.rotation : 0.0f, axis == Face.Axis.Z ? this.rotation : 0.0f), a, b, c, d);
        }
    }
}

