/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.bbmodel.elements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.exception.FutureAwaitException;
import com.minelittlepony.mson.api.export.ModelFileWriter;
import com.minelittlepony.mson.api.model.PartBuilder;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelComponent;
import com.minelittlepony.mson.impl.model.bbmodel.elements.BbCube;
import com.minelittlepony.mson.util.JsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_630;

public class BbPart
implements ModelComponent<class_630> {
    public static final class_2960 ID = class_2960.method_60655((String)"blockbench", (String)"part");
    private final float[] origin = new float[3];
    private final float[] rotation = new float[3];
    private final boolean visibility;
    private final Map<String, ModelComponent<?>> children = new TreeMap();
    public final String name;
    private final List<ModelComponent<?>> cubes = new ArrayList();

    public BbPart(FileContent<JsonElement> context, String name, JsonElement json) {
        this(context, name, json.getAsJsonObject());
    }

    public BbPart(FileContent<JsonElement> context, String name, JsonObject json) {
        this.name = class_3518.method_15253((JsonObject)json, (String)"name", (String)name);
        JsonUtil.acceptFloats(json, "origin", this.origin);
        JsonUtil.acceptFloats(json, "rotation", this.rotation);
        this.visibility = class_3518.method_15258((JsonObject)json, (String)"visibility", (boolean)true);
        JsonUtil.accept(json, "children").map(JsonElement::getAsJsonArray).stream().flatMap(a -> a.asList().stream()).forEach(child -> {
            if (child.isJsonObject()) {
                context.loadComponent((JsonElement)child, ID).ifPresent(component -> {
                    ModelComponent patt0$temp = component;
                    if (patt0$temp instanceof BbPart) {
                        BbPart part = (BbPart)patt0$temp;
                        this.children.put(part.name, part);
                    } else {
                        this.cubes.add((ModelComponent<?>)component);
                    }
                });
            } else {
                context.loadComponent((JsonElement)child, BbCube.ID).ifPresent(this.cubes::add);
            }
        });
    }

    public BbPart(Collection<ModelComponent<?>> cubes, String name) {
        this.name = name;
        this.visibility = true;
        this.cubes.addAll(cubes);
    }

    @Override
    public class_630 export(ModelContext context) {
        return context.computeIfAbsent(this.name, key -> {
            PartBuilder builder = this.createBuilder(context);
            return this.export(context.bind(builder), builder).build();
        });
    }

    protected PartBuilder createBuilder(ModelContext context) {
        PartBuilder builder = new PartBuilder().hidden(!this.visibility).pivot(this.origin).rotate(this.rotation[0] * ((float)Math.PI / 180), this.rotation[1] * ((float)Math.PI / 180), this.rotation[2] * ((float)Math.PI / 180)).tex(context.getLocals().getTexture());
        return builder;
    }

    protected PartBuilder export(ModelContext context, PartBuilder builder) throws FutureAwaitException, InterruptedException, ExecutionException {
        this.children.entrySet().forEach(c -> ((ModelComponent)c.getValue()).tryExport(context, class_630.class).ifPresent(part -> builder.addChild((String)c.getKey(), (class_630)part)));
        this.cubes.forEach(c -> c.tryExport(context, class_630.class_628.class).ifPresent(builder::addCube));
        return builder;
    }

    @Override
    public void write(ModelContext context, ModelFileWriter writer) {
        writer.writePart(this.name, this.createBuilder(context), (w, builder) -> {
            ModelContext boundContext = context.bind(builder);
            this.cubes.forEach(cube -> w.write(boundContext, (ModelFileWriter.Writeable)cube));
            this.children.forEach((name, child) -> w.write((String)name, boundContext, (ModelFileWriter.Writeable)child));
        });
    }
}

