/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.json;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minelittlepony.mson.api.Incomplete;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.ModelView;
import com.minelittlepony.mson.api.json.JsonContext;
import com.minelittlepony.mson.api.model.Texture;
import com.minelittlepony.mson.api.model.traversal.Traversable;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.ModelComponent;
import com.minelittlepony.mson.api.parser.ModelFormat;
import com.minelittlepony.mson.api.parser.ModelLoader;
import com.minelittlepony.mson.api.parser.locals.LocalBlock;
import com.minelittlepony.mson.impl.ModelContextImpl;
import com.minelittlepony.mson.impl.model.EmptyFileContent;
import com.minelittlepony.mson.impl.model.FileContentLocalsImpl;
import com.minelittlepony.mson.impl.model.RootContext;
import com.minelittlepony.mson.impl.model.json.JsonSkeleton;
import com.minelittlepony.mson.impl.model.json.elements.JsonCompound;
import com.minelittlepony.mson.impl.model.json.elements.JsonTexture;
import com.minelittlepony.mson.util.JsonUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3879;

public class JsonFileContent
implements JsonContext {
    private final ModelLoader loader;
    private final ModelFormat<JsonElement> format;
    private final Map<String, ModelComponent<?>> elements = new HashMap();
    private final CompletableFuture<FileContent<?>> parent;
    private final FileContent.Locals variables;
    private final Optional<Traversable<String>> skeleton;

    public JsonFileContent(ModelLoader loader, ModelFormat<JsonElement> format, class_2960 id, JsonObject json) {
        this.loader = loader;
        this.format = format;
        this.parent = JsonUtil.accept(json, "parent").map(JsonElement::getAsString).map(class_2960::method_60654).map(parentId -> loader.loadModel((class_2960)parentId, format)).orElseGet(() -> CompletableFuture.completedFuture(EmptyFileContent.INSTANCE));
        this.variables = new RootVariables(id, json, (CompletableFuture<FileContent.Locals>)this.parent.thenApplyAsync(FileContent::getLocals));
        this.elements.putAll(this.getChildren(json).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.loadComponent((String)entry.getKey(), (JsonElement)entry.getValue(), JsonCompound.ID).orElseGet(null))));
        this.skeleton = JsonUtil.accept(json, "skeleton").map(JsonElement::getAsJsonObject).map(JsonSkeleton::new);
    }

    private Stream<Map.Entry<String, JsonElement>> getChildren(JsonObject json) {
        if (json.has("data")) {
            return json.get("data").getAsJsonObject().entrySet().stream().filter(entry -> ((JsonElement)entry.getValue()).isJsonObject() || ((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isString());
        }
        return Stream.empty();
    }

    @Override
    public ModelFormat<JsonElement> getFormat() {
        return this.format;
    }

    @Override
    public CompletableFuture<Set<String>> getComponentNames() {
        return ((CompletableFuture)this.parent.thenComposeAsync(p -> p.getComponentNames())).thenApply(output -> {
            output.addAll(this.elements.keySet());
            return output;
        });
    }

    @Override
    public CompletableFuture<ModelComponent<?>> getComponent(String name) {
        ModelComponent component = this.elements.getOrDefault(name, null);
        if (component != null) {
            return CompletableFuture.completedFuture(component);
        }
        return this.parent.thenComposeAsync(p -> p.getComponent(name));
    }

    @Override
    public <T> void addNamedComponent(String name, ModelComponent<T> component) {
        if (!Strings.isNullOrEmpty((String)name)) {
            this.elements.put(name, component);
        }
    }

    @Override
    public <T> Optional<ModelComponent<T>> loadComponent(String name, JsonElement json, class_2960 defaultAs) {
        return this.format.loadComponent(name, json, defaultAs, this);
    }

    @Override
    public Optional<Traversable<String>> getSkeleton() {
        return this.skeleton.or(() -> this.parent.getNow(EmptyFileContent.INSTANCE).getSkeleton());
    }

    @Override
    public CompletableFuture<FileContent<?>> resolve(JsonElement json) {
        if (json.isJsonPrimitive()) {
            return this.loader.loadModel(class_2960.method_60654((String)json.getAsString()), this.format);
        }
        class_2960 id = this.getLocals().getModelId();
        class_2960 autoGen = id.method_48331("_dynamic");
        if (json.getAsJsonObject().has("data")) {
            throw new JsonParseException("Dynamic model files should not have a nested data block");
        }
        JsonObject file = new JsonObject();
        file.add("data", (JsonElement)json.getAsJsonObject());
        return CompletableFuture.completedFuture(new JsonFileContent(this.loader, this.format, autoGen, file));
    }

    @Override
    public ModelContext createContext(class_3879<?> model, Object thisObj, ModelView.Locals locals) {
        return new RootContext(model, thisObj, (ModelContextImpl)this.parent.getNow(EmptyFileContent.INSTANCE).createContext(model, thisObj, locals), this.elements, locals);
    }

    @Override
    public FileContent.Locals getLocals() {
        return this.variables;
    }

    public static class RootVariables
    implements FileContentLocalsImpl {
        private final class_2960 id;
        private final CompletableFuture<FileContent.Locals> parent;
        private final CompletableFuture<Texture> texture;
        private final CompletableFuture<float[]> dilate;
        private final LocalBlock locals;

        RootVariables(class_2960 id, JsonObject json, CompletableFuture<FileContent.Locals> parent) {
            this.id = id;
            this.parent = parent;
            this.texture = JsonTexture.unlocalized(JsonUtil.accept(json, "texture"), (CompletableFuture<Texture>)parent.thenComposeAsync(FileContent.Locals::getTexture));
            this.locals = LocalBlock.of(JsonUtil.accept(json, "locals"));
            this.dilate = JsonUtil.acceptFloats(json, "dilate", new float[3]).map(CompletableFuture::completedFuture).orElseGet(() -> parent.thenComposeAsync(FileContent.Locals::getDilation));
        }

        @Override
        public class_2960 getModelId() {
            return this.id;
        }

        @Override
        public CompletableFuture<float[]> getDilation() {
            return this.dilate;
        }

        @Override
        public CompletableFuture<Texture> getTexture() {
            return this.texture;
        }

        @Override
        public CompletableFuture<Incomplete<Float>> getLocal(String name, float defaultValue) {
            return this.locals.get(name).orElseGet(() -> this.parent.thenComposeAsync(p -> p.getLocal(name, defaultValue)));
        }

        @Override
        public CompletableFuture<Set<String>> keys() {
            return ((CompletableFuture)this.parent.thenComposeAsync(FileContent.Locals::keys)).thenApply(this.locals::appendKeys);
        }
    }
}

