/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.impl.model.json.elements;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minelittlepony.mson.api.Incomplete;
import com.minelittlepony.mson.api.ModelContext;
import com.minelittlepony.mson.api.exception.FutureAwaitException;
import com.minelittlepony.mson.api.export.ModelFileWriter;
import com.minelittlepony.mson.api.model.BoxBuilder;
import com.minelittlepony.mson.api.model.Face;
import com.minelittlepony.mson.api.model.PartBuilder;
import com.minelittlepony.mson.api.model.QuadsBuilder;
import com.minelittlepony.mson.api.model.Texture;
import com.minelittlepony.mson.api.parser.FileContent;
import com.minelittlepony.mson.api.parser.locals.Local;
import com.minelittlepony.mson.impl.MsonImpl;
import com.minelittlepony.mson.impl.model.FixtureImpl;
import com.minelittlepony.mson.impl.model.json.elements.JsonCompound;
import com.minelittlepony.mson.impl.model.json.elements.JsonTexture;
import com.minelittlepony.mson.util.JsonUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_630;

public class JsonPlanar
extends JsonCompound {
    public static final class_2960 ID = MsonImpl.id("planar");
    private final Map<Face, JsonFaceSet> faces = new EnumMap<Face, JsonFaceSet>(Face.class);

    public JsonPlanar(FileContent<JsonElement> context, String name, JsonElement json) {
        this(context, name, json.getAsJsonObject());
    }

    public JsonPlanar(FileContent<JsonElement> context, String name, JsonObject json) {
        super(context, name, json);
        Face.VALUES.forEach(face -> JsonUtil.accept(json, face.name().toLowerCase()).map(JsonElement::getAsJsonArray).ifPresent(el -> this.faces.put((Face)((Object)face), new JsonFaceSet(this, context, (JsonArray)el, (Face)((Object)face)))));
    }

    @Override
    protected void export(ModelContext context, PartBuilder builder) throws FutureAwaitException {
        super.export(context, builder);
        this.faces.values().stream().flatMap(face -> face.export(context)).forEach(builder::addCube);
    }

    @Override
    protected void write(ModelContext context, PartBuilder builder, ModelFileWriter writer) {
        super.write(context, builder, writer);
        this.faces.values().forEach(face -> writer.write(context, (ModelFileWriter.Writeable)face));
    }

    class JsonFaceSet
    implements ModelFileWriter.Writeable {
        private final Face face;
        private final List<JsonFace> elements = new ArrayList<JsonFace>();

        public JsonFaceSet(JsonPlanar this$0, FileContent<JsonElement> context, JsonArray json, Face face) {
            this.face = face;
            if (json.get(0).isJsonArray()) {
                for (int i = 0; i < json.size(); ++i) {
                    this.elements.add(new JsonFace(context, json.get(i).getAsJsonArray()));
                }
            } else {
                this.elements.add(new JsonFace(context, json));
            }
        }

        Stream<class_630.class_628> export(ModelContext subContext) {
            Fixtures fixtures = new Fixtures(subContext);
            return this.elements.stream().map(face -> face.export(subContext, fixtures));
        }

        @Override
        public void write(ModelContext context, ModelFileWriter writer) {
            Fixtures fixtures = new Fixtures(context);
            for (JsonFace face : this.elements) {
                face.write(context, fixtures, writer);
            }
        }

        class JsonFace {
            final Incomplete<float[]> position;
            final Incomplete<float[]> size;
            private final Incomplete<Texture> texture;
            private final boolean[] mirror;

            public JsonFace(FileContent<JsonElement> context, JsonArray json) {
                this.position = Local.array(json.get(0).getAsJsonPrimitive(), json.get(1).getAsJsonPrimitive(), json.get(2).getAsJsonPrimitive());
                this.size = Local.array(json.get(3).getAsJsonPrimitive(), json.get(4).getAsJsonPrimitive());
                this.texture = json.size() > 6 ? JsonFace.createTexture(Local.ref(json.get(5).getAsJsonPrimitive()), Local.ref(json.get(6).getAsJsonPrimitive())) : JsonTexture::fromParent;
                this.mirror = json.size() > 8 ? new boolean[]{json.get(7).getAsBoolean(), json.get(8).getAsBoolean()} : new boolean[2];
            }

            public class_630.class_628 export(ModelContext context, Fixtures fixtures) {
                return new BoxBuilder(context).fix(fixtures).tex(this.texture.complete(context)).mirror(JsonFaceSet.this.face.getAxis(), this.mirror).pos(this.position.complete(context)).size(JsonFaceSet.this.face.getAxis(), this.size.complete(context)).quads(QuadsBuilder.plane(JsonFaceSet.this.face)).build();
            }

            public void write(ModelContext context, Fixtures fixtures, ModelFileWriter writer) {
                writer.writeBox(new BoxBuilder(context).fix(fixtures).tex(this.texture.complete(context)).mirror(JsonFaceSet.this.face.getAxis(), this.mirror).pos(this.position.complete(context)).size(JsonFaceSet.this.face.getAxis(), this.size.complete(context)).quads(QuadsBuilder.plane(JsonFaceSet.this.face)));
            }

            private static Incomplete<Texture> createTexture(Incomplete<Float> u, Incomplete<Float> v) {
                return locals -> {
                    Texture parent = locals.getTexture();
                    return new Texture(((Float)u.complete(locals)).intValue(), ((Float)v.complete(locals)).intValue(), parent.width(), parent.height());
                };
            }
        }

        class Fixtures
        extends FixtureImpl {
            private final Map<Face.Axis, List<class_243>> lockedVectors = new HashMap<Face.Axis, List<class_243>>();

            Fixtures(ModelContext context) throws FutureAwaitException {
                for (Face.Axis axis : Face.Axis.values()) {
                    if (axis == JsonFaceSet.this.face.getAxis()) continue;
                    for (JsonFace i : JsonFaceSet.this.elements) {
                        JsonFaceSet.this.face.getVertices(i.position.complete(context), i.size.complete(context), axis, 0.5f).forEach(vertex -> {
                            List<class_243> locked = this.getLockedVectors(axis);
                            if (locked.contains(vertex.normal())) {
                                return;
                            }
                            for (JsonFace f : JsonFaceSet.this.elements) {
                                if (f == i || !JsonFaceSet.this.face.isInside(f.position.complete(context), f.size.complete(context), vertex.stretched())) continue;
                                locked.add(vertex.normal());
                                break;
                            }
                        });
                    }
                }
            }

            List<class_243> getLockedVectors(Face.Axis axis) {
                return this.lockedVectors.computeIfAbsent(axis, a -> new ArrayList());
            }

            @Override
            protected boolean isFixed(Face.Axis axis, float x, float y, float z) {
                return this.getLockedVectors(axis).contains(new class_243((double)x, (double)y, (double)z));
            }
        }
    }
}

