/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.util;

import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

public interface RenderList {
    public void accept(class_4587 var1, class_4588 var2, int var3, int var4, int var5);

    default public RenderList add(RenderList part) {
        return this;
    }

    default public RenderList add(Consumer<class_4587> action) {
        return this.add((class_4587 stack, class_4588 vertices, int overlay, int light, int color) -> action.accept(stack));
    }

    default public RenderList add(class_630 ... parts) {
        return this.add(RenderList.of(parts));
    }

    default public RenderList checked(BooleanSupplier check) {
        RenderList self = this;
        return (stack, vertices, overlay, light, color) -> {
            if (check.getAsBoolean()) {
                self.accept(stack, vertices, overlay, light, color);
            }
        };
    }

    default public void clear() {
    }

    public static RenderList of() {
        return new Impl(List.of());
    }

    public static RenderList of(class_630 ... parts) {
        return new Impl(Arrays.stream(parts).map(part -> (arg_0, arg_1, arg_2, arg_3, arg_4) -> ((class_630)part).method_22699(arg_0, arg_1, arg_2, arg_3, arg_4)).toList());
    }

    public static class Impl
    implements RenderList {
        private RenderList[] parts;

        Impl(List<RenderList> parts) {
            this.parts = (RenderList[])parts.toArray(RenderList[]::new);
        }

        @Override
        public RenderList add(RenderList part) {
            RenderList[] newArray = new RenderList[this.parts.length + 1];
            System.arraycopy(this.parts, 0, newArray, 0, this.parts.length);
            this.parts = newArray;
            this.parts[this.parts.length - 1] = part;
            return this;
        }

        @Override
        public void clear() {
            this.parts = new RenderList[0];
        }

        @Override
        public void accept(class_4587 stack, class_4588 vertices, int overlay, int light, int color) {
            for (RenderList part : this.parts) {
                part.accept(stack, vertices, overlay, light, color);
            }
        }
    }
}

