/*
 * Decompiled with CFR 0.152.
 */
package com.example.playerlocator;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerLocator
extends JavaPlugin {
    private FileConfiguration config;
    private String pluginPrefix;
    private String playerNotFoundMessage;
    private String noPermissionMessage;
    private String locationFormat;
    private String selfLocationFormat;
    private boolean enableSelfLocation;
    private boolean showWorldName;
    private boolean notifyPlayerWhenLocated;
    private String notificationMessage;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfiguration();
        this.getCommand("locate").setExecutor(new LocateCommand());
        this.getLogger().info(this.pluginPrefix + " has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info(this.pluginPrefix + " has been disabled!");
    }

    private void loadConfiguration() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.pluginPrefix = ChatColor.translateAlternateColorCodes('&', this.config.getString("plugin-prefix", "&7[&bPlayerLocator&7]"));
        this.playerNotFoundMessage = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.player-not-found", "&cPlayer not found!"));
        this.noPermissionMessage = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.no-permission", "&cYou don't have permission to use this command!"));
        this.locationFormat = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.location-format", "&a%player% &7is at &f%x%, %y%, %z%"));
        this.selfLocationFormat = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.self-location-format", "&7You are at &f%x%, %y%, %z%"));
        this.enableSelfLocation = this.config.getBoolean("features.enable-self-location", true);
        this.showWorldName = this.config.getBoolean("features.show-world-name", true);
        this.notifyPlayerWhenLocated = this.config.getBoolean("features.notify-player-when-located", false);
        this.notificationMessage = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.notification-message", "&7Your location has been checked by an admin."));
    }

    private class LocateCommand
    implements CommandExecutor {
        private LocateCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (args.length < 1 && !(sender instanceof Player)) {
                sender.sendMessage(PlayerLocator.this.pluginPrefix + String.valueOf((Object)ChatColor.RED) + " Usage: /locate <player>");
                return true;
            }
            if (!sender.hasPermission("playerlocator.locate")) {
                sender.sendMessage(PlayerLocator.this.pluginPrefix + " " + PlayerLocator.this.noPermissionMessage);
                return true;
            }
            if (args.length == 0 && sender instanceof Player) {
                if (!PlayerLocator.this.enableSelfLocation) {
                    sender.sendMessage(PlayerLocator.this.pluginPrefix + String.valueOf((Object)ChatColor.RED) + " Self-location is disabled.");
                    return true;
                }
                Player player = (Player)sender;
                Location location = player.getLocation();
                Object message = PlayerLocator.this.selfLocationFormat.replace("%x%", String.format("%.2f", location.getX())).replace("%y%", String.format("%.2f", location.getY())).replace("%z%", String.format("%.2f", location.getZ()));
                if (PlayerLocator.this.showWorldName) {
                    message = (String)message + String.valueOf((Object)ChatColor.GRAY) + " in " + String.valueOf((Object)ChatColor.WHITE) + location.getWorld().getName();
                }
                sender.sendMessage(PlayerLocator.this.pluginPrefix + " " + (String)message);
                return true;
            }
            String targetName = args[0];
            Player target = Bukkit.getPlayer(targetName);
            if (target == null) {
                sender.sendMessage(PlayerLocator.this.pluginPrefix + " " + PlayerLocator.this.playerNotFoundMessage);
                return true;
            }
            Location location = target.getLocation();
            Object message = PlayerLocator.this.locationFormat.replace("%player%", target.getName()).replace("%x%", String.format("%.2f", location.getX())).replace("%y%", String.format("%.2f", location.getY())).replace("%z%", String.format("%.2f", location.getZ()));
            if (PlayerLocator.this.showWorldName) {
                message = (String)message + String.valueOf((Object)ChatColor.GRAY) + " in " + String.valueOf((Object)ChatColor.WHITE) + location.getWorld().getName();
            }
            sender.sendMessage(PlayerLocator.this.pluginPrefix + " " + (String)message);
            if (PlayerLocator.this.notifyPlayerWhenLocated && sender != target) {
                target.sendMessage(PlayerLocator.this.pluginPrefix + " " + PlayerLocator.this.notificationMessage);
            }
            return true;
        }
    }
}

