/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.wardendepths.client.renderer;

import net.mcreator.wardendepths.client.model.ModelYeti;
import net.mcreator.wardendepths.client.model.animations.YetiAnimation;
import net.mcreator.wardendepths.entity.YetiEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class YetiRenderer
extends MobRenderer<YetiEntity, ModelYeti<YetiEntity>> {
    public YetiRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelYeti.LAYER_LOCATION)), 1.2f);
    }

    public ResourceLocation getTextureLocation(YetiEntity entity) {
        return ResourceLocation.parse((String)"wardendepths:textures/entities/yeti.png");
    }

    private static final class AnimatedModel
    extends ModelYeti<YetiEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<YetiEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(YetiEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, YetiAnimation.snow, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(YetiEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

