/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.wardendepths.entity;

import net.mcreator.wardendepths.entity.TaupeShoteEntity;
import net.mcreator.wardendepths.init.WardendepthsModEntities;
import net.mcreator.wardendepths.procedures.TaupeDesNeigesEntityIsHurtProcedure;
import net.mcreator.wardendepths.procedures.TaupeDesNeigesPlaybackCondition2Procedure;
import net.mcreator.wardendepths.procedures.TaupeDesNeigesPlaybackConditionProcedure;
import net.mcreator.wardendepths.procedures.TaupePeutElleAttaquerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class TaupeDesNeigesEntity
extends Monster
implements RangedAttackMob {
    public static final EntityDataAccessor<Boolean> DATA_digDown = SynchedEntityData.defineId(TaupeDesNeigesEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_digUp = SynchedEntityData.defineId(TaupeDesNeigesEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Boolean> DATA_isUnderSnow = SynchedEntityData.defineId(TaupeDesNeigesEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> DATA_testY = SynchedEntityData.defineId(TaupeDesNeigesEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_randomX = SynchedEntityData.defineId(TaupeDesNeigesEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_randomZ = SynchedEntityData.defineId(TaupeDesNeigesEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState1 = new AnimationState();

    public TaupeDesNeigesEntity(EntityType<TaupeDesNeigesEntity> type, Level world) {
        super(type, world);
        this.xpReward = 8;
        this.setNoAi(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_digDown, (Object)false);
        builder.define(DATA_digUp, (Object)false);
        builder.define(DATA_isUnderSnow, (Object)false);
        builder.define(DATA_testY, (Object)0);
        builder.define(DATA_randomX, (Object)0);
        builder.define(DATA_randomZ, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = TaupeDesNeigesEntity.this.getX();
                double y = TaupeDesNeigesEntity.this.getY();
                double z = TaupeDesNeigesEntity.this.getZ();
                TaupeDesNeigesEntity entity = TaupeDesNeigesEntity.this;
                Level world = TaupeDesNeigesEntity.this.level();
                return super.canUse() && TaupePeutElleAttaquerProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TaupeDesNeigesEntity.this.getX();
                double y = TaupeDesNeigesEntity.this.getY();
                double z = TaupeDesNeigesEntity.this.getZ();
                TaupeDesNeigesEntity entity = TaupeDesNeigesEntity.this;
                Level world = TaupeDesNeigesEntity.this.level();
                return super.canContinueToUse() && TaupePeutElleAttaquerProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = TaupeDesNeigesEntity.this.getX();
                double y = TaupeDesNeigesEntity.this.getY();
                double z = TaupeDesNeigesEntity.this.getZ();
                TaupeDesNeigesEntity entity = TaupeDesNeigesEntity.this;
                Level world = TaupeDesNeigesEntity.this.level();
                return super.canUse() && TaupePeutElleAttaquerProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TaupeDesNeigesEntity.this.getX();
                double y = TaupeDesNeigesEntity.this.getY();
                double z = TaupeDesNeigesEntity.this.getZ();
                TaupeDesNeigesEntity entity = TaupeDesNeigesEntity.this;
                Level world = TaupeDesNeigesEntity.this.level();
                return super.canContinueToUse() && TaupePeutElleAttaquerProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal(this, this, 1.25, 50, 10.0f){

            public boolean canContinueToUse() {
                return this.canUse();
            }
        });
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.fox.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.fox.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.fox.death"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TaupeDesNeigesEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        if (!TaupeDesNeigesEntityIsHurtProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity)) {
            return false;
        }
        return super.hurt(damagesource, amount);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("DatadigDown", ((Boolean)this.entityData.get(DATA_digDown)).booleanValue());
        compound.putBoolean("DatadigUp", ((Boolean)this.entityData.get(DATA_digUp)).booleanValue());
        compound.putBoolean("DataisUnderSnow", ((Boolean)this.entityData.get(DATA_isUnderSnow)).booleanValue());
        compound.putInt("DatatestY", ((Integer)this.entityData.get(DATA_testY)).intValue());
        compound.putInt("DatarandomX", ((Integer)this.entityData.get(DATA_randomX)).intValue());
        compound.putInt("DatarandomZ", ((Integer)this.entityData.get(DATA_randomZ)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DatadigDown")) {
            this.entityData.set(DATA_digDown, (Object)compound.getBoolean("DatadigDown"));
        }
        if (compound.contains("DatadigUp")) {
            this.entityData.set(DATA_digUp, (Object)compound.getBoolean("DatadigUp"));
        }
        if (compound.contains("DataisUnderSnow")) {
            this.entityData.set(DATA_isUnderSnow, (Object)compound.getBoolean("DataisUnderSnow"));
        }
        if (compound.contains("DatatestY")) {
            this.entityData.set(DATA_testY, (Object)compound.getInt("DatatestY"));
        }
        if (compound.contains("DatarandomX")) {
            this.entityData.set(DATA_randomX, (Object)compound.getInt("DatarandomX"));
        }
        if (compound.contains("DatarandomZ")) {
            this.entityData.set(DATA_randomZ, (Object)compound.getInt("DatarandomZ"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(TaupeDesNeigesPlaybackConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState1.animateWhen(TaupeDesNeigesPlaybackCondition2Procedure.execute((Entity)this), this.tickCount);
        }
    }

    public void performRangedAttack(LivingEntity target, float flval) {
        TaupeShoteEntity.shoot((LivingEntity)this, target);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)WardendepthsModEntities.TAUPE_DES_NEIGES.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.0);
        builder = builder.add(Attributes.MAX_HEALTH, 30.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 32.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 7.0);
        return builder;
    }
}

