/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.wardendepths.network;

import java.util.HashMap;
import net.mcreator.wardendepths.WardendepthsMod;
import net.mcreator.wardendepths.procedures.DepositDiamondsProcedure;
import net.mcreator.wardendepths.procedures.DepositEmeraldProcedure;
import net.mcreator.wardendepths.procedures.DepositStarsProcedure;
import net.mcreator.wardendepths.procedures.DepositWheatProcedure;
import net.mcreator.wardendepths.world.inventory.OffrandeChestGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record OffrandeChestGUISlotMessage(int slotID, int x, int y, int z, int changeType, int meta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OffrandeChestGUISlotMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"wardendepths", (String)"offrande_chest_gui_slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OffrandeChestGUISlotMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }, buffer -> new OffrandeChestGUISlotMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<OffrandeChestGUISlotMessage> type() {
        return TYPE;
    }

    public static void handleData(OffrandeChestGUISlotMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int slotID = message.slotID;
                int changeType = message.changeType;
                int meta = message.meta;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                OffrandeChestGUISlotMessage.handleSlotAction(entity, slotID, changeType, meta, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = OffrandeChestGUIMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 0 && changeType == 0) {
            DepositEmeraldProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 1 && changeType == 0) {
            DepositDiamondsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 2 && changeType == 0) {
            DepositWheatProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (slot == 3 && changeType == 0) {
            DepositStarsProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        WardendepthsMod.addNetworkMessage(TYPE, STREAM_CODEC, OffrandeChestGUISlotMessage::handleData);
    }
}

