package embin.strangeitems.client;

import embin.strangeitems.client.config.StrangeConfig;
import embin.strangeitems.client.debug.TrackerListScreen;
import embin.strangeitems.util.Id;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrangeItemsClient implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger("strangeitems/client");
    public static final class_304.class_11900 STRANGEKEYS = class_304.class_11900.method_74698(Id.of("strangeitems"));
    public static final class_304.class_11900 STRANGEKEYS_DEBUG = class_304.class_11900.method_74698(Id.of("strangeitems_debug"));

    private static class_304 keybind(String translation, int key) {
        return new class_304(
            "key.strangeitems." + translation,
            class_3675.class_307.field_1668,
            key,
                STRANGEKEYS
        );
    }

    private static class_304 vanillaKeybind(String translation, int key) {
        return KeyBindingHelper.registerKeyBinding(new class_304(
                "key.strangeitems." + translation,
                class_3675.class_307.field_1668,
                key,
                STRANGEKEYS
        ));
    }

    private static class_304 debugKeybind(String translation, int key) {
        return KeyBindingHelper.registerKeyBinding(new class_304(
                "key.strangeitems." + translation,
                class_3675.class_307.field_1668,
                key,
                STRANGEKEYS_DEBUG
        ));
    }

    public static class_304 show_blocks_mined = keybind("show_blocks_mined", GLFW.GLFW_KEY_Z);
    public static class_304 show_times_dropped = keybind("show_times_dropped", GLFW.GLFW_KEY_RIGHT_ALT);
    public static class_304 show_mobs_killed = keybind("show_mobs_killed", GLFW.GLFW_KEY_LEFT_ALT);
    public static class_304 show_time_in_dimensions = keybind("show_time_in_dimension", GLFW.GLFW_KEY_GRAVE_ACCENT);
    public static class_304 show_tracker_ids = keybind("show_tracker_ids", GLFW.GLFW_KEY_COMMA);

    public static class_304 DEBUG_LIST_TRACKERS = debugKeybind("debug_list_trackers", GLFW.GLFW_KEY_KP_DIVIDE);

    @Override
    public void onInitializeClient() {
        LOGGER.info("Reading config...");
        StrangeConfig.read_json();

        ClientTickEvents.END_CLIENT_TICK.register(Id.of("debug_list_trackers"), client -> {
            while (DEBUG_LIST_TRACKERS.method_1436()) {
                client.method_1507(new TrackerListScreen(client.field_1755));
            }
        });
    }
}
