package embin.strangeitems.mixin;

import embin.strangeitems.tracker.Trackers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin {

    @Inject(at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;damage(ILnet/minecraft/entity/LivingEntity;Lnet/minecraft/entity/EquipmentSlot;)V"),
        method = "tickGliding", locals = LocalCapture.CAPTURE_FAILHARD)
    public void elytraMixin(CallbackInfo ci, int i, int j, List<class_1304> list, class_1304 equipmentSlot) {
        class_1309 livingentity = (class_1309)(Object) this;
        Trackers.TIME_FLOWN_WITH_ELYTRA.appendTracker(livingentity.method_6118(equipmentSlot));
    }

    //@Inject(method = "onEquipStack", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/registry/entry/RegistryEntry;Lnet/minecraft/sound/SoundCategory;FFJ)V"), locals = LocalCapture.CAPTURE_FAILHARD)
    public void equipMixin(class_1304 slot, class_1799 oldStack, class_1799 newStack, CallbackInfo ci) {
        Trackers.TIMES_EQUIPPED.appendTracker(newStack, 1);
    }
}
