package embin.strangeitems.util;

import embin.strangeitems.StrangeItems;
import embin.strangeitems.StrangeRegistries;
import embin.strangeitems.StrangeRegistryKeys;
import embin.strangeitems.client.config.StrangeConfig;
import embin.strangeitems.mixin.KeyBindAccessor;
import embin.strangeitems.tracker.Tracker;
import embin.strangeitems.tracker.TrackerTags;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9701;

public class TrackerUtil {

    /**
     * Gets the keys from an NBT Compound, sorted from the highest to lowest value.
     * @param nbtCompound An NBT Compound where each value is an integer.
     * @return The sorted keys of the given NBT Compound.
     */
    public static List<String> getSortedKeys(class_2487 nbtCompound) {
        List<String> sorted = new java.util.ArrayList<>(List.of());
        List<String> unsorted = nbtCompound.method_10541().stream().toList();
        for (String key : unsorted) {
           sorted.add(key);
           int value = nbtCompound.method_68083(key, 0);
           if (sorted.size() > 1) {
               while (true) {
                   int index = sorted.indexOf(key);
                   String key_ahead;
                   try {
                       key_ahead = sorted.get(index - 1);
                   } catch (IndexOutOfBoundsException e) {
                       break;
                   }
                   int value_ahead = nbtCompound.method_10550(key_ahead).get();
                   if (value > value_ahead) {
                       sorted.remove(index);
                       sorted.add(index - 1, key);
                   } else {
                       break;
                   }
               }
           }
        }
        return sorted;
    }

    /**
     * Check if the specified keybinding is currently being pressed or not.
     * @param key The keybinding to check for.
     * @return <code>true</code> if the given key is currently held down;
     * <code>false</code> if it isn't.
     */
    public static boolean isKeyDown(class_304 key) {
        class_1041 handle = class_310.method_1551().method_22683();
        int key_code = ((KeyBindAccessor)key).getBoundKey().method_1444();
        return class_3675.method_15987(handle, key_code);
    }

    public static void addItemIdToTooltip(class_1799 stack, Consumer<class_2561> tooltip, class_1836 type) {
        if (type.method_8035()) {
            tooltip.accept(class_2561.method_43470(class_7923.field_41178.method_10221(stack.method_7909()).toString()).method_27692(class_124.field_1063));
            if (StrangeItems.componentless_installed) {
                tooltip.accept(class_2561.method_43470("stop it, componentless"));
            }
        }
    }

    public static boolean canSwap(class_1799 stack, class_1799 stack_wearing, class_1657 player) {
        return (
        !class_1890.method_60142(stack_wearing, class_9701.field_51656)
            || player.method_68878()
        ) && !class_1799.method_31577(stack, stack_wearing);
    }

    /**
     * A method to check if Tooltip Scroll is installed, respecting the users settings on how it should handle this check.
     */
    public static boolean isTooltipScrollInstalled() {
        boolean result = false;
        if (StrangeConfig.check_for_tooltipscroll) {
            result = StrangeItems.tooltipscroll_installed;
        }
        if (StrangeConfig.invert_tooltipscroll_check_value) {
            return !result;
        }
        return result;
    }

    public static List<Tracker> getListOfTrackers() {
        return StrangeRegistries.TRACKER.method_10220().toList();
    }

    @Deprecated
    public static List<class_2960> get_list_of_ids() {
        return StrangeRegistries.TRACKER.method_10235().stream().toList();
    }

    public static void addAllTrackerTooltips(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1799 stack) {
        textConsumer.accept(class_2561.method_43471("tooltip.strangeitems.strange_trackers").method_27693(":").method_27692(class_124.field_1080));
        class_6885<Tracker> entryList = getTooltipOrder(context.method_59527(), StrangeRegistryKeys.TRACKER, TrackerTags.TOOLTIP_ORDER);
        for (class_6880<Tracker> registryEntry : entryList) {
            registryEntry.comp_349().appendTooltip(stack, textConsumer);
        }

        for (Tracker tracker : getListOfTrackers()) {
            if (!entryList.method_40241(StrangeRegistries.TRACKER.method_47983(tracker))) {
                tracker.appendTooltip(stack, textConsumer);
            }
        }
    }

    public static class_6885<Tracker> getTooltipOrder(@Nullable class_7225.class_7874 registries, class_5321<class_2378<Tracker>> key, class_6862<Tracker> tag) {
        if (registries != null) {
            Optional<class_6885.class_6888<Tracker>> optional = registries.method_46762(key).method_46733(tag);
            if (optional.isPresent()) {
                return optional.get();
            }
        }
        return class_6885.method_40246();
    }
}
