/*
 * Decompiled with CFR 0.152.
 */
package embin.strangeitems.tracker;

import embin.strangeitems.client.StrangeItemsClient;
import embin.strangeitems.client.config.StrangeConfig;
import embin.strangeitems.tracker.Tracker;
import embin.strangeitems.tracker.TrackerItemTags;
import embin.strangeitems.tracker.TrackerKeybindings;
import embin.strangeitems.util.TrackerUtil;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3446;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class MapTracker
extends Tracker {
    public String map_id = this.getId().toString() + "_map";
    public String translation_prefix;
    public int max_maps_shown = 8;

    public MapTracker(String id, String translate_prefix, class_6862<class_1792> tag, class_3446 stat_formatter) {
        super(id, tag);
        this.translation_prefix = translate_prefix;
        this.stat_formatter = stat_formatter;
    }

    public MapTracker(String id, String translate_prefix, class_6862<class_1792> tag) {
        super(id, tag);
        this.translation_prefix = translate_prefix;
    }

    public MapTracker(String id, String translate_prefix) {
        super(id, TrackerItemTags.CAN_TRACK_STATS);
        this.translation_prefix = translate_prefix;
    }

    public void appendTracker(class_1799 stack, String key) {
        super.appendTracker(stack, 1);
        if ((this.shouldTrack(stack) || this.stackHasTracker(stack)) && StrangeConfig.in_depth_tracking) {
            int tracker_count = this.getTrackerValueNbt(stack).method_10550(key).orElse(0) + 1;
            class_2487 nbt = this.getTrackerValueNbt(stack).method_10553();
            nbt.method_10569(key, tracker_count);
            this.setTrackerValueNbt(stack, (class_2520)nbt);
        }
    }

    @Override
    public void setTrackerValueNbt(class_1799 stack, class_2520 value) {
        stack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(currentnbt -> currentnbt.method_10566(this.map_id, value)));
    }

    @Override
    public class_2487 getTrackerValueNbt(class_1799 stack) {
        if (!this.stackHasTracker(stack)) {
            return new class_2487();
        }
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10562(this.map_id).orElse(new class_2487());
    }

    public void appendTooltipMap(class_1799 stack, Consumer<class_2561> tooltip, CallbackInfo ci, class_1836 type) {
        if (this.shouldTrack(stack) && this.shouldShowTooltip(stack)) {
            this.appendTooltipNoSpace(stack, tooltip, type);
            class_2487 nbtCompound = this.getTrackerValueNbt(stack);
            int index = 1;
            for (String key : TrackerUtil.getSortedKeys(nbtCompound)) {
                if (index <= this.max_maps_shown || TrackerUtil.isTooltipScrollInstalled()) {
                    String translation_key = class_2960.method_60654((String)key).method_42093(this.translation_prefix);
                    class_5250 stat_text = class_2561.method_43470((String)this.getFormattedTrackerValueNbt(stack, key)).method_27692(class_124.field_1054);
                    class_5250 tooltip_text = class_2561.method_43470((String)key);
                    if (class_2477.method_10517().method_4678(translation_key) && !TrackerUtil.isKeyDown(StrangeItemsClient.show_tracker_ids)) {
                        tooltip_text = class_2561.method_43471((String)translation_key).method_27692(class_124.field_1080);
                    }
                    if (TrackerUtil.isKeyDown(StrangeItemsClient.show_tracker_ids)) {
                        tooltip_text.method_27692(class_124.field_1063);
                    }
                    tooltip_text.method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080));
                    tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)tooltip_text).method_10852((class_2561)stat_text));
                }
                ++index;
            }
            if (index > this.max_maps_shown + 1 && !TrackerUtil.isTooltipScrollInstalled()) {
                tooltip.accept((class_2561)class_2561.method_43469((String)"tooltip.strangeitems.map_cutoff", (Object[])new Object[]{index - (this.max_maps_shown + 1)}).method_27692(class_124.field_1056));
            }
            TrackerUtil.addItemIdToTooltip(stack, tooltip, type);
            ci.cancel();
        }
    }

    public String getFormattedTrackerValueNbt(class_1799 stack, String key) {
        return this.getStatFormatter().format(this.getTrackerValueNbt(stack).method_10550(key).orElse(0) * this.formatted_value_multiplier);
    }

    public boolean shouldShowTooltip(class_1799 stack) {
        return this.stackHasTracker(stack) && TrackerUtil.isKeyDown(this.getKeybinding()) && StrangeConfig.in_depth_tracking && this.stackHasMapTracker(stack);
    }

    @Override
    public void appendTooltip(class_1799 stack, Consumer<class_2561> tooltip) {
        if (this.shouldTrack(stack)) {
            if (this.stackHasTracker(stack) && StrangeConfig.in_depth_tracking && this.stackHasMapTracker(stack)) {
                class_5250 stat_text = class_2561.method_43470((String)this.getFormattedTrackerValue(stack)).method_27692(class_124.field_1054);
                class_5250 tooltip_text = this.getNameForTooltip().method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080));
                class_5250 control_text = class_2561.method_43470((String)" [").method_10852(this.getKeybinding().method_16007()).method_27693("]").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});
                tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)tooltip_text).method_10852((class_2561)stat_text).method_10852((class_2561)control_text));
            } else {
                super.appendTooltip(stack, tooltip);
            }
        }
    }

    public boolean stackHasMapTracker(class_1799 stack) {
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10545(this.map_id);
    }

    public class_304 getKeybinding() {
        return TrackerKeybindings.get_map_keybind(this);
    }
}

