/*
 * Decompiled with CFR 0.152.
 */
package embin.strangeitems.tracker;

import embin.strangeitems.client.config.StrangeConfig;
import embin.strangeitems.tracker.Tracker;
import embin.strangeitems.tracker.TrackerItemTags;
import embin.strangeitems.tracker.TrackerKeybindings;
import embin.strangeitems.util.TrackerUtil;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class TimestampTracker
extends Tracker {
    public String map_id = this.getId().toString() + "_map";
    public int max_entries_shown = 8;

    public TimestampTracker(String id) {
        super(id, TrackerItemTags.CAN_TRACK_STATS);
    }

    public TimestampTracker(String id, class_6862<class_1792> tag) {
        super(id, tag);
    }

    @Override
    public void appendTracker(class_1799 stack) {
        super.appendTracker(stack, 1);
        if ((this.shouldTrack(stack) || this.stackHasTracker(stack)) && StrangeConfig.in_depth_tracking) {
            int base_value = this.getTrackerValueInt(stack);
            class_2487 nbt = this.getTrackerValueNbt(stack).method_10553();
            nbt.method_10544(String.valueOf(base_value), Instant.now().getEpochSecond());
            this.setTrackerValueNbt(stack, (class_2520)nbt);
        }
    }

    @Override
    public void setTrackerValueNbt(class_1799 stack, class_2520 value) {
        stack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(currentnbt -> currentnbt.method_10566(this.map_id, value)));
    }

    public void append_tooltip_map(class_1799 stack, Consumer<class_2561> tooltip, CallbackInfo ci, class_1836 type) {
        if (this.shouldTrack(stack) && this.should_show_tooltip(stack)) {
            int size;
            this.appendTooltipNoSpace(stack, tooltip, type);
            for (int i = size = this.getTrackerValueInt(stack) - 1; i >= 0; --i) {
                String key = String.valueOf(i + 1);
                if (size - this.max_entries_shown > i && !TrackerUtil.isTooltipScrollInstalled()) continue;
                class_5250 stat_text = class_2561.method_43471((String)"tooltip.strangeitems.unknown_value").method_27692(class_124.field_1063);
                if (this.getTrackerValueNbt(stack).method_10545(key)) {
                    long tracker_value = this.getTrackerValueNbt(stack).method_10537(key).orElse(0L);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MMMM-dd HH:mm:ss");
                    Instant time = Instant.ofEpochSecond(tracker_value);
                    stat_text = class_2561.method_43470((String)format.format(Date.from(time))).method_27692(class_124.field_1080);
                }
                class_5250 tooltip_text = class_2561.method_43470((String)key).method_27693(": ").method_27692(class_124.field_1054);
                tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)tooltip_text).method_10852((class_2561)stat_text));
            }
            if (size >= this.max_entries_shown + 1 && !TrackerUtil.isTooltipScrollInstalled()) {
                tooltip.accept((class_2561)class_2561.method_43469((String)"tooltip.strangeitems.map_cutoff", (Object[])new Object[]{size - (this.max_entries_shown + 1)}).method_27692(class_124.field_1056));
            }
            TrackerUtil.addItemIdToTooltip(stack, tooltip, type);
            ci.cancel();
        }
    }

    public boolean should_show_tooltip(class_1799 stack) {
        return this.stackHasTracker(stack) && TrackerUtil.isKeyDown(this.get_key()) && StrangeConfig.in_depth_tracking && this.stack_has_map_tracker(stack);
    }

    @Override
    public class_2487 getTrackerValueNbt(class_1799 stack) {
        if (!this.stackHasTracker(stack)) {
            return new class_2487();
        }
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10562(this.map_id).orElse(new class_2487());
    }

    public boolean stack_has_map_tracker(class_1799 stack) {
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10545(this.map_id);
    }

    @Override
    public void appendTooltip(class_1799 stack, Consumer<class_2561> tooltip) {
        if (this.shouldTrack(stack)) {
            if (this.stackHasTracker(stack) && StrangeConfig.in_depth_tracking && this.stack_has_map_tracker(stack)) {
                class_5250 stat_text = class_2561.method_43470((String)this.getFormattedTrackerValue(stack)).method_27692(class_124.field_1054);
                class_5250 tooltip_text = this.getNameForTooltip().method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080));
                class_5250 control_text = class_2561.method_43470((String)" [").method_10852(this.get_key().method_16007()).method_27693("]").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056});
                tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)tooltip_text).method_10852((class_2561)stat_text).method_10852((class_2561)control_text));
            } else {
                super.appendTooltip(stack, tooltip);
            }
        }
    }

    public class_304 get_key() {
        return TrackerKeybindings.get_timestamp_keybind(this);
    }
}

