/*
 * Decompiled with CFR 0.152.
 */
package embin.strangeitems.tracker;

import embin.strangeitems.StrangeItemsComponents;
import embin.strangeitems.StrangeRegistries;
import embin.strangeitems.client.StrangeItemsClient;
import embin.strangeitems.util.Id;
import embin.strangeitems.util.TrackerUtil;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3446;
import net.minecraft.class_5250;
import net.minecraft.class_6862;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tracker.class);
    public String id;
    public class_3446 stat_formatter = class_3446.field_16975;
    public int formatted_value_multiplier = 1;
    public int default_value = 0;
    public class_6862<class_1792> item_tag;

    public Tracker(String id, class_6862<class_1792> tag, class_3446 stat_formatter, int formatted_value_multiplier) {
        this.stat_formatter = stat_formatter;
        this.formatted_value_multiplier = formatted_value_multiplier;
        this.item_tag = tag;
        this.id = Id.of(id).toString();
    }

    public Tracker(String id, class_6862<class_1792> tag) {
        this.item_tag = tag;
        this.id = Id.of(id).toString();
    }

    public void setTrackerValueInt(class_1799 stack, int value) {
        stack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(currentnbt -> currentnbt.method_10569(this.toString(), value)));
    }

    public void setTrackerValueNbt(class_1799 stack, class_2520 value) {
        stack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(currentnbt -> currentnbt.method_10566(this.toString(), value)));
    }

    public class_3446 getStatFormatter() {
        return this.stat_formatter;
    }

    public String toString() {
        return this.getId().toString();
    }

    @Deprecated(forRemoval=true)
    public String to_string() {
        return this.toString();
    }

    public class_2960 getId() {
        class_2960 id = StrangeRegistries.TRACKER.method_10221((Object)this);
        if (id != null) {
            return id;
        }
        return Id.of(this.id);
    }

    public String getTranslationKey() {
        return class_156.method_646((String)"tracker", (class_2960)this.getId());
    }

    public boolean stackHasTracker(class_1799 stack) {
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10545(this.toString());
    }

    public int getTrackerValueInt(class_1799 stack) {
        if (!this.stackHasTracker(stack)) {
            return this.default_value;
        }
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10550(this.toString()).orElse(0);
    }

    public class_2487 getTrackerValueNbt(class_1799 stack) {
        if (!this.stackHasTracker(stack)) {
            return new class_2487();
        }
        return ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_10562(this.toString()).orElse(new class_2487());
    }

    public void appendTracker(class_1799 stack, int add_amount) {
        if (this.shouldTrack(stack)) {
            int tracker_count = this.getTrackerValueInt(stack) + add_amount;
            this.setTrackerValueInt(stack, tracker_count);
        }
    }

    public void appendTracker(class_1799 stack) {
        this.appendTracker(stack, 1);
    }

    public String getFormattedTrackerValue(class_1799 stack) {
        return this.getStatFormatter().format(this.getTrackerValueInt(stack) * this.formatted_value_multiplier);
    }

    public void appendTooltip(class_1799 stack, Consumer<class_2561> tooltip) {
        if (this.shouldTrack(stack)) {
            class_5250 stat_text = class_2561.method_43470((String)this.getFormattedTrackerValue(stack)).method_27692(class_124.field_1054);
            class_5250 tooltip_text = this.getNameForTooltip().method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080));
            tooltip.accept((class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)tooltip_text).method_10852((class_2561)stat_text));
        }
    }

    protected class_5250 getNameForTooltip() {
        if (TrackerUtil.isKeyDown(StrangeItemsClient.show_tracker_ids)) {
            class_2960 id = StrangeRegistries.TRACKER.method_10221((Object)this);
            if (id != null) {
                return class_2561.method_43470((String)id.toString()).method_27692(class_124.field_1063);
            }
            return class_2561.method_43471((String)this.getTranslationKey()).method_27692(class_124.field_1080);
        }
        return class_2561.method_43471((String)this.getTranslationKey()).method_27692(class_124.field_1080);
    }

    public void appendTooltipNoSpace(class_1799 stack, Consumer<class_2561> tooltip, class_1836 type) {
        if (this.shouldTrack(stack)) {
            class_5250 stat_text = class_2561.method_43470((String)this.getFormattedTrackerValue(stack)).method_27692(class_124.field_1054);
            class_5250 tooltip_text = class_2561.method_43471((String)this.getTranslationKey()).method_27693(": ").method_27692(class_124.field_1080);
            tooltip.accept((class_2561)tooltip_text.method_10852((class_2561)stat_text));
        }
    }

    @Deprecated(forRemoval=true)
    public void convert_legacy_tracker(class_1799 stack, class_9331<Integer> legacy_component, boolean rarity_fix) {
        if (stack.method_57826(legacy_component)) {
            if (rarity_fix) {
                stack.method_57379(class_9334.field_50073, (Object)((class_1814)stack.method_7909().method_57347().method_58694(class_9334.field_50073)));
            }
            int legacy_data = (Integer)stack.method_58695(legacy_component, (Object)0);
            this.setTrackerValueInt(stack, this.getTrackerValueInt(stack) + legacy_data);
            stack.method_57381(legacy_component);
        }
    }

    @Deprecated(forRemoval=true)
    public void convert_legacy_tracker(class_1799 stack, class_9331<Integer> legacy_component) {
        this.convert_legacy_tracker(stack, legacy_component, false);
    }

    public boolean shouldTrack(class_1799 stack) {
        return stack.method_31573(this.item_tag) || this.stackHasTracker(stack) || stack.method_57826(StrangeItemsComponents.HAS_ALL_TRACKERS);
    }

    public boolean isIn(class_6862<Tracker> tag) {
        return StrangeRegistries.TRACKER.method_47983((Object)this).method_40220(tag);
    }
}

