/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.util.offheap;

import io.github.rothes.esu.util.offheap.MemSeg;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0096\u0002J\u0019\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\rH\u0096\u0002J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\rH\u0016J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lio/github/rothes/esu/util/offheap/ArenaMemSeg;", "Lio/github/rothes/esu/util/offheap/MemSeg;", "size", "", "<init>", "(J)V", "arena", "Ljava/lang/foreign/Arena;", "memorySegment", "Ljava/lang/foreign/MemorySegment;", "getSize", "()J", "get", "", "offset", "set", "", "value", "or", "fill", "length", "initialize", "close", "Companion", "off-heap-memory_java22"})
public final class ArenaMemSeg
implements MemSeg {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Arena arena = Arena.ofShared();
    @NotNull
    private final MemorySegment memorySegment;
    private final long size;
    private static final boolean NEED_INITIALIZE = Boolean.getBoolean("jdk.internal.foreign.skipZeroMemory");

    public ArenaMemSeg(long size) {
        this.memorySegment = this.arena.allocate(size);
        this.size = this.memorySegment.byteSize();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public byte get(long offset) {
        return this.memorySegment.get(ValueLayout.JAVA_BYTE, offset);
    }

    @Override
    public void set(long offset, byte value) {
        this.memorySegment.set(ValueLayout.JAVA_BYTE, offset, value);
    }

    @Override
    public void or(long offset, byte value) {
        this.set(offset, (byte)(this.get(offset) | value));
    }

    @Override
    public void fill(long offset, long length, byte value) {
        this.memorySegment.asSlice(offset, length).fill(value);
    }

    @Override
    public void initialize() {
        if (NEED_INITIALIZE) {
            this.memorySegment.fill((byte)0);
        }
    }

    @Override
    public void close() {
        this.arena.close();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/rothes/esu/util/offheap/ArenaMemSeg$Companion;", "", "<init>", "()V", "NEED_INITIALIZE", "", "off-heap-memory_java22"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

