/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.core;

import io.github.rothes.esu.bukkit.TopLevelsKt;
import io.github.rothes.esu.bukkit.module.CoreModule;
import io.github.rothes.esu.bukkit.module.core.PlayerTimeProvider;
import io.github.rothes.esu.bukkit.module.core.Providers;
import io.github.rothes.esu.bukkit.util.extension.ListenersKt;
import io.github.rothes.esu.core.util.extension.KotlinxIoKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.BuffersJvmKt;
import kotlinx.io.CoreKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"Lio/github/rothes/esu/bukkit/module/core/CoreController;", "", "<init>", "()V", "onEnable", "", "onDisable", "HotDataHandler", "RunningProviders", "Listeners", "MapPlayerTimeProvider", "bukkit"})
public final class CoreController {
    @NotNull
    public static final CoreController INSTANCE = new CoreController();

    private CoreController() {
    }

    public final void onEnable() {
        ListenersKt.register$default(Listeners.INSTANCE, null, 1, null);
        HotDataHandler.INSTANCE.loadData();
        long now = System.currentTimeMillis();
        for (Player p : Bukkit.getOnlinePlayers()) {
            RunningProviders.INSTANCE.getMoveTime().getMap().putIfAbsent(p, now);
            RunningProviders.INSTANCE.getPosMoveTime().getMap().putIfAbsent(p, now);
            RunningProviders.INSTANCE.getAttackTime().getMap().putIfAbsent(p, now);
        }
    }

    public final void onDisable() {
        ListenersKt.unregister(Listeners.INSTANCE);
        HotDataHandler.INSTANCE.saveData();
        RunningProviders.INSTANCE.getMoveTime().getMap().clear();
        RunningProviders.INSTANCE.getPosMoveTime().getMap().clear();
        RunningProviders.INSTANCE.getAttackTime().getMap().clear();
        RunningProviders.INSTANCE.getGenericActiveTime().getMap().clear();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010%\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ \u0010\u000e\u001a\u00020\f*\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J=\u0010\u0014\u001a\u00020\f*\u00020\u00152*\u0010\u0016\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00180\u0017\"\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lio/github/rothes/esu/bukkit/module/core/CoreController$HotDataHandler;", "", "<init>", "()V", "DATA_VERSION", "", "hotData", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getHotData", "()Ljava/nio/file/Path;", "loadData", "", "saveData", "writeTimeMap", "Lkotlinx/io/Sink;", "map", "", "Lorg/bukkit/entity/Player;", "", "readTimeMap", "Lkotlinx/io/Source;", "maps", "", "", "(Lkotlinx/io/Source;[Ljava/util/Map;)V", "bukkit"})
    @SourceDebugExtension(value={"SMAP\nCoreController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreController.kt\nio/github/rothes/esu/bukkit/module/core/CoreController$HotDataHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
    private static final class HotDataHandler {
        @NotNull
        public static final HotDataHandler INSTANCE = new HotDataHandler();
        private static final byte DATA_VERSION = 1;

        private HotDataHandler() {
        }

        private final Path getHotData() {
            return CoreModule.INSTANCE.getModuleFolder().resolve("hotData.tmp");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void loadData() {
            try {
                block13: {
                    block12: {
                        if (!TopLevelsKt.getCore().getEnabledHot()) break block12;
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.exists(this.getHotData(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block13;
                    }
                    return;
                }
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream(this.getHotData(), Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                AutoCloseable autoCloseable = (AutoCloseable)CoreKt.buffered((RawSource)JvmCoreKt.asSource((InputStream)inputStream));
                Throwable throwable = null;
                try {
                    Source buf = (Source)autoCloseable;
                    boolean bl = false;
                    if (!(buf.readByte() == 1)) {
                        boolean bl2 = false;
                        String string = "Different hot data version";
                        throw new IllegalArgumentException(string.toString());
                    }
                    Map[] mapArray = new Map[]{RunningProviders.INSTANCE.getAttackTime().getMap()};
                    INSTANCE.readTimeMap(buf, mapArray);
                    mapArray = new Map[]{RunningProviders.INSTANCE.getMoveTime().getMap(), RunningProviders.INSTANCE.getPosMoveTime().getMap()};
                    INSTANCE.readTimeMap(buf, mapArray);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (Throwable e) {
                TopLevelsKt.getCore().err("[CoreModule] Failed to load hotData", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void saveData() {
            try {
                if (!TopLevelsKt.getCore().isEnabled() && !TopLevelsKt.getCore().getDisabledHot()) {
                    return;
                }
                Object object = this.getHotData();
                Object object2 = new OpenOption[]{StandardOpenOption.CREATE};
                OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                object = outputStream;
                object2 = null;
                try {
                    Buffer buffer;
                    OutputStream stream = (OutputStream)object;
                    boolean bl = false;
                    Buffer $this$saveData_u24lambda_u240_u240 = buffer = new Buffer();
                    boolean bl2 = false;
                    $this$saveData_u24lambda_u240_u240.writeByte((byte)1);
                    INSTANCE.writeTimeMap((Sink)$this$saveData_u24lambda_u240_u240, (Map<Player, Long>)RunningProviders.INSTANCE.getAttackTime().getMap());
                    INSTANCE.writeTimeMap((Sink)$this$saveData_u24lambda_u240_u240, (Map<Player, Long>)RunningProviders.INSTANCE.getMoveTime().getMap());
                    BuffersJvmKt.copyTo$default((Buffer)buffer, (OutputStream)stream, (long)0L, (long)0L, (int)6, null);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                this.getHotData().toFile().deleteOnExit();
            }
            catch (Throwable e) {
                TopLevelsKt.getCore().err("[CoreModule] Failed to save hotData", e);
            }
        }

        private final void writeTimeMap(Sink $this$writeTimeMap, Map<Player, Long> map) {
            $this$writeTimeMap.writeInt(map.size());
            for (Map.Entry<Player, Long> entry : map.entrySet()) {
                Player player = entry.getKey();
                long time = ((Number)entry.getValue()).longValue();
                KotlinxIoKt.writeUuid($this$writeTimeMap, player.getUniqueId());
                $this$writeTimeMap.writeLong(time);
            }
        }

        private final void readTimeMap(Source $this$readTimeMap, Map<Player, Long> ... maps) {
            int size = $this$readTimeMap.readInt();
            for (int i = 0; i < size; ++i) {
                int it = i;
                boolean bl = false;
                UUID uuid = KotlinxIoKt.readUuid($this$readTimeMap);
                long time = $this$readTimeMap.readLong();
                if (Bukkit.getPlayer((UUID)uuid) == null) continue;
                boolean bl2 = false;
                for (Map<Player, Long> map : maps) {
                    Player player;
                    map.putIfAbsent(player, time);
                }
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lio/github/rothes/esu/bukkit/module/core/CoreController$Listeners;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onPlayerMove", "", "event", "Lorg/bukkit/event/player/PlayerMoveEvent;", "onPlayerJoin", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onPlayerQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "onDamage", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "bukkit"})
    private static final class Listeners
    implements Listener {
        @NotNull
        public static final Listeners INSTANCE = new Listeners();

        private Listeners() {
        }

        @EventHandler
        public final void onPlayerMove(@NotNull PlayerMoveEvent event) {
            Player p = event.getPlayer();
            long now = System.currentTimeMillis();
            RunningProviders.INSTANCE.getMoveTime().set(p, now);
            if (!Intrinsics.areEqual((Object)event.getFrom().getWorld(), (Object)event.getTo().getWorld()) || event.getFrom().distanceSquared(event.getTo()) >= 0.0078125) {
                RunningProviders.INSTANCE.getPosMoveTime().set(p, now);
            }
        }

        @EventHandler(priority=EventPriority.LOWEST)
        public final void onPlayerJoin(@NotNull PlayerJoinEvent event) {
            Player p = event.getPlayer();
            long now = System.currentTimeMillis();
            RunningProviders.INSTANCE.getMoveTime().set(p, now);
            RunningProviders.INSTANCE.getPosMoveTime().set(p, now);
            RunningProviders.INSTANCE.getAttackTime().set(p, now);
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public final void onPlayerQuit(@NotNull PlayerQuitEvent event) {
            Player p = event.getPlayer();
            RunningProviders.INSTANCE.getAttackTime().unload(p);
            RunningProviders.INSTANCE.getPosMoveTime().unload(p);
            RunningProviders.INSTANCE.getMoveTime().unload(p);
            RunningProviders.INSTANCE.getGenericActiveTime().unload(p);
        }

        @EventHandler
        public final void onDamage(@NotNull EntityDamageByEntityEvent event) {
            Entity entity = event.getDamager();
            Player player = entity instanceof Player ? (Player)entity : null;
            if (player == null) {
                return;
            }
            Player damager = player;
            RunningProviders.INSTANCE.getAttackTime().set(damager, System.currentTimeMillis());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0006H\u0096\u0002J\u0019\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0007H\u0096\u0002J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\fH\u0016R\u001f\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/rothes/esu/bukkit/module/core/CoreController$MapPlayerTimeProvider;", "Lio/github/rothes/esu/bukkit/module/core/PlayerTimeProvider;", "<init>", "()V", "map", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/bukkit/entity/Player;", "", "getMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lio/github/rothes/esu/bukkit/module/core/PlayerTimeProvider$ChangeListener;", "get", "player", "set", "", "time", "unload", "registerListener", "listener", "unregisterListener", "bukkit"})
    public static final class MapPlayerTimeProvider
    implements PlayerTimeProvider {
        @NotNull
        private final ConcurrentHashMap<Player, Long> map = new ConcurrentHashMap();
        @NotNull
        private final CopyOnWriteArrayList<PlayerTimeProvider.ChangeListener> listeners = new CopyOnWriteArrayList();

        @ApiStatus.Internal
        @NotNull
        public final ConcurrentHashMap<Player, Long> getMap() {
            return this.map;
        }

        @Override
        public long get(@NotNull Player player) {
            Long l = this.map.get(player);
            return l != null ? l : 0L;
        }

        @Override
        public void set(@NotNull Player player, long time) {
            Long l = this.map.put(player, time);
            long old = l != null ? l : 0L;
            for (PlayerTimeProvider.ChangeListener listener2 : this.listeners) {
                try {
                    listener2.onTimeChanged(player, old, time);
                }
                catch (Throwable e) {
                    TopLevelsKt.getCore().err("An provider exception occurred:", e);
                }
            }
        }

        public final void unload(@NotNull Player player) {
            this.map.remove(player);
        }

        @Override
        public void registerListener(@NotNull PlayerTimeProvider.ChangeListener listener2) {
            this.listeners.add(listener2);
        }

        @Override
        public void unregisterListener(@NotNull PlayerTimeProvider.ChangeListener listener2) {
            this.listeners.remove(listener2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0011"}, d2={"Lio/github/rothes/esu/bukkit/module/core/CoreController$RunningProviders;", "Lio/github/rothes/esu/bukkit/module/core/Providers;", "<init>", "()V", "isEnabled", "", "()Z", "attackTime", "Lio/github/rothes/esu/bukkit/module/core/CoreController$MapPlayerTimeProvider;", "getAttackTime", "()Lio/github/rothes/esu/bukkit/module/core/CoreController$MapPlayerTimeProvider;", "posMoveTime", "getPosMoveTime", "moveTime", "getMoveTime", "genericActiveTime", "getGenericActiveTime", "bukkit"})
    public static final class RunningProviders
    implements Providers {
        @NotNull
        public static final RunningProviders INSTANCE;
        private static final boolean isEnabled;
        @NotNull
        private static final MapPlayerTimeProvider attackTime;
        @NotNull
        private static final MapPlayerTimeProvider posMoveTime;
        @NotNull
        private static final MapPlayerTimeProvider moveTime;
        @NotNull
        private static final MapPlayerTimeProvider genericActiveTime;

        private RunningProviders() {
        }

        @Override
        public boolean isEnabled() {
            return isEnabled;
        }

        @Override
        @NotNull
        public MapPlayerTimeProvider getAttackTime() {
            return attackTime;
        }

        @Override
        @NotNull
        public MapPlayerTimeProvider getPosMoveTime() {
            return posMoveTime;
        }

        @Override
        @NotNull
        public MapPlayerTimeProvider getMoveTime() {
            return moveTime;
        }

        @Override
        @NotNull
        public MapPlayerTimeProvider getGenericActiveTime() {
            return genericActiveTime;
        }

        static {
            MapPlayerTimeProvider mapPlayerTimeProvider;
            INSTANCE = new RunningProviders();
            isEnabled = true;
            attackTime = new MapPlayerTimeProvider();
            posMoveTime = new MapPlayerTimeProvider();
            moveTime = new MapPlayerTimeProvider();
            MapPlayerTimeProvider it = mapPlayerTimeProvider = new MapPlayerTimeProvider();
            boolean bl = false;
            PlayerTimeProvider.ChangeListener listener2 = new PlayerTimeProvider.ChangeListener(it){
                final /* synthetic */ MapPlayerTimeProvider $it;
                {
                    this.$it = $it;
                }

                public void onTimeChanged(Player player, long oldTime, long newTime) {
                    this.$it.set(player, newTime);
                }
            };
            INSTANCE.getAttackTime().registerListener(listener2);
            INSTANCE.getPosMoveTime().registerListener(listener2);
            INSTANCE.getMoveTime().registerListener(listener2);
            genericActiveTime = mapPlayerTimeProvider;
        }
    }
}

