/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle;

import com.destroystokyo.paper.event.player.PlayerStartSpectatingEntityEvent;
import com.destroystokyo.paper.event.player.PlayerStopSpectatingEntityEvent;
import io.github.rothes.esu.bukkit.TopLevelsKt;
import io.github.rothes.esu.bukkit.module.CoreModule;
import io.github.rothes.esu.bukkit.module.core.PlayerTimeProvider;
import io.github.rothes.esu.bukkit.module.networkthrottle.afkefficiency.AfkEfficiencyFeature;
import io.github.rothes.esu.bukkit.module.networkthrottle.afkefficiency.EntityTrackingEfficiency;
import io.github.rothes.esu.bukkit.module.networkthrottle.afkefficiency.LimitedPacketEfficiency;
import io.github.rothes.esu.bukkit.user.PlayerUser;
import io.github.rothes.esu.bukkit.util.ServerCompatibility;
import io.github.rothes.esu.bukkit.util.extension.ListenersKt;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.CommonFeature;
import io.github.rothes.esu.core.module.Feature;
import io.github.rothes.esu.core.module.configuration.BaseFeatureConfiguration;
import io.github.rothes.esu.core.user.User;
import io.github.rothes.esu.lib.adventure.text.minimessage.tag.resolver.TagResolver;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0006\u001c\u001d\u001e\u001f !B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\r\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\u00130\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency;", "Lio/github/rothes/esu/core/module/CommonFeature;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$FeatureConfig;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$FeatureLang;", "<init>", "()V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "playerMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/bukkit/entity/Player;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$PlayerHolder;", "efficiencyFeatures", "", "Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/AfkEfficiencyFeature;", "getEfficiencyFeatures", "()Ljava/util/List;", "efficiencyPlayers", "", "Lkotlin/jvm/internal/EnhancedNullability;", "getEfficiencyPlayers", "()Ljava/util/Collection;", "checkUnavailable", "Lio/github/rothes/esu/core/module/Feature$AvailableCheck;", "onReload", "", "onEnable", "onDisable", "PlayerHolder", "PlayerListeners", "SpectateListeners", "PlayerMoveListener", "FeatureConfig", "FeatureLang", "bukkit"})
@SourceDebugExtension(value={"SMAP\nAfkEfficiency.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AfkEfficiency.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n812#2,12:225\n777#2:237\n873#2,2:238\n*S KotlinDebug\n*F\n+ 1 AfkEfficiency.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency\n*L\n40#1:225,12\n40#1:237\n40#1:238,2\n*E\n"})
public final class AfkEfficiency
extends CommonFeature<FeatureConfig, FeatureLang> {
    @NotNull
    public static final AfkEfficiency INSTANCE = new AfkEfficiency();
    @NotNull
    private static final CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()));
    @NotNull
    private static final ConcurrentHashMap<Player, PlayerHolder> playerMap = new ConcurrentHashMap();

    private AfkEfficiency() {
    }

    /*
     * WARNING - void declaration
     */
    private final List<AfkEfficiencyFeature<?, ?>> getEfficiencyFeatures() {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.getChildren().values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AfkEfficiencyFeature)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AfkEfficiencyFeature it = (AfkEfficiencyFeature)element$iv$iv;
            boolean bl = false;
            if (!it.getEnabled()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Collection<PlayerHolder> getEfficiencyPlayers() {
        return playerMap.values();
    }

    @Override
    @Nullable
    public Feature.AvailableCheck checkUnavailable() {
        Feature.AvailableCheck availableCheck = super.checkUnavailable();
        if (availableCheck == null) {
            AfkEfficiency it = this;
            boolean bl = false;
            if (!CoreModule.INSTANCE.getEnabled()) {
                return Feature.AvailableCheck.Companion.errFail(INSTANCE, (Function1<? super User, MessageData>)((Function1)AfkEfficiency::checkUnavailable$lambda$0$0));
            }
            availableCheck = null;
        }
        return availableCheck;
    }

    @Override
    public void onReload() {
        super.onReload();
        if (this.getEnabled()) {
            for (PlayerHolder holder : playerMap.values()) {
                PlayerHolder.reschedule$default(holder, 0L, 1, null);
            }
        }
    }

    @Override
    public void onEnable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ((Map)playerMap).put(player, new PlayerHolder(player));
        }
        ListenersKt.register$default(PlayerListeners.INSTANCE, null, 1, null);
        ListenersKt.register$default(SpectateListeners.INSTANCE.getListener(), null, 1, null);
        CoreModule.INSTANCE.getProviders().getPosMoveTime().registerListener(PlayerMoveListener.INSTANCE);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        ListenersKt.unregister(PlayerListeners.INSTANCE);
        ListenersKt.unregister(SpectateListeners.INSTANCE.getListener());
        CoreModule.INSTANCE.getProviders().getPosMoveTime().unregisterListener(PlayerMoveListener.INSTANCE);
        for (PlayerHolder holder : playerMap.values()) {
            holder.shutdown();
        }
        playerMap.clear();
    }

    private static final MessageData checkUnavailable$lambda$0$0(User it) {
        return MessageData.Companion.getMessage("This feature required CoreModule enabled");
    }

    static {
        INSTANCE.registerFeature(EntityTrackingEfficiency.INSTANCE);
        INSTANCE.registerFeature(LimitedPacketEfficiency.INSTANCE);
    }

    @Comment(value="\n        Limit packets send to afk players to reduce upload bandwidth usage.\n        Players will see delayed/desync world during afk efficiency mode.\n    ")
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseFeatureConfiguration;", "afkDuration", "Ljava/time/Duration;", "<init>", "(Ljava/time/Duration;)V", "getAfkDuration", "()Ljava/time/Duration;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "bukkit"})
    public static final class FeatureConfig
    extends BaseFeatureConfiguration {
        @Comment(value="\n            The duration player must afk for to trigger afk efficiency mode.\n        ")
        @NotNull
        private final Duration afkDuration;

        public FeatureConfig(@NotNull Duration afkDuration) {
            super(false, 1, null);
            this.afkDuration = afkDuration;
        }

        public /* synthetic */ FeatureConfig(Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                duration = Duration.ofMinutes(2L);
            }
            this(duration);
        }

        @NotNull
        public final Duration getAfkDuration() {
            return this.afkDuration;
        }

        @NotNull
        public final Duration component1() {
            return this.afkDuration;
        }

        @NotNull
        public final FeatureConfig copy(@NotNull Duration afkDuration) {
            return new FeatureConfig(afkDuration);
        }

        public static /* synthetic */ FeatureConfig copy$default(FeatureConfig featureConfig, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                duration = featureConfig.afkDuration;
            }
            return featureConfig.copy(duration);
        }

        @NotNull
        public String toString() {
            return "FeatureConfig(afkDuration=" + this.afkDuration + ")";
        }

        public int hashCode() {
            return this.afkDuration.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureConfig)) {
                return false;
            }
            FeatureConfig featureConfig = (FeatureConfig)other;
            return Intrinsics.areEqual((Object)this.afkDuration, (Object)featureConfig.afkDuration);
        }

        public FeatureConfig() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$FeatureLang;", "", "afkEfficiencyEnabled", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "afkEfficiencyDisabled", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;Lio/github/rothes/esu/core/configuration/data/MessageData;)V", "getAfkEfficiencyEnabled", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getAfkEfficiencyDisabled", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bukkit"})
    public static final class FeatureLang {
        @NotNull
        private final MessageData afkEfficiencyEnabled;
        @NotNull
        private final MessageData afkEfficiencyDisabled;

        public FeatureLang(@NotNull MessageData afkEfficiencyEnabled, @NotNull MessageData afkEfficiencyDisabled) {
            this.afkEfficiencyEnabled = afkEfficiencyEnabled;
            this.afkEfficiencyDisabled = afkEfficiencyDisabled;
        }

        public /* synthetic */ FeatureLang(MessageData messageData, MessageData messageData2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                messageData = MessageData.Companion.getMessage("<tc>Efficiency mode activated, world changes are delayed.<title:0:365d:0><subtitle><tc>Efficiency mode activating");
            }
            if ((n & 2) != 0) {
                messageData2 = MessageData.Companion.getMessage("<title:0:1s:0.5s><subtitle><pdc>Efficiency mode disabled<sound:minecraft:block.note_block.bell:master:0.5>");
            }
            this(messageData, messageData2);
        }

        @NotNull
        public final MessageData getAfkEfficiencyEnabled() {
            return this.afkEfficiencyEnabled;
        }

        @NotNull
        public final MessageData getAfkEfficiencyDisabled() {
            return this.afkEfficiencyDisabled;
        }

        @NotNull
        public final MessageData component1() {
            return this.afkEfficiencyEnabled;
        }

        @NotNull
        public final MessageData component2() {
            return this.afkEfficiencyDisabled;
        }

        @NotNull
        public final FeatureLang copy(@NotNull MessageData afkEfficiencyEnabled, @NotNull MessageData afkEfficiencyDisabled) {
            return new FeatureLang(afkEfficiencyEnabled, afkEfficiencyDisabled);
        }

        public static /* synthetic */ FeatureLang copy$default(FeatureLang featureLang, MessageData messageData, MessageData messageData2, int n, Object object) {
            if ((n & 1) != 0) {
                messageData = featureLang.afkEfficiencyEnabled;
            }
            if ((n & 2) != 0) {
                messageData2 = featureLang.afkEfficiencyDisabled;
            }
            return featureLang.copy(messageData, messageData2);
        }

        @NotNull
        public String toString() {
            return "FeatureLang(afkEfficiencyEnabled=" + this.afkEfficiencyEnabled + ", afkEfficiencyDisabled=" + this.afkEfficiencyDisabled + ")";
        }

        public int hashCode() {
            int result = this.afkEfficiencyEnabled.hashCode();
            result = result * 31 + this.afkEfficiencyDisabled.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureLang)) {
                return false;
            }
            FeatureLang featureLang = (FeatureLang)other;
            if (!Intrinsics.areEqual((Object)this.afkEfficiencyEnabled, (Object)featureLang.afkEfficiencyEnabled)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.afkEfficiencyDisabled, (Object)featureLang.afkEfficiencyDisabled);
        }

        public FeatureLang() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0015J\u0006\u0010\u0019\u001a\u00020\u0015J\u0006\u0010\u001a\u001a\u00020\u0015J\u0010\u0010\u001b\u001a\u00020\u00152\b\b\u0002\u0010\u001c\u001a\u00020\u0017J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$PlayerHolder;", "", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "getPlayer", "()Lorg/bukkit/entity/Player;", "user", "Lio/github/rothes/esu/bukkit/user/PlayerUser;", "getUser", "()Lio/github/rothes/esu/bukkit/user/PlayerUser;", "inAfk", "", "getInAfk", "()Z", "setInAfk", "(Z)V", "afkTask", "Lkotlinx/coroutines/Job;", "reschedule", "", "lastAction", "", "cancel", "shutdown", "enableEfficiency", "disableEfficiency", "delta", "createAfkTask", "bukkit"})
    public static final class PlayerHolder {
        @NotNull
        private final Player player;
        @NotNull
        private final PlayerUser user;
        private boolean inAfk;
        @Nullable
        private Job afkTask;

        public PlayerHolder(@NotNull Player player) {
            this.player = player;
            this.user = TopLevelsKt.getUser(this.player);
            PlayerHolder.reschedule$default(this, 0L, 1, null);
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        @NotNull
        public final PlayerUser getUser() {
            return this.user;
        }

        public final boolean getInAfk() {
            return this.inAfk;
        }

        public final void setInAfk(boolean bl) {
            this.inAfk = bl;
        }

        public final synchronized void reschedule(long lastAction) {
            this.cancel();
            this.afkTask = this.createAfkTask(lastAction);
        }

        public static /* synthetic */ void reschedule$default(PlayerHolder playerHolder, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = CoreModule.INSTANCE.getProviders().getPosMoveTime().get(playerHolder.player);
            }
            playerHolder.reschedule(l);
        }

        public final synchronized void cancel() {
            Job job = this.afkTask;
            if (job != null) {
                Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
            }
            this.afkTask = null;
        }

        public final synchronized void shutdown() {
            PlayerHolder.disableEfficiency$default(this, 0L, 1, null);
            this.cancel();
        }

        public final synchronized void enableEfficiency() {
            if (this.inAfk) {
                return;
            }
            this.cancel();
            this.inAfk = true;
            for (AfkEfficiencyFeature feature : INSTANCE.getEfficiencyFeatures()) {
                try {
                    feature.onEnableEfficiency(this);
                }
                catch (Throwable e) {
                    TopLevelsKt.getCore().err("[AfkEfficiency] An error occurred while enabling " + feature.getName(), e);
                }
            }
            this.user.sendMessage(INSTANCE.getLang(), PlayerHolder::enableEfficiency$lambda$0, new TagResolver[0]);
        }

        public final synchronized void disableEfficiency(long delta) {
            if (this.inAfk) {
                this.inAfk = false;
                for (AfkEfficiencyFeature feature : INSTANCE.getEfficiencyFeatures()) {
                    try {
                        feature.onDisableEfficiency(this);
                    }
                    catch (Throwable e) {
                        TopLevelsKt.getCore().err("[AfkEfficiency] An error occurred while disabling " + feature.getName(), e);
                    }
                }
                this.user.sendMessage(INSTANCE.getLang(), PlayerHolder::disableEfficiency$lambda$0, new TagResolver[0]);
            }
            if (delta >= 0L) {
                this.reschedule(delta);
            }
        }

        public static /* synthetic */ void disableEfficiency$default(PlayerHolder playerHolder, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = CoreModule.INSTANCE.getProviders().getPosMoveTime().get(playerHolder.player);
            }
            playerHolder.disableEfficiency(l);
        }

        private final Job createAfkTask(long lastAction) {
            return BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(lastAction, this, null){
                long J$0;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ long $lastAction;
                final /* synthetic */ PlayerHolder this$0;
                {
                    this.$lastAction = $lastAction;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = (CoroutineScope)this.L$0;
                    var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            afkTime = System.currentTimeMillis() - this.$lastAction;
                            this.L$0 = $this$launch;
                            this.J$0 = afkTime;
                            this.label = 1;
                            v0 = DelayKt.delay((long)(((FeatureConfig)AfkEfficiency.INSTANCE.getConfig()).getAfkDuration().toMillis() - afkTime), (Continuation)((Continuation)this));
                            if (v0 == var5_3) {
                                return var5_3;
                            }
                            ** GOTO lbl18
                        }
                        case 1: {
                            afkTime = this.J$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl18:
                            // 2 sources

                            if (!CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                return Unit.INSTANCE;
                            }
                            this.this$0.enableEfficiency();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        private static final MessageData enableEfficiency$lambda$0(FeatureLang $this$message) {
            return $this$message.getAfkEfficiencyEnabled();
        }

        private static final MessageData disableEfficiency$lambda$0(FeatureLang $this$message) {
            return $this$message.getAfkEfficiencyDisabled();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$PlayerListeners;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onJoin", "", "event", "Lorg/bukkit/event/player/PlayerJoinEvent;", "onQuit", "Lorg/bukkit/event/player/PlayerQuitEvent;", "bukkit"})
    private static final class PlayerListeners
    implements Listener {
        @NotNull
        public static final PlayerListeners INSTANCE = new PlayerListeners();

        private PlayerListeners() {
        }

        @EventHandler
        public final void onJoin(@NotNull PlayerJoinEvent event) {
            block0: {
                PlayerHolder playerHolder = playerMap.put(event.getPlayer(), new PlayerHolder(event.getPlayer()));
                if (playerHolder == null) break block0;
                playerHolder.shutdown();
            }
        }

        @EventHandler
        public final void onQuit(@NotNull PlayerQuitEvent event) {
            block0: {
                PlayerHolder playerHolder = (PlayerHolder)playerMap.remove(event.getPlayer());
                if (playerHolder == null) break block0;
                playerHolder.shutdown();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$PlayerMoveListener;", "Lio/github/rothes/esu/bukkit/module/core/PlayerTimeProvider$ChangeListener;", "<init>", "()V", "onTimeChanged", "", "player", "Lorg/bukkit/entity/Player;", "oldTime", "", "newTime", "bukkit"})
    private static final class PlayerMoveListener
    implements PlayerTimeProvider.ChangeListener {
        @NotNull
        public static final PlayerMoveListener INSTANCE = new PlayerMoveListener();

        private PlayerMoveListener() {
        }

        @Override
        public void onTimeChanged(@NotNull Player player, long oldTime, long newTime) {
            block0: {
                PlayerHolder playerHolder = (PlayerHolder)playerMap.get(player);
                if (playerHolder == null) break block0;
                playerHolder.disableEfficiency(newTime);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002\b\tB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$SpectateListeners;", "", "<init>", "()V", "listener", "Lorg/bukkit/event/Listener;", "getListener", "()Lorg/bukkit/event/Listener;", "CB", "Paper", "bukkit"})
    private static final class SpectateListeners {
        @NotNull
        public static final SpectateListeners INSTANCE = new SpectateListeners();
        @NotNull
        private static final Listener listener = ServerCompatibility.INSTANCE.isPaper() ? (Listener)Paper.INSTANCE : (Listener)CB.INSTANCE;

        private SpectateListeners() {
        }

        @NotNull
        public final Listener getListener() {
            return listener;
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$SpectateListeners$CB;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onSpectate", "", "event", "Lorg/bukkit/event/player/PlayerTeleportEvent;", "bukkit"})
        private static final class CB
        implements Listener {
            @NotNull
            public static final CB INSTANCE = new CB();

            private CB() {
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void onSpectate(@NotNull PlayerTeleportEvent event) {
                block1: {
                    if (event.getCause() != PlayerTeleportEvent.TeleportCause.SPECTATE) {
                        return;
                    }
                    PlayerHolder playerHolder = (PlayerHolder)playerMap.get(event.getPlayer());
                    if (playerHolder == null) break block1;
                    playerHolder.cancel();
                }
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$SpectateListeners$Paper;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onSpectate", "", "event", "Lcom/destroystokyo/paper/event/player/PlayerStartSpectatingEntityEvent;", "Lcom/destroystokyo/paper/event/player/PlayerStopSpectatingEntityEvent;", "bukkit"})
        private static final class Paper
        implements Listener {
            @NotNull
            public static final Paper INSTANCE = new Paper();

            private Paper() {
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void onSpectate(@NotNull PlayerStartSpectatingEntityEvent event) {
                block0: {
                    PlayerHolder playerHolder = (PlayerHolder)playerMap.get(event.getPlayer());
                    if (playerHolder == null) break block0;
                    PlayerHolder it = playerHolder;
                    boolean bl = false;
                    it.disableEfficiency(-1L);
                    it.cancel();
                }
            }

            @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
            public final void onSpectate(@NotNull PlayerStopSpectatingEntityEvent event) {
                block0: {
                    PlayerHolder playerHolder = (PlayerHolder)playerMap.get(event.getPlayer());
                    if (playerHolder == null) break block0;
                    PlayerHolder.reschedule$default(playerHolder, 0L, 1, null);
                }
            }
        }
    }
}

