/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle;

import ca.spottedleaf.moonrise.common.misc.AllocatingRateLimiter;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import io.github.rothes.esu.bukkit.TopLevelsKt;
import io.github.rothes.esu.bukkit.util.ServerCompatibility;
import io.github.rothes.esu.bukkit.util.scheduler.Scheduler;
import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.CommonFeature;
import io.github.rothes.esu.core.module.Feature;
import io.github.rothes.esu.core.module.configuration.EmptyConfiguration;
import io.github.rothes.esu.core.module.configuration.EnableTogglable;
import io.github.rothes.esu.core.user.User;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.lang.reflect.Field;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR#\u0010\u000f\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR#\u0010\u0012\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0013\u0010\fR#\u0010\u0015\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000e\u001a\u0004\b\u0016\u0010\f\u00a8\u0006\u001e"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/DynamicChunkSendRate;", "Lio/github/rothes/esu/core/module/CommonFeature;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/DynamicChunkSendRate$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/EmptyConfiguration;", "<init>", "()V", "CHANNEL_ID", "", "limiterLoad", "Ljava/lang/reflect/Field;", "kotlin.jvm.PlatformType", "getLimiterLoad", "()Ljava/lang/reflect/Field;", "limiterLoad$delegate", "Lkotlin/Lazy;", "limiterSend", "getLimiterSend", "limiterSend$delegate", "allocation", "getAllocation", "allocation$delegate", "takeCarry", "getTakeCarry", "takeCarry$delegate", "checkUnavailable", "Lio/github/rothes/esu/core/module/Feature$AvailableCheck;", "onEnable", "", "onDisable", "FeatureConfig", "bukkit"})
@SourceDebugExtension(value={"SMAP\nDynamicChunkSendRate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicChunkSendRate.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/DynamicChunkSendRate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class DynamicChunkSendRate
extends CommonFeature<FeatureConfig, EmptyConfiguration> {
    @NotNull
    public static final DynamicChunkSendRate INSTANCE = new DynamicChunkSendRate();
    @NotNull
    private static final String CHANNEL_ID = "esu:dynamic_chunk_send_rate_limit";
    @NotNull
    private static final Lazy limiterLoad$delegate = LazyKt.lazy(DynamicChunkSendRate::limiterLoad_delegate$lambda$0);
    @NotNull
    private static final Lazy limiterSend$delegate = LazyKt.lazy(DynamicChunkSendRate::limiterSend_delegate$lambda$0);
    @NotNull
    private static final Lazy allocation$delegate = LazyKt.lazy(DynamicChunkSendRate::allocation_delegate$lambda$0);
    @NotNull
    private static final Lazy takeCarry$delegate = LazyKt.lazy(DynamicChunkSendRate::takeCarry_delegate$lambda$0);

    private DynamicChunkSendRate() {
    }

    private final Field getLimiterLoad() {
        Lazy lazy = limiterLoad$delegate;
        return (Field)lazy.getValue();
    }

    private final Field getLimiterSend() {
        Lazy lazy = limiterSend$delegate;
        return (Field)lazy.getValue();
    }

    private final Field getAllocation() {
        Lazy lazy = allocation$delegate;
        return (Field)lazy.getValue();
    }

    private final Field getTakeCarry() {
        Lazy lazy = takeCarry$delegate;
        return (Field)lazy.getValue();
    }

    @Override
    @Nullable
    public Feature.AvailableCheck checkUnavailable() {
        Feature.AvailableCheck availableCheck = super.checkUnavailable();
        if (availableCheck == null) {
            DynamicChunkSendRate it = this;
            boolean bl = false;
            if (!ServerCompatibility.INSTANCE.isProxyMode()) {
                TopLevelsKt.getCore().err("[DynamicChunkSendRate] This server is not on BungeeCord mode or Velocity mode. You should not enable this feature.");
                return Feature.AvailableCheck.Companion.fail((Function1<? super User, MessageData>)((Function1)DynamicChunkSendRate::checkUnavailable$lambda$0$0));
            }
            try {
                INSTANCE.getLimiterLoad();
                INSTANCE.getLimiterSend();
                INSTANCE.getAllocation();
                INSTANCE.getTakeCarry();
            }
            catch (Throwable t) {
                TopLevelsKt.getCore().err("[DynamicChunkSendRate] Server not supported: " + t);
                return Feature.AvailableCheck.Companion.fail((Function1<? super User, MessageData>)((Function1)DynamicChunkSendRate::checkUnavailable$lambda$0$1));
            }
            availableCheck = null;
        }
        return availableCheck;
    }

    @Override
    public void onEnable() {
        Bukkit.getMessenger().registerIncomingPluginChannel(TopLevelsKt.getPlugin(), CHANNEL_ID, DynamicChunkSendRate::onEnable$lambda$0);
    }

    @Override
    public void onDisable() {
        Bukkit.getMessenger().unregisterIncomingPluginChannel(TopLevelsKt.getPlugin(), CHANNEL_ID);
    }

    private static final Field limiterLoad_delegate$lambda$0() {
        Field field;
        Field it = field = RegionizedPlayerChunkLoader.PlayerChunkLoaderData.class.getDeclaredField("chunkLoadTicketLimiter");
        boolean bl = false;
        it.setAccessible(true);
        return field;
    }

    private static final Field limiterSend_delegate$lambda$0() {
        Field field;
        Field it = field = RegionizedPlayerChunkLoader.PlayerChunkLoaderData.class.getDeclaredField("chunkSendLimiter");
        boolean bl = false;
        it.setAccessible(true);
        return field;
    }

    private static final Field allocation_delegate$lambda$0() {
        Field field;
        Field it = field = AllocatingRateLimiter.class.getDeclaredField("allocation");
        boolean bl = false;
        it.setAccessible(true);
        return field;
    }

    private static final Field takeCarry_delegate$lambda$0() {
        Field field;
        Field it = field = AllocatingRateLimiter.class.getDeclaredField("takeCarry");
        boolean bl = false;
        it.setAccessible(true);
        return field;
    }

    private static final MessageData checkUnavailable$lambda$0$0(User it) {
        return MessageData.Companion.getMessage("This server is not on BungeeCord mode or Velocity mode");
    }

    private static final MessageData checkUnavailable$lambda$0$1(User it) {
        return MessageData.Companion.getMessage("Server not supported");
    }

    private static final Unit onEnable$lambda$0$func$1(Ref.IntRef $times, List $limiters, double $max, Player $player) {
        DynamicChunkSendRate.onEnable$lambda$0$func($times, $limiters, $max, $player);
        return Unit.INSTANCE;
    }

    private static final void onEnable$lambda$0$func(Ref.IntRef times, List<AllocatingRateLimiter> limiters, double max, Player $player) {
        times.element += -1;
        if (times.element > 0) {
            for (AllocatingRateLimiter rateLimiter : limiters) {
                INSTANCE.getTakeCarry().set(rateLimiter, (double)24 - max);
                Scheduler.schedule$default(Scheduler.INSTANCE, (Entity)$player, 1L, null, () -> DynamicChunkSendRate.onEnable$lambda$0$func$1(times, limiters, max, $player), 4, null);
            }
        }
    }

    private static final void onEnable$lambda$0(String channel, Player player, byte[] message) {
        Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.entity.CraftPlayer");
        RegionizedPlayerChunkLoader.PlayerChunkLoaderData chunkLoaderData = ((CraftPlayer)player).getHandle().moonrise$getChunkLoader();
        double it22 = Math.max(GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkSendRate, GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkLoadRate);
        boolean bl = false;
        boolean bl2 = 0.0 <= it22 ? it22 <= 10000.0 : false;
        double max = !bl2 ? 10000.0 : it22;
        Object[] it22 = new AllocatingRateLimiter[2];
        Intrinsics.checkNotNull((Object)INSTANCE.getLimiterLoad().get(chunkLoaderData), (String)"null cannot be cast to non-null type ca.spottedleaf.moonrise.common.misc.AllocatingRateLimiter");
        Intrinsics.checkNotNull((Object)INSTANCE.getLimiterSend().get(chunkLoaderData), (String)"null cannot be cast to non-null type ca.spottedleaf.moonrise.common.misc.AllocatingRateLimiter");
        List limiters = CollectionsKt.listOf((Object[])it22);
        Ref.IntRef times = new Ref.IntRef();
        times.element = 20;
        DynamicChunkSendRate.onEnable$lambda$0$func(times, limiters, max, player);
    }

    @Comment(value="Enable DynamicChunkSendRate. Make sure you have velocity mode on, and installed ESU on velocity.")
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\t\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0014\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0083\u0004J\n\u0010\u000e\u001a\u00020\u000fH\u00d6\u0081\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/DynamicChunkSendRate$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/EnableTogglable;", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "enabled", "", "<init>", "(Z)V", "getEnabled", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "bukkit"})
    public static final class FeatureConfig
    implements EnableTogglable,
    ConfigurationPart {
        private final boolean enabled;

        public FeatureConfig(boolean enabled) {
            this.enabled = enabled;
        }

        public /* synthetic */ FeatureConfig(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = ServerCompatibility.INSTANCE.isProxyMode();
            }
            this(bl);
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        public final boolean component1() {
            return this.enabled;
        }

        @NotNull
        public final FeatureConfig copy(boolean enabled) {
            return new FeatureConfig(enabled);
        }

        public static /* synthetic */ FeatureConfig copy$default(FeatureConfig featureConfig, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = featureConfig.enabled;
            }
            return featureConfig.copy(bl);
        }

        @NotNull
        public String toString() {
            return "FeatureConfig(enabled=" + this.enabled + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.enabled);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureConfig)) {
                return false;
            }
            FeatureConfig featureConfig = (FeatureConfig)other;
            return this.enabled == featureConfig.enabled;
        }

        public FeatureConfig() {
            this(false, 1, null);
        }
    }
}

