/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle.afkefficiency;

import io.github.rothes.esu.bukkit.TopLevelsKt;
import io.github.rothes.esu.bukkit.module.networkthrottle.AfkEfficiency;
import io.github.rothes.esu.bukkit.module.networkthrottle.afkefficiency.AfkEfficiencyFeature;
import io.github.rothes.esu.bukkit.util.ServerCompatibility;
import io.github.rothes.esu.bukkit.util.entity.PlayerEntityVisibilityProcessor;
import io.github.rothes.esu.bukkit.util.extension.PluginsKt;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.Feature;
import io.github.rothes.esu.core.module.configuration.BaseFeatureConfiguration;
import io.github.rothes.esu.core.user.User;
import io.github.rothes.esu.core.util.extension.math.ExtensionsKt;
import io.github.rothes.esu.lib.configurate.objectmapping.meta.PostProcess;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/EntityTrackingEfficiency;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/AfkEfficiencyFeature;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/EntityTrackingEfficiency$FeatureConfig;", "", "<init>", "()V", "playerData", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/bukkit/entity/Player;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/EntityTrackingEfficiency$VisibilityProcessor;", "pl", "Lorg/bukkit/plugin/Plugin;", "checkUnavailable", "Lio/github/rothes/esu/core/module/Feature$AvailableCheck;", "onDisable", "onEnableEfficiency", "playerHolder", "Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$PlayerHolder;", "onDisableEfficiency", "VisibilityProcessor", "FeatureConfig", "bukkit"})
@SourceDebugExtension(value={"SMAP\nEntityTrackingEfficiency.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityTrackingEfficiency.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/EntityTrackingEfficiency\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class EntityTrackingEfficiency
extends AfkEfficiencyFeature<FeatureConfig, Unit> {
    @NotNull
    public static final EntityTrackingEfficiency INSTANCE = new EntityTrackingEfficiency();
    @NotNull
    private static final ConcurrentHashMap<Player, VisibilityProcessor> playerData = new ConcurrentHashMap();
    @NotNull
    private static final Plugin pl = PluginsKt.createChild$default(TopLevelsKt.getPlugin(), TopLevelsKt.getPlugin().getName() + "-" + INSTANCE.getName(), false, 2, null);

    private EntityTrackingEfficiency() {
    }

    @Override
    @Nullable
    public Feature.AvailableCheck checkUnavailable() {
        Feature.AvailableCheck availableCheck = super.checkUnavailable();
        if (availableCheck == null) {
            EntityTrackingEfficiency it = this;
            boolean bl = false;
            if (ServerCompatibility.INSTANCE.getServerVersion().compareTo(19) < 0 || !ServerCompatibility.INSTANCE.isPaper()) {
                return Feature.AvailableCheck.Companion.errFail(INSTANCE, (Function1<? super User, MessageData>)((Function1)EntityTrackingEfficiency::checkUnavailable$lambda$0$0));
            }
            availableCheck = null;
        }
        return availableCheck;
    }

    @Override
    public void onDisable() {
        super.onDisable();
        for (VisibilityProcessor data : playerData.values()) {
            data.shutdown();
        }
        playerData.clear();
    }

    @Override
    public void onEnableEfficiency(@NotNull AfkEfficiency.PlayerHolder playerHolder) {
        VisibilityProcessor visibilityProcessor;
        Player player = playerHolder.getPlayer();
        Map map = playerData;
        VisibilityProcessor it = visibilityProcessor = new VisibilityProcessor(player);
        boolean bl = false;
        it.start();
        map.put(player, visibilityProcessor);
    }

    @Override
    public void onDisableEfficiency(@NotNull AfkEfficiency.PlayerHolder playerHolder) {
        block0: {
            VisibilityProcessor visibilityProcessor = playerData.remove(playerHolder.getPlayer());
            if (visibilityProcessor == null) break block0;
            visibilityProcessor.shutdown();
        }
    }

    private static final MessageData checkUnavailable$lambda$0$0(User it) {
        return MessageData.Companion.getMessage("Paper 1.19+ is required to enable this.");
    }

    @Comment(value="\n        Hide all far away entities from player.\n    ")
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004J\n\u0010\u001d\u001a\u00020\u001eH\u00d6\u0081\u0004R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000f\u0010\t\u00a8\u0006\u001f"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/EntityTrackingEfficiency$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseFeatureConfiguration;", "visibleEntityDistance", "", "updateIntervalTicks", "", "<init>", "(DJ)V", "getVisibleEntityDistance", "()D", "getUpdateIntervalTicks", "()J", "setUpdateIntervalTicks", "(J)V", "visibleEntityDistanceSquared", "getVisibleEntityDistanceSquared", "visibleEntityDistanceSquared$delegate", "Lkotlin/Lazy;", "pp", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "bukkit"})
    public static final class FeatureConfig
    extends BaseFeatureConfiguration {
        @Comment(value="Player could see nearby entities in this distance")
        private final double visibleEntityDistance;
        @Comment(value="Server game tick interval to update player nearby entities")
        private long updateIntervalTicks;
        @NotNull
        private final Lazy visibleEntityDistanceSquared$delegate;

        public FeatureConfig(double visibleEntityDistance, long updateIntervalTicks) {
            super(true);
            this.visibleEntityDistance = visibleEntityDistance;
            this.updateIntervalTicks = updateIntervalTicks;
            this.visibleEntityDistanceSquared$delegate = LazyKt.lazy(() -> FeatureConfig.visibleEntityDistanceSquared_delegate$lambda$0(this));
        }

        public /* synthetic */ FeatureConfig(double d, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                d = 7.0;
            }
            if ((n & 2) != 0) {
                l = 5L;
            }
            this(d, l);
        }

        public final double getVisibleEntityDistance() {
            return this.visibleEntityDistance;
        }

        public final long getUpdateIntervalTicks() {
            return this.updateIntervalTicks;
        }

        public final void setUpdateIntervalTicks(long l) {
            this.updateIntervalTicks = l;
        }

        public final double getVisibleEntityDistanceSquared() {
            Lazy lazy = this.visibleEntityDistanceSquared$delegate;
            return ((Number)lazy.getValue()).doubleValue();
        }

        @PostProcess
        private final void pp() {
            if (this.updateIntervalTicks < 1L) {
                TopLevelsKt.getCore().warn("[" + INSTANCE.getName() + "] UpdateIntervalTicks must be > 0 !");
                this.updateIntervalTicks = 1L;
            }
        }

        public final double component1() {
            return this.visibleEntityDistance;
        }

        public final long component2() {
            return this.updateIntervalTicks;
        }

        @NotNull
        public final FeatureConfig copy(double visibleEntityDistance, long updateIntervalTicks) {
            return new FeatureConfig(visibleEntityDistance, updateIntervalTicks);
        }

        public static /* synthetic */ FeatureConfig copy$default(FeatureConfig featureConfig, double d, long l, int n, Object object) {
            if ((n & 1) != 0) {
                d = featureConfig.visibleEntityDistance;
            }
            if ((n & 2) != 0) {
                l = featureConfig.updateIntervalTicks;
            }
            return featureConfig.copy(d, l);
        }

        @NotNull
        public String toString() {
            return "FeatureConfig(visibleEntityDistance=" + this.visibleEntityDistance + ", updateIntervalTicks=" + this.updateIntervalTicks + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.visibleEntityDistance);
            result = result * 31 + Long.hashCode(this.updateIntervalTicks);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureConfig)) {
                return false;
            }
            FeatureConfig featureConfig = (FeatureConfig)other;
            if (Double.compare(this.visibleEntityDistance, featureConfig.visibleEntityDistance) != 0) {
                return false;
            }
            return this.updateIntervalTicks == featureConfig.updateIntervalTicks;
        }

        private static final double visibleEntityDistanceSquared_delegate$lambda$0(FeatureConfig this$0) {
            return ExtensionsKt.square(this$0.visibleEntityDistance);
        }

        public FeatureConfig() {
            this(0.0, 0L, 3, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/EntityTrackingEfficiency$VisibilityProcessor;", "Lio/github/rothes/esu/bukkit/util/entity/PlayerEntityVisibilityProcessor$SyncTick;", "player", "Lorg/bukkit/entity/Player;", "<init>", "(Lorg/bukkit/entity/Player;)V", "updateIntervalTicks", "", "getUpdateIntervalTicks", "()J", "shouldHide", "Lio/github/rothes/esu/bukkit/util/entity/PlayerEntityVisibilityProcessor$HideState;", "entity", "Lorg/bukkit/entity/Entity;", "distSqr", "", "bukkit"})
    private static final class VisibilityProcessor
    extends PlayerEntityVisibilityProcessor.SyncTick {
        public VisibilityProcessor(@NotNull Player player) {
            super(player, pl);
        }

        public long getUpdateIntervalTicks() {
            return ((FeatureConfig)INSTANCE.getConfig()).getUpdateIntervalTicks();
        }

        @NotNull
        public PlayerEntityVisibilityProcessor.HideState shouldHide(@NotNull Entity entity, double distSqr) {
            return distSqr >= ((FeatureConfig)INSTANCE.getConfig()).getVisibleEntityDistanceSquared() ? PlayerEntityVisibilityProcessor.HideState.HIDE : PlayerEntityVisibilityProcessor.HideState.SHOW;
        }
    }
}

