/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.networkthrottle.afkefficiency;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketSendEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.protocol.packettype.PacketTypeCommon;
import com.github.retrooper.packetevents.util.Vector3d;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerDamageEvent;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntityHeadLook;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerEntitySoundEffect;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerHurtAnimation;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerParticle;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfo;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerPlayerInfoUpdate;
import com.github.retrooper.packetevents.wrapper.play.server.WrapperPlayServerSoundEffect;
import io.github.retrooper.packetevents.util.SpigotConversionUtil;
import io.github.rothes.esu.bukkit.module.networkthrottle.AfkEfficiency;
import io.github.rothes.esu.bukkit.module.networkthrottle.afkefficiency.AfkEfficiencyFeature;
import io.github.rothes.esu.bukkit.util.extension.FeaturesKt;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.Feature;
import io.github.rothes.esu.core.module.configuration.BaseFeatureConfiguration;
import io.github.rothes.esu.core.util.extension.math.ExtensionsKt;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0016RN\u0010\u0006\u001aB\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n \t* \u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/AfkEfficiencyFeature;", "Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig;", "", "<init>", "()V", "limiting", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lorg/bukkit/entity/Player;", "kotlin.jvm.PlatformType", "", "checkUnavailable", "Lio/github/rothes/esu/core/module/Feature$AvailableCheck;", "onEnable", "onDisable", "onEnableEfficiency", "playerHolder", "Lio/github/rothes/esu/bukkit/module/networkthrottle/AfkEfficiency$PlayerHolder;", "onDisableEfficiency", "PacketListeners", "FeatureConfig", "bukkit"})
public final class LimitedPacketEfficiency
extends AfkEfficiencyFeature<FeatureConfig, Unit> {
    @NotNull
    public static final LimitedPacketEfficiency INSTANCE = new LimitedPacketEfficiency();
    private static final ConcurrentHashMap.KeySetView<Player, Boolean> limiting = ConcurrentHashMap.newKeySet();

    private LimitedPacketEfficiency() {
    }

    @Override
    @Nullable
    public Feature.AvailableCheck checkUnavailable() {
        Feature.AvailableCheck availableCheck = super.checkUnavailable();
        if (availableCheck == null) {
            availableCheck = FeaturesKt.checkPacketEvents(this);
        }
        return availableCheck;
    }

    @Override
    public void onEnable() {
        super.onEnable();
        PacketListenerCommon[] packetListenerCommonArray = new PacketListenerCommon[]{PacketListeners.INSTANCE};
        PacketEvents.getAPI().getEventManager().registerListeners(packetListenerCommonArray);
    }

    @Override
    public void onDisable() {
        super.onDisable();
        PacketListenerCommon[] packetListenerCommonArray = new PacketListenerCommon[]{PacketListeners.INSTANCE};
        PacketEvents.getAPI().getEventManager().unregisterListeners(packetListenerCommonArray);
    }

    @Override
    public void onEnableEfficiency(@NotNull AfkEfficiency.PlayerHolder playerHolder) {
        limiting.add(playerHolder.getPlayer());
    }

    @Override
    public void onDisableEfficiency(@NotNull AfkEfficiency.PlayerHolder playerHolder) {
        limiting.remove(playerHolder.getPlayer());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseFeatureConfiguration;", "rangedPackets", "Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$RangedPackets;", "globalPackets", "Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$GlobalPackets;", "<init>", "(Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$RangedPackets;Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$GlobalPackets;)V", "getRangedPackets", "()Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$RangedPackets;", "getGlobalPackets", "()Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$GlobalPackets;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "RangedPackets", "GlobalPackets", "bukkit"})
    public static final class FeatureConfig
    extends BaseFeatureConfiguration {
        @Comment(value="\n            Limit far away world packets to player.\n            Set -1 to disable modifying specified packet, 0 to cancel all specified packet,\n             or a distance from player location of allowed packet.\n        ")
        @NotNull
        private final RangedPackets rangedPackets;
        @Comment(value="\n            Set to false to cancel specified packet.\n        ")
        @NotNull
        private final GlobalPackets globalPackets;

        public FeatureConfig(@NotNull RangedPackets rangedPackets, @NotNull GlobalPackets globalPackets) {
            super(true);
            this.rangedPackets = rangedPackets;
            this.globalPackets = globalPackets;
        }

        public /* synthetic */ FeatureConfig(RangedPackets rangedPackets, GlobalPackets globalPackets, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                rangedPackets = new RangedPackets(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 63, null);
            }
            if ((n & 2) != 0) {
                globalPackets = new GlobalPackets(false, null, 3, null);
            }
            this(rangedPackets, globalPackets);
        }

        @NotNull
        public final RangedPackets getRangedPackets() {
            return this.rangedPackets;
        }

        @NotNull
        public final GlobalPackets getGlobalPackets() {
            return this.globalPackets;
        }

        @NotNull
        public final RangedPackets component1() {
            return this.rangedPackets;
        }

        @NotNull
        public final GlobalPackets component2() {
            return this.globalPackets;
        }

        @NotNull
        public final FeatureConfig copy(@NotNull RangedPackets rangedPackets, @NotNull GlobalPackets globalPackets) {
            return new FeatureConfig(rangedPackets, globalPackets);
        }

        public static /* synthetic */ FeatureConfig copy$default(FeatureConfig featureConfig, RangedPackets rangedPackets, GlobalPackets globalPackets, int n, Object object) {
            if ((n & 1) != 0) {
                rangedPackets = featureConfig.rangedPackets;
            }
            if ((n & 2) != 0) {
                globalPackets = featureConfig.globalPackets;
            }
            return featureConfig.copy(rangedPackets, globalPackets);
        }

        @NotNull
        public String toString() {
            return "FeatureConfig(rangedPackets=" + this.rangedPackets + ", globalPackets=" + this.globalPackets + ")";
        }

        public int hashCode() {
            int result = this.rangedPackets.hashCode();
            result = result * 31 + this.globalPackets.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureConfig)) {
                return false;
            }
            FeatureConfig featureConfig = (FeatureConfig)other;
            if (!Intrinsics.areEqual((Object)this.rangedPackets, (Object)featureConfig.rangedPackets)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.globalPackets, (Object)featureConfig.globalPackets);
        }

        public FeatureConfig() {
            this(null, null, 3, null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0015B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$GlobalPackets;", "", "timeUpdate", "", "playerInfoUpdate", "Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$GlobalPackets$PlayerInfoUpdate;", "<init>", "(ZLio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$GlobalPackets$PlayerInfoUpdate;)V", "getTimeUpdate", "()Z", "getPlayerInfoUpdate", "()Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$GlobalPackets$PlayerInfoUpdate;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "PlayerInfoUpdate", "bukkit"})
        public static final class GlobalPackets {
            private final boolean timeUpdate;
            @NotNull
            private final PlayerInfoUpdate playerInfoUpdate;

            public GlobalPackets(boolean timeUpdate, @NotNull PlayerInfoUpdate playerInfoUpdate) {
                this.timeUpdate = timeUpdate;
                this.playerInfoUpdate = playerInfoUpdate;
            }

            public /* synthetic */ GlobalPackets(boolean bl, PlayerInfoUpdate playerInfoUpdate, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    bl = true;
                }
                if ((n & 2) != 0) {
                    playerInfoUpdate = new PlayerInfoUpdate(false, false, 3, null);
                }
                this(bl, playerInfoUpdate);
            }

            public final boolean getTimeUpdate() {
                return this.timeUpdate;
            }

            @NotNull
            public final PlayerInfoUpdate getPlayerInfoUpdate() {
                return this.playerInfoUpdate;
            }

            public final boolean component1() {
                return this.timeUpdate;
            }

            @NotNull
            public final PlayerInfoUpdate component2() {
                return this.playerInfoUpdate;
            }

            @NotNull
            public final GlobalPackets copy(boolean timeUpdate, @NotNull PlayerInfoUpdate playerInfoUpdate) {
                return new GlobalPackets(timeUpdate, playerInfoUpdate);
            }

            public static /* synthetic */ GlobalPackets copy$default(GlobalPackets globalPackets, boolean bl, PlayerInfoUpdate playerInfoUpdate, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = globalPackets.timeUpdate;
                }
                if ((n & 2) != 0) {
                    playerInfoUpdate = globalPackets.playerInfoUpdate;
                }
                return globalPackets.copy(bl, playerInfoUpdate);
            }

            @NotNull
            public String toString() {
                return "GlobalPackets(timeUpdate=" + this.timeUpdate + ", playerInfoUpdate=" + this.playerInfoUpdate + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.timeUpdate);
                result = result * 31 + this.playerInfoUpdate.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GlobalPackets)) {
                    return false;
                }
                GlobalPackets globalPackets = (GlobalPackets)other;
                if (this.timeUpdate != globalPackets.timeUpdate) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.playerInfoUpdate, (Object)globalPackets.playerInfoUpdate);
            }

            public GlobalPackets() {
                this(false, null, 3, null);
            }

            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$GlobalPackets$PlayerInfoUpdate;", "", "updateGameMode", "", "updateLatency", "<init>", "(ZZ)V", "getUpdateGameMode", "()Z", "getUpdateLatency", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "bukkit"})
            public static final class PlayerInfoUpdate {
                private final boolean updateGameMode;
                private final boolean updateLatency;

                public PlayerInfoUpdate(boolean updateGameMode, boolean updateLatency) {
                    this.updateGameMode = updateGameMode;
                    this.updateLatency = updateLatency;
                }

                public /* synthetic */ PlayerInfoUpdate(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                    if ((n & 1) != 0) {
                        bl = true;
                    }
                    if ((n & 2) != 0) {
                        bl2 = false;
                    }
                    this(bl, bl2);
                }

                public final boolean getUpdateGameMode() {
                    return this.updateGameMode;
                }

                public final boolean getUpdateLatency() {
                    return this.updateLatency;
                }

                public final boolean component1() {
                    return this.updateGameMode;
                }

                public final boolean component2() {
                    return this.updateLatency;
                }

                @NotNull
                public final PlayerInfoUpdate copy(boolean updateGameMode, boolean updateLatency) {
                    return new PlayerInfoUpdate(updateGameMode, updateLatency);
                }

                public static /* synthetic */ PlayerInfoUpdate copy$default(PlayerInfoUpdate playerInfoUpdate, boolean bl, boolean bl2, int n, Object object) {
                    if ((n & 1) != 0) {
                        bl = playerInfoUpdate.updateGameMode;
                    }
                    if ((n & 2) != 0) {
                        bl2 = playerInfoUpdate.updateLatency;
                    }
                    return playerInfoUpdate.copy(bl, bl2);
                }

                @NotNull
                public String toString() {
                    return "PlayerInfoUpdate(updateGameMode=" + this.updateGameMode + ", updateLatency=" + this.updateLatency + ")";
                }

                public int hashCode() {
                    int result = Boolean.hashCode(this.updateGameMode);
                    result = result * 31 + Boolean.hashCode(this.updateLatency);
                    return result;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof PlayerInfoUpdate)) {
                        return false;
                    }
                    PlayerInfoUpdate playerInfoUpdate = (PlayerInfoUpdate)other;
                    if (this.updateGameMode != playerInfoUpdate.updateGameMode) {
                        return false;
                    }
                    return this.updateLatency == playerInfoUpdate.updateLatency;
                }

                public PlayerInfoUpdate() {
                    this(false, false, 3, null);
                }
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010!\u001a\u00020\"H\u00d6\u0081\u0004J\n\u0010#\u001a\u00020$H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u001b\u0010\u0012\u001a\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$RangedPackets;", "", "particle", "", "soundEffect", "entitySoundEffect", "hurtAnimation", "damageEvent", "entityHeadLook", "<init>", "(DDDDDD)V", "getParticle", "()D", "getSoundEffect", "getEntitySoundEffect", "getHurtAnimation", "getDamageEvent", "getEntityHeadLook", "processed", "getProcessed", "()Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$FeatureConfig$RangedPackets;", "processed$delegate", "Lkotlin/Lazy;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "bukkit"})
        public static final class RangedPackets {
            private final double particle;
            private final double soundEffect;
            private final double entitySoundEffect;
            private final double hurtAnimation;
            private final double damageEvent;
            private final double entityHeadLook;
            @NotNull
            private final Lazy processed$delegate;

            public RangedPackets(double particle, double soundEffect, double entitySoundEffect, double hurtAnimation, double damageEvent, double entityHeadLook) {
                this.particle = particle;
                this.soundEffect = soundEffect;
                this.entitySoundEffect = entitySoundEffect;
                this.hurtAnimation = hurtAnimation;
                this.damageEvent = damageEvent;
                this.entityHeadLook = entityHeadLook;
                this.processed$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> RangedPackets.processed_delegate$lambda$0(this));
            }

            public /* synthetic */ RangedPackets(double d, double d2, double d3, double d4, double d5, double d6, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    d = 0.0;
                }
                if ((n & 2) != 0) {
                    d2 = 8.0;
                }
                if ((n & 4) != 0) {
                    d3 = 10.0;
                }
                if ((n & 8) != 0) {
                    d4 = 0.0;
                }
                if ((n & 0x10) != 0) {
                    d5 = 0.0;
                }
                if ((n & 0x20) != 0) {
                    d6 = 0.0;
                }
                this(d, d2, d3, d4, d5, d6);
            }

            public final double getParticle() {
                return this.particle;
            }

            public final double getSoundEffect() {
                return this.soundEffect;
            }

            public final double getEntitySoundEffect() {
                return this.entitySoundEffect;
            }

            public final double getHurtAnimation() {
                return this.hurtAnimation;
            }

            public final double getDamageEvent() {
                return this.damageEvent;
            }

            public final double getEntityHeadLook() {
                return this.entityHeadLook;
            }

            @NotNull
            public final RangedPackets getProcessed() {
                Lazy lazy = this.processed$delegate;
                return (RangedPackets)lazy.getValue();
            }

            public final double component1() {
                return this.particle;
            }

            public final double component2() {
                return this.soundEffect;
            }

            public final double component3() {
                return this.entitySoundEffect;
            }

            public final double component4() {
                return this.hurtAnimation;
            }

            public final double component5() {
                return this.damageEvent;
            }

            public final double component6() {
                return this.entityHeadLook;
            }

            @NotNull
            public final RangedPackets copy(double particle, double soundEffect, double entitySoundEffect, double hurtAnimation, double damageEvent, double entityHeadLook) {
                return new RangedPackets(particle, soundEffect, entitySoundEffect, hurtAnimation, damageEvent, entityHeadLook);
            }

            public static /* synthetic */ RangedPackets copy$default(RangedPackets rangedPackets, double d, double d2, double d3, double d4, double d5, double d6, int n, Object object) {
                if ((n & 1) != 0) {
                    d = rangedPackets.particle;
                }
                if ((n & 2) != 0) {
                    d2 = rangedPackets.soundEffect;
                }
                if ((n & 4) != 0) {
                    d3 = rangedPackets.entitySoundEffect;
                }
                if ((n & 8) != 0) {
                    d4 = rangedPackets.hurtAnimation;
                }
                if ((n & 0x10) != 0) {
                    d5 = rangedPackets.damageEvent;
                }
                if ((n & 0x20) != 0) {
                    d6 = rangedPackets.entityHeadLook;
                }
                return rangedPackets.copy(d, d2, d3, d4, d5, d6);
            }

            @NotNull
            public String toString() {
                return "RangedPackets(particle=" + this.particle + ", soundEffect=" + this.soundEffect + ", entitySoundEffect=" + this.entitySoundEffect + ", hurtAnimation=" + this.hurtAnimation + ", damageEvent=" + this.damageEvent + ", entityHeadLook=" + this.entityHeadLook + ")";
            }

            public int hashCode() {
                int result = Double.hashCode(this.particle);
                result = result * 31 + Double.hashCode(this.soundEffect);
                result = result * 31 + Double.hashCode(this.entitySoundEffect);
                result = result * 31 + Double.hashCode(this.hurtAnimation);
                result = result * 31 + Double.hashCode(this.damageEvent);
                result = result * 31 + Double.hashCode(this.entityHeadLook);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof RangedPackets)) {
                    return false;
                }
                RangedPackets rangedPackets = (RangedPackets)other;
                if (Double.compare(this.particle, rangedPackets.particle) != 0) {
                    return false;
                }
                if (Double.compare(this.soundEffect, rangedPackets.soundEffect) != 0) {
                    return false;
                }
                if (Double.compare(this.entitySoundEffect, rangedPackets.entitySoundEffect) != 0) {
                    return false;
                }
                if (Double.compare(this.hurtAnimation, rangedPackets.hurtAnimation) != 0) {
                    return false;
                }
                if (Double.compare(this.damageEvent, rangedPackets.damageEvent) != 0) {
                    return false;
                }
                return Double.compare(this.entityHeadLook, rangedPackets.entityHeadLook) == 0;
            }

            private static final RangedPackets processed_delegate$lambda$0(RangedPackets this$0) {
                return this$0.copy(ExtensionsKt.square(this$0.particle), ExtensionsKt.square(this$0.soundEffect), ExtensionsKt.square(this$0.entitySoundEffect), ExtensionsKt.square(this$0.hurtAnimation), ExtensionsKt.square(this$0.damageEvent), ExtensionsKt.square(this$0.entityHeadLook));
            }

            public RangedPackets() {
                this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 63, null);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0019\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0082\bJ'\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0082\bJ\r\u0010\u000f\u001a\u00020\n*\u00020\u0010H\u0082\bJ\u0014\u0010\u0011\u001a\u00020\f*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0011\u001a\u00020\f*\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0018\u0010\u0019\u001a\u00020\u0014*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$PacketListeners;", "Lcom/github/retrooper/packetevents/event/PacketListenerAbstract;", "<init>", "()V", "onPacketSend", "", "e", "Lcom/github/retrooper/packetevents/event/PacketSendEvent;", "checkCancel", "bool", "", "maxDist", "", "scope", "Lkotlin/Function0;", "isInAfk", "Lorg/bukkit/entity/Player;", "distanceSqr", "Lcom/github/retrooper/packetevents/util/Vector3d;", "o", "Lorg/bukkit/Location;", "Lcom/github/retrooper/packetevents/util/Vector3i;", "entityIdDist", "entityId", "", "playerPos", "getPlayerPos", "(Lcom/github/retrooper/packetevents/event/PacketSendEvent;)Lorg/bukkit/Location;", "bukkit"})
    @SourceDebugExtension(value={"SMAP\nLimitedPacketEfficiency.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimitedPacketEfficiency.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$PacketListeners\n*L\n1#1,200:1\n126#1,9:201\n126#1,9:210\n126#1,9:219\n126#1,9:228\n126#1,9:237\n126#1,9:246\n122#1:255\n134#1:256\n123#1:257\n134#1:258\n134#1:259\n122#1:260\n134#1:261\n123#1:262\n122#1:263\n134#1:264\n123#1:265\n134#1:266\n134#1:267\n*S KotlinDebug\n*F\n+ 1 LimitedPacketEfficiency.kt\nio/github/rothes/esu/bukkit/module/networkthrottle/afkefficiency/LimitedPacketEfficiency$PacketListeners\n*L\n58#1:201,9\n64#1:210,9\n70#1:219,9\n77#1:228,9\n83#1:237,9\n89#1:246,9\n96#1:255\n96#1:256\n96#1:257\n99#1:258\n109#1:259\n112#1:260\n112#1:261\n112#1:262\n113#1:263\n113#1:264\n113#1:265\n122#1:266\n126#1:267\n*E\n"})
    private static final class PacketListeners
    extends PacketListenerAbstract {
        @NotNull
        public static final PacketListeners INSTANCE = new PacketListeners();

        private PacketListeners() {
            super(PacketListenerPriority.LOWEST);
        }

        /*
         * WARNING - void declaration
         */
        public void onPacketSend(@NotNull PacketSendEvent e) {
            block31: {
                PacketTypeCommon packetTypeCommon;
                block41: {
                    PacketSendEvent e$iv;
                    block42: {
                        block39: {
                            PacketSendEvent e$iv2;
                            block40: {
                                block37: {
                                    PacketSendEvent e$iv3;
                                    block38: {
                                        block35: {
                                            PacketSendEvent e$iv4;
                                            block36: {
                                                block33: {
                                                    PacketSendEvent e$iv52;
                                                    block34: {
                                                        block30: {
                                                            void e$iv52;
                                                            block32: {
                                                                void this_$iv;
                                                                if (e.isCancelled()) {
                                                                    return;
                                                                }
                                                                packetTypeCommon = e.getPacketType();
                                                                if (packetTypeCommon != PacketType.Play.Server.PARTICLE) break block30;
                                                                PacketListeners packetListeners = this;
                                                                PacketSendEvent packetSendEvent = e;
                                                                double maxDist$iv = ((FeatureConfig)INSTANCE.getConfig()).getRangedPackets().getProcessed().getParticle();
                                                                boolean $i$f$checkCancel = false;
                                                                if (maxDist$iv < 0.0) break block31;
                                                                void var8_39 = this_$iv;
                                                                Player $this$isInAfk$iv$iv = (Player)e$iv52.getPlayer();
                                                                boolean $i$f$isInAfk = false;
                                                                if (!limiting.contains($this$isInAfk$iv$iv)) break block31;
                                                                if (maxDist$iv == 0.0) break block32;
                                                                double d = maxDist$iv;
                                                                boolean bl = false;
                                                                WrapperPlayServerParticle wrapper = new WrapperPlayServerParticle(e);
                                                                double d2 = INSTANCE.distanceSqr(wrapper.getPosition(), INSTANCE.getPlayerPos(e));
                                                                if (!(d < d2)) break block31;
                                                            }
                                                            e$iv52.setCancelled(true);
                                                            break block31;
                                                        }
                                                        if (packetTypeCommon != PacketType.Play.Server.SOUND_EFFECT) break block33;
                                                        PacketListeners this_$iv = this;
                                                        e$iv52 = e;
                                                        double maxDist$iv = ((FeatureConfig)INSTANCE.getConfig()).getRangedPackets().getProcessed().getSoundEffect();
                                                        boolean $i$f$checkCancel = false;
                                                        if (maxDist$iv < 0.0) break block31;
                                                        PacketListeners this_$iv$iv = this_$iv;
                                                        Player $this$isInAfk$iv$iv = (Player)e$iv52.getPlayer();
                                                        boolean $i$f$isInAfk = false;
                                                        if (!limiting.contains($this$isInAfk$iv$iv)) break block31;
                                                        if (maxDist$iv == 0.0) break block34;
                                                        double d = maxDist$iv;
                                                        boolean bl = false;
                                                        WrapperPlayServerSoundEffect wrapper = new WrapperPlayServerSoundEffect(e);
                                                        double d3 = INSTANCE.distanceSqr(wrapper.getEffectPosition(), INSTANCE.getPlayerPos(e));
                                                        if (!(d < d3)) break block31;
                                                    }
                                                    e$iv52.setCancelled(true);
                                                    break block31;
                                                }
                                                if (packetTypeCommon != PacketType.Play.Server.ENTITY_SOUND_EFFECT) break block35;
                                                PacketListeners this_$iv = this;
                                                e$iv4 = e;
                                                double maxDist$iv = ((FeatureConfig)INSTANCE.getConfig()).getRangedPackets().getProcessed().getEntitySoundEffect();
                                                boolean $i$f$checkCancel = false;
                                                if (maxDist$iv < 0.0) break block31;
                                                PacketListeners this_$iv$iv = this_$iv;
                                                Player $this$isInAfk$iv$iv = (Player)e$iv4.getPlayer();
                                                boolean $i$f$isInAfk = false;
                                                if (!limiting.contains($this$isInAfk$iv$iv)) break block31;
                                                if (maxDist$iv == 0.0) break block36;
                                                double d = maxDist$iv;
                                                boolean bl = false;
                                                WrapperPlayServerEntitySoundEffect wrapper = new WrapperPlayServerEntitySoundEffect(e);
                                                double d4 = INSTANCE.entityIdDist(e, wrapper.getEntityId());
                                                if (!(d < d4)) break block31;
                                            }
                                            e$iv4.setCancelled(true);
                                            break block31;
                                        }
                                        if (packetTypeCommon == PacketType.Play.Server.NAMED_SOUND_EFFECT) break block31;
                                        if (packetTypeCommon != PacketType.Play.Server.HURT_ANIMATION) break block37;
                                        PacketListeners this_$iv = this;
                                        e$iv3 = e;
                                        double maxDist$iv = ((FeatureConfig)INSTANCE.getConfig()).getRangedPackets().getProcessed().getHurtAnimation();
                                        boolean $i$f$checkCancel = false;
                                        if (maxDist$iv < 0.0) break block31;
                                        PacketListeners this_$iv$iv = this_$iv;
                                        Player $this$isInAfk$iv$iv = (Player)e$iv3.getPlayer();
                                        boolean $i$f$isInAfk = false;
                                        if (!limiting.contains($this$isInAfk$iv$iv)) break block31;
                                        if (maxDist$iv == 0.0) break block38;
                                        double d = maxDist$iv;
                                        boolean bl = false;
                                        WrapperPlayServerHurtAnimation wrapper = new WrapperPlayServerHurtAnimation(e);
                                        double d5 = INSTANCE.entityIdDist(e, wrapper.getEntityId());
                                        if (!(d < d5)) break block31;
                                    }
                                    e$iv3.setCancelled(true);
                                    break block31;
                                }
                                if (packetTypeCommon != PacketType.Play.Server.DAMAGE_EVENT) break block39;
                                PacketListeners this_$iv = this;
                                e$iv2 = e;
                                double maxDist$iv = ((FeatureConfig)INSTANCE.getConfig()).getRangedPackets().getProcessed().getDamageEvent();
                                boolean $i$f$checkCancel = false;
                                if (maxDist$iv < 0.0) break block31;
                                PacketListeners this_$iv$iv = this_$iv;
                                Player $this$isInAfk$iv$iv = (Player)e$iv2.getPlayer();
                                boolean $i$f$isInAfk = false;
                                if (!limiting.contains($this$isInAfk$iv$iv)) break block31;
                                if (maxDist$iv == 0.0) break block40;
                                double d = maxDist$iv;
                                boolean bl = false;
                                WrapperPlayServerDamageEvent wrapper = new WrapperPlayServerDamageEvent(e);
                                double d6 = INSTANCE.entityIdDist(e, wrapper.getEntityId());
                                if (!(d < d6)) break block31;
                            }
                            e$iv2.setCancelled(true);
                            break block31;
                        }
                        if (packetTypeCommon != PacketType.Play.Server.ENTITY_HEAD_LOOK) break block41;
                        PacketListeners this_$iv = this;
                        e$iv = e;
                        double maxDist$iv = ((FeatureConfig)INSTANCE.getConfig()).getRangedPackets().getProcessed().getEntityHeadLook();
                        boolean $i$f$checkCancel2 = false;
                        if (maxDist$iv < 0.0) break block31;
                        PacketListeners this_$iv$iv = this_$iv;
                        Player $this$isInAfk$iv$iv = (Player)e$iv.getPlayer();
                        boolean $i$f$isInAfk2 = false;
                        if (!limiting.contains($this$isInAfk$iv$iv)) break block31;
                        if (maxDist$iv == 0.0) break block42;
                        double d = maxDist$iv;
                        boolean bl = false;
                        WrapperPlayServerEntityHeadLook wrapper = new WrapperPlayServerEntityHeadLook(e);
                        double d7 = INSTANCE.entityIdDist(e, wrapper.getEntityId());
                        if (!(d < d7)) break block31;
                    }
                    e$iv.setCancelled(true);
                    break block31;
                }
                if (packetTypeCommon != PacketType.Play.Server.SPAWN_EXPERIENCE_ORB) {
                    if (packetTypeCommon == PacketType.Play.Server.TIME_UPDATE) {
                        PacketListeners this_$iv = this;
                        PacketSendEvent e$iv = e;
                        boolean bool$iv = ((FeatureConfig)INSTANCE.getConfig()).getGlobalPackets().getTimeUpdate();
                        boolean $i$f$checkCancel = false;
                        if (!bool$iv) {
                            PacketListeners $i$f$checkCancel2 = this_$iv;
                            Player $this$isInAfk$iv$iv = (Player)e$iv.getPlayer();
                            boolean $i$f$isInAfk = false;
                            if (limiting.contains($this$isInAfk$iv$iv)) {
                                e$iv.setCancelled(true);
                            }
                        }
                    } else if (packetTypeCommon == PacketType.Play.Server.PLAYER_INFO_UPDATE) {
                        PacketListeners this_$iv = this;
                        Player $this$isInAfk$iv = (Player)e.getPlayer();
                        boolean $i$f$isInAfk = false;
                        if (!limiting.contains($this$isInAfk$iv)) {
                            return;
                        }
                        WrapperPlayServerPlayerInfoUpdate wrapper = new WrapperPlayServerPlayerInfoUpdate(e);
                        EnumSet actions = EnumSet.copyOf(wrapper.getActions());
                        if (!((FeatureConfig)INSTANCE.getConfig()).getGlobalPackets().getPlayerInfoUpdate().getUpdateLatency()) {
                            actions.remove(WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_LATENCY);
                        }
                        if (!((FeatureConfig)INSTANCE.getConfig()).getGlobalPackets().getPlayerInfoUpdate().getUpdateGameMode()) {
                            actions.remove(WrapperPlayServerPlayerInfoUpdate.Action.UPDATE_GAME_MODE);
                        }
                        if (actions.isEmpty()) {
                            e.setCancelled(true);
                        }
                    } else if (packetTypeCommon == PacketType.Play.Server.PLAYER_INFO) {
                        PacketListeners wrapper = this;
                        Player $this$isInAfk$iv = (Player)e.getPlayer();
                        boolean $i$f$isInAfk = false;
                        if (!limiting.contains($this$isInAfk$iv)) {
                            return;
                        }
                        wrapper = new WrapperPlayServerPlayerInfo(e);
                        WrapperPlayServerPlayerInfo.Action action = wrapper.getAction();
                        switch (action == null ? -1 : WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
                            case 1: {
                                void e$iv;
                                void this_$iv;
                                PacketListeners $i$f$checkCancel = this;
                                PacketSendEvent this_$iv$iv = e;
                                boolean bool$iv = ((FeatureConfig)INSTANCE.getConfig()).getGlobalPackets().getPlayerInfoUpdate().getUpdateLatency();
                                boolean $i$f$checkCancel3 = false;
                                if (bool$iv) break;
                                void $i$f$isInAfk2 = this_$iv;
                                Player $this$isInAfk$iv$iv = (Player)e$iv.getPlayer();
                                boolean $i$f$isInAfk3 = false;
                                if (!limiting.contains($this$isInAfk$iv$iv)) break;
                                e$iv.setCancelled(true);
                                break;
                            }
                            case 2: {
                                PacketListeners this_$iv = this;
                                PacketSendEvent e$iv = e;
                                boolean bool$iv = ((FeatureConfig)INSTANCE.getConfig()).getGlobalPackets().getPlayerInfoUpdate().getUpdateGameMode();
                                boolean $i$f$checkCancel = false;
                                if (bool$iv) break;
                                PacketListeners this_$iv$iv = this_$iv;
                                Player $this$isInAfk$iv$iv = (Player)e$iv.getPlayer();
                                boolean $i$f$isInAfk4 = false;
                                if (!limiting.contains($this$isInAfk$iv$iv)) break;
                                e$iv.setCancelled(true);
                            }
                        }
                    }
                }
            }
        }

        private final void checkCancel(PacketSendEvent e, boolean bool) {
            boolean $i$f$checkCancel = false;
            if (!bool) {
                PacketListeners packetListeners = this;
                Player $this$isInAfk$iv = (Player)e.getPlayer();
                boolean $i$f$isInAfk = false;
                if (limiting.contains($this$isInAfk$iv)) {
                    e.setCancelled(true);
                }
            }
        }

        private final void checkCancel(PacketSendEvent e, double maxDist, Function0<Double> scope) {
            block5: {
                block4: {
                    boolean $i$f$checkCancel = false;
                    if (maxDist < 0.0) break block4;
                    PacketListeners packetListeners = this;
                    Player $this$isInAfk$iv = (Player)e.getPlayer();
                    boolean $i$f$isInAfk = false;
                    if (limiting.contains($this$isInAfk$iv)) break block5;
                }
                return;
            }
            if (maxDist == 0.0 || maxDist < ((Number)scope.invoke()).doubleValue()) {
                e.setCancelled(true);
            }
        }

        private final boolean isInAfk(Player $this$isInAfk) {
            boolean $i$f$isInAfk = false;
            return limiting.contains($this$isInAfk);
        }

        private final double distanceSqr(Vector3d $this$distanceSqr, Location o) {
            return ExtensionsKt.square($this$distanceSqr.x - o.getX()) + ExtensionsKt.square($this$distanceSqr.y - o.getY()) + ExtensionsKt.square($this$distanceSqr.z - o.getZ());
        }

        private final double distanceSqr(Vector3i $this$distanceSqr, Location o) {
            return ExtensionsKt.square((double)$this$distanceSqr.x - o.getX()) + ExtensionsKt.square((double)$this$distanceSqr.y - o.getY()) + ExtensionsKt.square((double)$this$distanceSqr.z - o.getZ());
        }

        private final double entityIdDist(PacketSendEvent e, int entityId) {
            Location loc = this.getPlayerPos(e);
            Entity entity = SpigotConversionUtil.getEntityById((World)loc.getWorld(), (int)entityId);
            Entity entity2 = entity;
            return entity2 != null && (entity2 = entity2.getLocation()) != null ? entity2.distanceSquared(loc) : Double.MAX_VALUE;
        }

        private final Location getPlayerPos(PacketSendEvent $this$playerPos) {
            return ((Player)$this$playerPos.getPlayer()).getLocation();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[WrapperPlayServerPlayerInfo.Action.values().length];
                try {
                    nArray[WrapperPlayServerPlayerInfo.Action.UPDATE_LATENCY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[WrapperPlayServerPlayerInfo.Action.UPDATE_GAME_MODE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

