/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.optimizations.antilag;

import io.github.rothes.esu.bukkit.util.extension.ListenersKt;
import io.github.rothes.esu.core.configuration.meta.Comment;
import io.github.rothes.esu.core.module.CommonFeature;
import io.github.rothes.esu.core.module.configuration.BaseFeatureConfiguration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\b\tB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016\u00a8\u0006\n"}, d2={"Lio/github/rothes/esu/bukkit/module/optimizations/antilag/WaterloggedFeature;", "Lio/github/rothes/esu/core/module/CommonFeature;", "Lio/github/rothes/esu/bukkit/module/optimizations/antilag/WaterloggedFeature$FeatureConfig;", "", "<init>", "()V", "onEnable", "onDisable", "Listeners", "FeatureConfig", "bukkit"})
public final class WaterloggedFeature
extends CommonFeature<FeatureConfig, Unit> {
    @NotNull
    public static final WaterloggedFeature INSTANCE = new WaterloggedFeature();

    private WaterloggedFeature() {
    }

    @Override
    public void onEnable() {
        ListenersKt.register$default(Listeners.INSTANCE, null, 1, null);
    }

    @Override
    public void onDisable() {
        ListenersKt.unregister(Listeners.INSTANCE);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/github/rothes/esu/bukkit/module/optimizations/antilag/WaterloggedFeature$FeatureConfig;", "Lio/github/rothes/esu/core/module/configuration/BaseFeatureConfiguration;", "disableWaterSpread", "", "disableWaterloggedBlockPush", "<init>", "(ZZ)V", "getDisableWaterSpread", "()Z", "getDisableWaterloggedBlockPush", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "bukkit"})
    public static final class FeatureConfig
    extends BaseFeatureConfiguration {
        @Comment(value="Enable this will disable water spread from waterlogged blocks.")
        private final boolean disableWaterSpread;
        @Comment(value="\n                If enabled, waterlogged blocks cannot be pushed by pistons.\n                This can block any ocean maker flying machine.\n            ")
        private final boolean disableWaterloggedBlockPush;

        public FeatureConfig(boolean disableWaterSpread, boolean disableWaterloggedBlockPush) {
            super(false, 1, null);
            this.disableWaterSpread = disableWaterSpread;
            this.disableWaterloggedBlockPush = disableWaterloggedBlockPush;
        }

        public /* synthetic */ FeatureConfig(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getDisableWaterSpread() {
            return this.disableWaterSpread;
        }

        public final boolean getDisableWaterloggedBlockPush() {
            return this.disableWaterloggedBlockPush;
        }

        public final boolean component1() {
            return this.disableWaterSpread;
        }

        public final boolean component2() {
            return this.disableWaterloggedBlockPush;
        }

        @NotNull
        public final FeatureConfig copy(boolean disableWaterSpread, boolean disableWaterloggedBlockPush) {
            return new FeatureConfig(disableWaterSpread, disableWaterloggedBlockPush);
        }

        public static /* synthetic */ FeatureConfig copy$default(FeatureConfig featureConfig, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = featureConfig.disableWaterSpread;
            }
            if ((n & 2) != 0) {
                bl2 = featureConfig.disableWaterloggedBlockPush;
            }
            return featureConfig.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "FeatureConfig(disableWaterSpread=" + this.disableWaterSpread + ", disableWaterloggedBlockPush=" + this.disableWaterloggedBlockPush + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.disableWaterSpread);
            result = result * 31 + Boolean.hashCode(this.disableWaterloggedBlockPush);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FeatureConfig)) {
                return false;
            }
            FeatureConfig featureConfig = (FeatureConfig)other;
            if (this.disableWaterSpread != featureConfig.disableWaterSpread) {
                return false;
            }
            return this.disableWaterloggedBlockPush == featureConfig.disableWaterloggedBlockPush;
        }

        public FeatureConfig() {
            this(false, false, 3, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\nH\u0007J\u001e\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lio/github/rothes/esu/bukkit/module/optimizations/antilag/WaterloggedFeature$Listeners;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onLiquidSpread", "", "e", "Lorg/bukkit/event/block/BlockFromToEvent;", "onPistonPushWaterlogged", "Lorg/bukkit/event/block/BlockPistonExtendEvent;", "Lorg/bukkit/event/block/BlockPistonRetractEvent;", "handleWaterloggedPush", "blocks", "", "Lorg/bukkit/block/Block;", "Lorg/bukkit/event/block/BlockPistonEvent;", "bukkit"})
    @SourceDebugExtension(value={"SMAP\nWaterloggedFeature.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaterloggedFeature.kt\nio/github/rothes/esu/bukkit/module/optimizations/antilag/WaterloggedFeature$Listeners\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1807#2,3:67\n*S KotlinDebug\n*F\n+ 1 WaterloggedFeature.kt\nio/github/rothes/esu/bukkit/module/optimizations/antilag/WaterloggedFeature$Listeners\n*L\n48#1:67,3\n*E\n"})
    private static final class Listeners
    implements Listener {
        @NotNull
        public static final Listeners INSTANCE = new Listeners();

        private Listeners() {
        }

        @EventHandler
        public final void onLiquidSpread(@NotNull BlockFromToEvent e) {
            if (e.getBlock().getBlockData() instanceof Waterlogged && ((FeatureConfig)INSTANCE.getConfig()).getDisableWaterSpread()) {
                e.setCancelled(true);
            }
        }

        @EventHandler
        public final void onPistonPushWaterlogged(@NotNull BlockPistonExtendEvent e) {
            this.handleWaterloggedPush(e.getBlocks(), (BlockPistonEvent)e);
        }

        @EventHandler
        public final void onPistonPushWaterlogged(@NotNull BlockPistonRetractEvent e) {
            this.handleWaterloggedPush(e.getBlocks(), (BlockPistonEvent)e);
        }

        private final void handleWaterloggedPush(List<Block> blocks, BlockPistonEvent e) {
            FeatureConfig config = (FeatureConfig)INSTANCE.getConfig();
            if (config.getDisableWaterloggedBlockPush()) {
                boolean bl;
                block5: {
                    Iterable $this$any$iv = blocks;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Block it = (Block)element$iv;
                            boolean bl2 = false;
                            BlockData blockData = it.getBlockData();
                            Waterlogged waterlogged = blockData instanceof Waterlogged ? (Waterlogged)blockData : null;
                            boolean bl3 = waterlogged != null ? waterlogged.isWaterlogged() : false;
                            if (!bl3) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    e.setCancelled(true);
                    return;
                }
            }
        }
    }
}

