/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.util.collect;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;

public class FastIteLinkedQueue<E>
implements Queue<E> {
    int size = 0;
    Node<E> head;
    Node<E> tail;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size != 0;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new FastIterator();
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean contains(Object o) {
        for (E e : this) {
            if (!e.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        int i = 0;
        for (E e : this) {
            result[i++] = e;
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(o)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        for (E e : c) {
            this.offer(e);
        }
        return true;
    }

    @Override
    public void clear() {
        Node<E> node = this.head;
        while (node != null) {
            Node next = node.next;
            node.item = null;
            node.next = null;
            node.prev = null;
            node = next;
        }
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Collection)) {
            return false;
        }
        Iterator<E> i1 = this.iterator();
        Iterator i2 = ((Collection)o).iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object o2;
            E o1 = i1.next();
            if (Objects.equals(o1, o2 = i2.next())) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    @Override
    public boolean offer(E e) {
        Node<E> last = this.tail;
        Node<E> newNode = new Node<E>(e, last, null);
        this.tail = newNode;
        if (last == null) {
            this.head = newNode;
        } else {
            last.next = newNode;
        }
        ++this.size;
        return true;
    }

    @Override
    public E remove() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.poll();
    }

    @Override
    public E poll() {
        if (this.head == null) {
            return null;
        }
        Node<E> node = this.head;
        Node next = this.head.next;
        --this.size;
        this.head = next;
        node.next = null;
        if (next == null) {
            this.tail = null;
        } else {
            next.prev = null;
        }
        return node.item;
    }

    @Override
    public E element() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.peek();
    }

    @Override
    public E peek() {
        return this.head != null ? (E)this.head.item : null;
    }

    void onRemove(Node<E> node) {
        Node next = node.next;
        Node prev = node.prev;
        if (prev == null) {
            this.head = next;
        } else {
            prev.next = next;
            node.prev = null;
        }
        if (next == null) {
            this.tail = prev;
        } else {
            next.prev = prev;
            node.next = null;
        }
        node.item = null;
        --this.size;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    class FastIterator
    implements Iterator<E> {
        int remains;
        Node<E> last;
        Node<E> next;

        FastIterator() {
            this.remains = FastIteLinkedQueue.this.size;
            this.last = null;
            this.next = FastIteLinkedQueue.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.remains != 0;
        }

        @Override
        public E next() {
            Node node = this.next;
            this.next = node.next;
            --this.remains;
            this.last = node;
            return node.item;
        }

        @Override
        public void remove() {
            Node node = this.last;
            Node prev = node.prev;
            Node next = this.next;
            if (prev != null) {
                prev.next = next;
            }
            if (next != null) {
                next.prev = prev;
            }
            FastIteLinkedQueue.this.onRemove(node);
        }
    }

    static class Node<E> {
        E item;
        Node<E> prev;
        Node<E> next;

        Node(E element, Node<E> prev, Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }
}

