/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.configuration.serializer;

import io.github.rothes.esu.core.EsuCore;
import io.github.rothes.esu.core.configuration.meta.NoDeserializeNull;
import io.github.rothes.esu.lib.configurate.BasicConfigurationNode;
import io.github.rothes.esu.lib.configurate.ConfigurationNode;
import io.github.rothes.esu.lib.configurate.ConfigurationOptions;
import io.github.rothes.esu.lib.configurate.NodePath;
import io.github.rothes.esu.lib.configurate.serialize.SerializationException;
import io.github.rothes.esu.lib.configurate.serialize.TypeSerializer;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001:\u0003()*B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J2\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u00100\u000e\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0002J2\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u00100\u0015\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0002JH\u0010\u0016\u001a:\u0012\u0016\b\u0001\u0012\u0012\u0012\u0002\b\u0003 \u0017*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u0011 \u0017*\u001c\u0012\u0016\b\u0001\u0012\u0012\u0012\u0002\b\u0003 \u0017*\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u0011\u0018\u00010\u00130\u00132\u0006\u0010\t\u001a\u00020\nH\u0002J6\u0010\u0007\u001a\u0004\u0018\u00010\u00102\u0006\u0010\t\u001a\u00020\n2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J*\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\n2\u0010\u0010\u001e\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J>\u0010\u001c\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00012\b\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\fH\u0002J$\u0010#\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lio/github/rothes/esu/core/configuration/serializer/MapSerializer;", "Lio/github/rothes/esu/lib/configurate/serialize/TypeSerializer;", "", "<init>", "()V", "DEFAULTED_KEY", "", "deserialize", "", "type", "Ljava/lang/reflect/Type;", "node", "Lio/github/rothes/esu/lib/configurate/ConfigurationNode;", "createDefaultedEnumMap", "Lio/github/rothes/esu/core/configuration/serializer/MapSerializer$DefaultedEnumMap;", "T", "", "", "clazz", "Ljava/lang/Class;", "createEnumMap", "Ljava/util/EnumMap;", "asEnumClass", "kotlin.jvm.PlatformType", "serializer", "mapPart", "path", "Lio/github/rothes/esu/lib/configurate/NodePath;", "serialize", "", "obj", "", "cleanSameValueChildrenNodes", "toClean", "compare", "emptyValue", "specificType", "Ljava/lang/reflect/AnnotatedType;", "options", "Lio/github/rothes/esu/lib/configurate/ConfigurationOptions;", "Defaulted", "DefaultedLinkedHashMap", "DefaultedEnumMap", "core"})
public final class MapSerializer
implements TypeSerializer<Map<?, ?>> {
    @NotNull
    public static final MapSerializer INSTANCE = new MapSerializer();
    @NotNull
    private static final String DEFAULTED_KEY = "_default";

    private MapSerializer() {
    }

    @Override
    @NotNull
    public Map<?, ?> deserialize(@NotNull Type type, @NotNull ConfigurationNode node) {
        Map map;
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException(type, "Raw types are not supported for collections");
        }
        if (((ParameterizedType)type).getActualTypeArguments().length != 2) {
            throw new SerializationException(type, "Map expected two type arguments!");
        }
        Type key = ((ParameterizedType)type).getActualTypeArguments()[0];
        Type value = ((ParameterizedType)type).getActualTypeArguments()[1];
        TypeSerializer<?> typeSerializer = node.options().serializers().get(key);
        if (typeSerializer == null) {
            throw new SerializationException(type, "No type serializer available for key type " + key);
        }
        TypeSerializer<?> keySerializer = typeSerializer;
        TypeSerializer<?> typeSerializer2 = node.options().serializers().get(value);
        if (typeSerializer2 == null) {
            throw new SerializationException(type, "No type serializer available for value type " + value);
        }
        TypeSerializer<?> valueSerializer = typeSerializer2;
        Class<?> clazz = GenericTypeReflector.erase(type);
        AbstractMap abstractMap = Intrinsics.areEqual(clazz, DefaultedEnumMap.class) ? this.createDefaultedEnumMap(this.asEnumClass(key)) : (Intrinsics.areEqual(clazz, DefaultedLinkedHashMap.class) ? new DefaultedLinkedHashMap(null) : (Intrinsics.areEqual(clazz, EnumMap.class) ? this.createEnumMap(this.asEnumClass(key)) : new LinkedHashMap()));
        Intrinsics.checkNotNull(abstractMap, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.Any, kotlin.Any>");
        Map $this$deserialize_u24lambda_u240 = map = TypeIntrinsics.asMutableMap(abstractMap);
        boolean bl = false;
        if (node.isMap()) {
            BasicConfigurationNode keyNode = BasicConfigurationNode.root(node.options());
            Object[] objectArray = new Object[]{DEFAULTED_KEY};
            ConfigurationNode defNode = node.node(objectArray);
            if ($this$deserialize_u24lambda_u240 instanceof Defaulted) {
                ((Defaulted)((Object)$this$deserialize_u24lambda_u240)).setDefault(INSTANCE.deserialize(value, valueSerializer, "default", defNode, defNode.path()));
            }
            for (Map.Entry entry : node.childrenMap().entrySet()) {
                Object deserializedValue;
                Object deserializedKey;
                Object k = entry.getKey();
                ConfigurationNode v = (ConfigurationNode)entry.getValue();
                if ($this$deserialize_u24lambda_u240 instanceof Defaulted) {
                    if (k instanceof String && Intrinsics.areEqual(k, (Object)DEFAULTED_KEY)) continue;
                    v.mergeFrom(defNode);
                }
                if (INSTANCE.deserialize(key, keySerializer, "key", keyNode.set(k), node.path()) == null) continue;
                ConfigurationNode configurationNode = v;
                Intrinsics.checkNotNull((Object)configurationNode);
                if (INSTANCE.deserialize(value, valueSerializer, "value", v, configurationNode.path()) == null) continue;
                $this$deserialize_u24lambda_u240.put(deserializedKey, deserializedValue);
            }
        }
        return map;
    }

    private final <T extends Enum<T>> DefaultedEnumMap<T, Object> createDefaultedEnumMap(Class<T> clazz) {
        return new DefaultedEnumMap<T, Object>(clazz, null);
    }

    private final <T extends Enum<T>> EnumMap<T, Object> createEnumMap(Class<T> clazz) {
        return new EnumMap(clazz);
    }

    private final Class<? extends Enum<?>> asEnumClass(Type type) {
        return GenericTypeReflector.erase(type).asSubclass(Enum.class);
    }

    private final Object deserialize(Type type, TypeSerializer<?> serializer, String mapPart, ConfigurationNode node, NodePath path) {
        try {
            return serializer.deserialize(type, node);
        }
        catch (SerializationException ex) {
            ex.initPath(() -> MapSerializer.deserialize$lambda$1(node));
            EsuCore.Companion.getInstance().err("Could not deserialize " + mapPart + " " + node.raw() + " into " + type + " at " + path + ": " + ex.rawMessage());
            return null;
        }
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Map<?, ?> obj, @NotNull ConfigurationNode node) {
        if (!(type instanceof ParameterizedType)) {
            throw new SerializationException(type, "Raw types are not supported for collections");
        }
        if (((ParameterizedType)type).getActualTypeArguments().length != 2) {
            throw new SerializationException(type, "Map expected two type arguments!");
        }
        Type key = ((ParameterizedType)type).getActualTypeArguments()[0];
        Type value = ((ParameterizedType)type).getActualTypeArguments()[1];
        TypeSerializer<?> typeSerializer = node.options().serializers().get(key);
        if (typeSerializer == null) {
            throw new SerializationException(type, "No type serializer available for key type " + key);
        }
        TypeSerializer<?> keySerializer = typeSerializer;
        TypeSerializer<?> typeSerializer2 = node.options().serializers().get(value);
        if (typeSerializer2 == null) {
            throw new SerializationException(type, "No type serializer available for value type " + value);
        }
        TypeSerializer<?> valueSerializer = typeSerializer2;
        if (!(obj instanceof Defaulted) && (obj == null || obj.isEmpty())) {
            node.set(MapsKt.emptyMap());
        } else {
            if (node.empty()) {
                node.raw(MapsKt.emptyMap());
            }
            Object[] objectArray = new Object[]{DEFAULTED_KEY};
            ConfigurationNode defNode = node.node(objectArray);
            if (obj instanceof Defaulted) {
                this.serialize(value, valueSerializer, ((Defaulted)((Object)obj)).getDefault(), "default", defNode, defNode.path());
            }
            BasicConfigurationNode keyNode = BasicConfigurationNode.root(node.options());
            for (Map.Entry<?, ?> entry : obj.entrySet()) {
                Object key1 = entry.getKey();
                Object value1 = entry.getValue();
                if (!this.serialize(key, keySerializer, key1, "key", keyNode, node.path())) continue;
                Object keyObj = Objects.requireNonNull(keyNode.raw(), "Key must not be null!");
                Object[] objectArray2 = new Object[]{keyObj};
                ConfigurationNode child = node.node(objectArray2);
                this.serialize(value, valueSerializer, value1, "value", child, child.path());
                if (!(obj instanceof Defaulted)) continue;
                this.cleanSameValueChildrenNodes(child, defNode);
            }
        }
    }

    private final boolean serialize(Type type, TypeSerializer<?> serializer, Object obj, String mapPart, ConfigurationNode node, NodePath path) {
        try {
            Intrinsics.checkNotNull(serializer, (String)"null cannot be cast to non-null type io.github.rothes.esu.lib.configurate.serialize.TypeSerializer<kotlin.Any>");
            serializer.serialize(type, obj, node);
            return true;
        }
        catch (SerializationException ex) {
            ex.initPath(() -> MapSerializer.serialize$lambda$0(node));
            EsuCore.Companion.getInstance().err("Could not serialize " + mapPart + " " + obj + " from " + type + " at " + path + ": " + ex.rawMessage());
            return false;
        }
    }

    private final void cleanSameValueChildrenNodes(ConfigurationNode toClean, ConfigurationNode compare) {
        Map<Object, ? extends ConfigurationNode> childrenMap = compare.childrenMap();
        if (childrenMap.isEmpty()) {
            if (Intrinsics.areEqual((Object)toClean.raw(), (Object)compare.raw())) {
                toClean.raw(null);
            }
        } else {
            for (Map.Entry<Object, ? extends ConfigurationNode> entry : compare.childrenMap().entrySet()) {
                Object key = entry.getKey();
                ConfigurationNode node = entry.getValue();
                Object[] objectArray = new Object[]{key};
                ConfigurationNode n = toClean.node(objectArray);
                this.cleanSameValueChildrenNodes(n, node);
                if (!n.empty()) continue;
                toClean.removeChild(key);
            }
        }
    }

    @Override
    @Nullable
    public Map<?, ?> emptyValue(@NotNull AnnotatedType specificType, @Nullable ConfigurationOptions options) {
        if (specificType.isAnnotationPresent(NoDeserializeNull.class)) {
            return null;
        }
        return new LinkedHashMap();
    }

    private static final NodePath deserialize$lambda$1(ConfigurationNode $node) {
        return $node.path();
    }

    private static final NodePath serialize$lambda$0(ConfigurationNode $node) {
        return $node.path();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00018\u0000X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lio/github/rothes/esu/core/configuration/serializer/MapSerializer$Defaulted;", "V", "", "default", "getDefault", "()Ljava/lang/Object;", "setDefault", "(Ljava/lang/Object;)V", "core"})
    public static interface Defaulted<V> {
        @Nullable
        public V getDefault();

        public void setDefault(@Nullable V var1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0004\b\u0001\u0010\u00032\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00042\b\u0012\u0004\u0012\u0002H\u00030\u0005B\u001f\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0004\b\t\u0010\nJ\u0019\u0010\u0010\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012R\u001e\u0010\b\u001a\u0004\u0018\u00018\u0001X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lio/github/rothes/esu/core/configuration/serializer/MapSerializer$DefaultedEnumMap;", "K", "", "V", "Ljava/util/EnumMap;", "Lio/github/rothes/esu/core/configuration/serializer/MapSerializer$Defaulted;", "keyType", "Ljava/lang/Class;", "default", "<init>", "(Ljava/lang/Class;Ljava/lang/Object;)V", "getDefault", "()Ljava/lang/Object;", "setDefault", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "get", "key", "(Ljava/lang/Enum;)Ljava/lang/Object;", "getOrDefault", "core"})
    public static final class DefaultedEnumMap<K extends Enum<K>, V>
    extends EnumMap<K, V>
    implements Defaulted<V> {
        @Nullable
        private V default;

        public DefaultedEnumMap(@NotNull Class<K> keyType, @Nullable V v) {
            super(keyType);
            this.default = v;
        }

        @Override
        @Nullable
        public V getDefault() {
            return this.default;
        }

        @Override
        public void setDefault(@Nullable V v) {
            this.default = v;
        }

        @Override
        @Nullable
        public V get(@NotNull K key) {
            return this.getOrDefault(key);
        }

        @Nullable
        public final V getOrDefault(@NotNull K key) {
            Object v = super.get(key);
            if (v == null) {
                v = this.getDefault();
            }
            return v;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004B\u0011\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\r\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0015\u0010\u000f\u001a\u0004\u0018\u00018\u00012\u0006\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eR\u001e\u0010\u0005\u001a\u0004\u0018\u00018\u0001X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lio/github/rothes/esu/core/configuration/serializer/MapSerializer$DefaultedLinkedHashMap;", "K", "V", "Ljava/util/LinkedHashMap;", "Lio/github/rothes/esu/core/configuration/serializer/MapSerializer$Defaulted;", "default", "<init>", "(Ljava/lang/Object;)V", "getDefault", "()Ljava/lang/Object;", "setDefault", "Ljava/lang/Object;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getOrDefault", "core"})
    public static final class DefaultedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V>
    implements Defaulted<V> {
        @Nullable
        private V default;

        public DefaultedLinkedHashMap(@Nullable V v) {
            this.default = v;
        }

        @Override
        @Nullable
        public V getDefault() {
            return this.default;
        }

        @Override
        public void setDefault(@Nullable V v) {
            this.default = v;
        }

        @Override
        @Nullable
        public V get(Object key) {
            return this.getOrDefault(key);
        }

        @Nullable
        public final V getOrDefault(K key) {
            Object v = super.get(key);
            if (v == null) {
                v = this.getDefault();
            }
            return v;
        }
    }
}

