/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.module;

import io.github.rothes.esu.core.EsuCore;
import io.github.rothes.esu.core.module.Module;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\nJ\u001b\u0010\u000b\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006H\u0086\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007J\u0016\u0010\u0010\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0006J\u0016\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007J\u0016\u0010\u0014\u001a\u00020\u00132\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0018\u0010\u0016\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0002R:\u0010\u0004\u001a.\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u0005j\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/github/rothes/esu/core/module/ModuleManager;", "", "<init>", "()V", "modules", "Ljava/util/LinkedHashMap;", "", "Lio/github/rothes/esu/core/module/Module;", "Lkotlin/collections/LinkedHashMap;", "registeredModules", "", "get", "moduleName", "addModule", "", "module", "removeModule", "name", "forceEnableModule", "", "forceDisableModule", "reloadModules", "reloadModule", "core"})
public final class ModuleManager {
    @NotNull
    public static final ModuleManager INSTANCE = new ModuleManager();
    @NotNull
    private static final LinkedHashMap<String, Module<?, ?>> modules = new LinkedHashMap();

    private ModuleManager() {
    }

    @NotNull
    public final List<Module<?, ?>> registeredModules() {
        return CollectionsKt.toList((Iterable)modules.values());
    }

    @Nullable
    public final Module<?, ?> get(@NotNull String moduleName) {
        return modules.get(moduleName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addModule(@NotNull Module<?, ?> module) {
        LinkedHashMap<String, Module<?, ?>> linkedHashMap = modules;
        synchronized (linkedHashMap) {
            boolean bl = false;
            INSTANCE.removeModule(module.getName());
            Module<?, ?> module2 = modules.putIfAbsent(module.getName(), module);
        }
        this.reloadModule(module);
    }

    public final void removeModule(@NotNull Module<?, ?> module) {
        this.removeModule(module.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeModule(@NotNull String name) {
        block4: {
            Module removed;
            Module $i$a$-synchronized-ModuleManager$removeModule$removed$22;
            LinkedHashMap<String, Module<?, ?>> linkedHashMap = modules;
            synchronized (linkedHashMap) {
                boolean $i$a$-synchronized-ModuleManager$removeModule$removed$22 = false;
                $i$a$-synchronized-ModuleManager$removeModule$removed$22 = (Module)modules.remove(name);
            }
            Module module = removed = $i$a$-synchronized-ModuleManager$removeModule$removed$22;
            if (module == null) break block4;
            Module module2 = module;
            boolean bl = false;
            if (module2.getEnabled()) {
                INSTANCE.forceDisableModule(module2);
            }
            module2.onTerminate();
        }
    }

    public final boolean forceEnableModule(@NotNull Module<?, ?> module) {
        try {
            module.onEnable();
            module.setEnabled(true);
            return true;
        }
        catch (Throwable e) {
            EsuCore.Companion.getInstance().err("Failed to enable module " + module.getName(), e);
            return false;
        }
    }

    public final boolean forceDisableModule(@NotNull Module<?, ?> module) {
        try {
            module.setEnabled(false);
            module.onDisable();
            return true;
        }
        catch (Throwable e) {
            EsuCore.Companion.getInstance().err("Failed to disable module " + module.getName(), e);
            return false;
        }
    }

    public final void reloadModules() {
        for (Module<?, ?> module : modules.values()) {
            this.reloadModule(module);
        }
    }

    private final void reloadModule(Module<?, ?> module) {
        try {
            module.doReload();
        }
        catch (Throwable e) {
            EsuCore.Companion.getInstance().err("Failed to read config of module " + module.getName(), e);
        }
    }
}

