/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.util.offheap;

import io.github.rothes.esu.util.offheap.MemSeg;
import io.github.rothes.esu.util.offheap.MemoryAllocate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\nH\u0096\u0002J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0096\u0002J\u0019\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\nH\u0096\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\nH\u0016J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/github/rothes/esu/util/offheap/UnsafeMemSeg;", "Lio/github/rothes/esu/util/offheap/MemSeg;", "address", "", "size", "<init>", "(JJ)V", "getSize", "()J", "get", "", "offset", "", "set", "", "value", "or", "fill", "length", "initialize", "close", "Companion", "off-heap-memory"})
public final class UnsafeMemSeg
implements MemSeg {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long address;
    private final long size;
    @NotNull
    private static final Unsafe UNSAFE = MemoryAllocate.INSTANCE.getUNSAFE();

    public UnsafeMemSeg(long address, long size) {
        this.address = address;
        this.size = size;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public byte get(int offset) {
        return UNSAFE.getByte(this.address + (long)offset);
    }

    @Override
    public void set(int offset, byte value) {
        UNSAFE.putByte(this.address + (long)offset, value);
    }

    @Override
    public byte get(long offset) {
        return UNSAFE.getByte(this.address + offset);
    }

    @Override
    public void set(long offset, byte value) {
        UNSAFE.putByte(this.address + offset, value);
    }

    @Override
    public void or(long offset, byte value) {
        long addr = this.address + offset;
        UNSAFE.putByte(addr, (byte)(UNSAFE.getByte(addr) | value));
    }

    @Override
    public void fill(long offset, long length, byte value) {
        UNSAFE.setMemory(this.address + offset, length, value);
    }

    @Override
    public void initialize() {
        UNSAFE.setMemory(this.address, this.getSize(), (byte)0);
    }

    @Override
    public void close() {
        UNSAFE.freeMemory(this.address);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/rothes/esu/util/offheap/UnsafeMemSeg$Companion;", "", "<init>", "()V", "UNSAFE", "Lsun/misc/Unsafe;", "off-heap-memory"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

