/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.core.util.artifact.relocator;

import io.github.rothes.esu.core.EsuCore;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004\u0017\u0018\u0019\u001aBG\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nBa\b\u0016\u0012*\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f0\u000b\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\f\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\rJ\u0016\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator;", "", "relocates", "", "", "logger", "Lkotlin/Function1;", "", "err", "<init>", "(Ljava/util/Map;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "", "Lkotlin/Pair;", "([Lkotlin/Pair;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getLogger", "()Lkotlin/jvm/functions/Function1;", "getErr", "remapper", "Lio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator$ClassNameRemapper;", "relocate", "input", "Ljava/io/File;", "output", "Entry", "ClassEntry", "ClassNameRemapper", "RelocateVisitor", "core"})
@SourceDebugExtension(value={"SMAP\nPackageRelocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageRelocator.kt\nio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1#2:133\n1563#3:134\n1634#3,3:135\n1056#3:138\n*S KotlinDebug\n*F\n+ 1 PackageRelocator.kt\nio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator\n*L\n45#1:134\n45#1:135,3\n65#1:138\n*E\n"})
public final class PackageRelocator {
    @NotNull
    private final Function1<String, Unit> logger;
    @NotNull
    private final Function1<String, Unit> err;
    @NotNull
    private final ClassNameRemapper remapper;

    public PackageRelocator(@NotNull Map<String, String> relocates, @NotNull Function1<? super String, Unit> logger, @NotNull Function1<? super String, Unit> err) {
        this.logger = logger;
        this.err = err;
        this.remapper = new ClassNameRemapper(relocates);
    }

    public /* synthetic */ PackageRelocator(Map map, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = PackageRelocator::_init_$lambda$0;
        }
        if ((n & 4) != 0) {
            function12 = PackageRelocator::_init_$lambda$1;
        }
        this(map, (Function1<? super String, Unit>)function1, (Function1<? super String, Unit>)function12);
    }

    @NotNull
    public final Function1<String, Unit> getLogger() {
        return this.logger;
    }

    @NotNull
    public final Function1<String, Unit> getErr() {
        return this.err;
    }

    public PackageRelocator(@NotNull Pair<String, String>[] relocates, @NotNull Function1<? super String, Unit> logger, @NotNull Function1<? super String, Unit> err) {
        this(MapsKt.toMap(relocates), logger, err);
    }

    public /* synthetic */ PackageRelocator(Pair[] pairArray, Function1 function1, Function1 function12, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = PackageRelocator::_init_$lambda$2;
        }
        if ((n & 4) != 0) {
            function12 = PackageRelocator::_init_$lambda$3;
        }
        this(pairArray, (Function1<? super String, Unit>)function1, (Function1<? super String, Unit>)function12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void relocate(@NotNull File input, @NotNull File output) {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        Closeable closeable;
        Object e;
        List list;
        long start = System.currentTimeMillis();
        this.logger.invoke((Object)("Relocating " + input + " to " + output));
        List $this$relocate_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object object = new ZipFile(input);
        Object object2 = null;
        try {
            ZipFile file = (ZipFile)object;
            boolean bl2 = false;
            Iterator iterator = CollectionsKt.iterator(file.entries());
            while (iterator.hasNext()) {
                Object it;
                e = (ZipEntry)iterator.next();
                if (((ZipEntry)e).isDirectory()) continue;
                String name = ((ZipEntry)e).getName();
                closeable = file.getInputStream((ZipEntry)e);
                Throwable throwable = null;
                try {
                    it = (InputStream)closeable;
                    boolean bl3 = false;
                    it = ((InputStream)it).readAllBytes();
                }
                catch (Throwable bl3) {
                    throwable = bl3;
                    throw bl3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Object data = it;
                boolean bl4 = StringsKt.endsWith$default((String)name, (String)".class", (boolean)false, (int)2, null) ? $this$relocate_u24lambda_u240.add(new ClassEntry(name, ((ZipEntry)e).getTime(), (byte[])data)) : $this$relocate_u24lambda_u240.add(new Entry(name, ((ZipEntry)e).getTime(), (byte[])data));
            }
            file = Unit.INSTANCE;
        }
        catch (Throwable bl2) {
            object2 = bl2;
            throw bl2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        List entries = CollectionsKt.build((List)list);
        Iterable $this$map$iv = entries;
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Entry entry;
            void entry2;
            e = (Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            if (entry2 instanceof ClassEntry) {
                Object reader;
                try {
                    reader = new ClassReader(entry2.getData());
                    ClassWriter writer = new ClassWriter(0);
                    RelocateVisitor visitor = new RelocateVisitor(writer, this.remapper);
                    reader.accept((ClassVisitor)visitor, 0);
                    byte[] data = writer.toByteArray();
                    String newName = this.remapper.map(((ClassEntry)entry2).getClassName());
                    reader = new ClassEntry(newName + ".class", entry2.getTime(), data);
                }
                catch (Exception e2) {
                    this.err.invoke((Object)("Failed to relocate " + ((ClassEntry)entry2).getClassName() + ": " + e2));
                    reader = (ClassEntry)entry2;
                }
                entry = (Entry)reader;
            } else {
                entry = entry2;
            }
            collection.add(entry);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List mapped = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Entry it = (Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
        Set added = new LinkedHashSet();
        long time = System.currentTimeMillis();
        object2 = new FileOutputStream(output);
        int n = 8192;
        object2 = object2 instanceof BufferedOutputStream ? (BufferedOutputStream)object2 : new BufferedOutputStream((OutputStream)object2, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream bs = (BufferedOutputStream)object2;
            boolean bl6 = false;
            Closeable closeable2 = new ZipOutputStream(bs);
            Throwable throwable2 = null;
            try {
                ZipOutputStream zip = (ZipOutputStream)closeable2;
                boolean bl7 = false;
                for (Entry e3 : mapped) {
                    int dir = StringsKt.lastIndexOf$default((CharSequence)e3.getName(), (char)'/', (int)0, (boolean)false, (int)6, null);
                    if (dir > 0) {
                        PackageRelocator.relocate$lambda$3$0$putDirectory(added, time, zip, StringsKt.take((String)e3.getName(), (int)dir));
                    }
                    ZipEntry entry = new ZipEntry(e3.getName());
                    entry.setTime(e3.getTime());
                    zip.putNextEntry(entry);
                    zip.write(e3.getData());
                    zip.closeEntry();
                }
                closeable = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
        this.logger.invoke((Object)("Relocate done in " + (System.currentTimeMillis() - start) + "ms"));
    }

    private static final Unit _init_$lambda$0(String it) {
        EsuCore.Companion.getInstance().info("[Relocator] " + it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(String it) {
        EsuCore.Companion.getInstance().err("[Relocator] " + it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(String it) {
        EsuCore.Companion.getInstance().info("[Relocator] " + it);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(String it) {
        EsuCore.Companion.getInstance().err("[Relocator] " + it);
        return Unit.INSTANCE;
    }

    private static final void relocate$lambda$3$0$putDirectory(Set<String> added, long time, ZipOutputStream $zip, String path) {
        if (!added.add(path)) {
            return;
        }
        int dir = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (dir > 0) {
            PackageRelocator.relocate$lambda$3$0$putDirectory(added, time, $zip, StringsKt.take((String)path, (int)dir));
        }
        ZipEntry entry = new ZipEntry(path + "/");
        entry.setTime(time);
        $zip.putNextEntry(entry);
        $zip.closeEntry();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator$ClassEntry;", "Lio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator$Entry;", "name", "", "time", "", "data", "", "<init>", "(Ljava/lang/String;J[B)V", "className", "getClassName", "()Ljava/lang/String;", "core"})
    private static final class ClassEntry
    extends Entry {
        @NotNull
        private final String className;

        public ClassEntry(@NotNull String name, long time, @NotNull byte[] data) {
            super(name, time, data);
            this.className = StringsKt.dropLast((String)name, (int)6);
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator$ClassNameRemapper;", "Lorg/objectweb/asm/commons/Remapper;", "relocates", "", "", "<init>", "(Ljava/util/Map;)V", "map", "internalName", "core"})
    private static final class ClassNameRemapper
    extends Remapper {
        @NotNull
        private final Map<String, String> relocates;

        public ClassNameRemapper(@NotNull Map<String, String> relocates) {
            this.relocates = relocates;
        }

        @NotNull
        public String map(@NotNull String internalName) {
            Object mapped = internalName;
            for (Map.Entry<String, String> entry : this.relocates.entrySet()) {
                String from = entry.getKey();
                String to = entry.getValue();
                if (!StringsKt.startsWith$default((String)mapped, (String)from, (boolean)false, (int)2, null)) continue;
                String string = ((String)mapped).substring(from.length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                mapped = to + string;
            }
            return mapped;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\b\u0012\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator$Entry;", "", "name", "", "time", "", "data", "", "<init>", "(Ljava/lang/String;J[B)V", "getName", "()Ljava/lang/String;", "getTime", "()J", "getData", "()[B", "core"})
    private static class Entry {
        @NotNull
        private final String name;
        private final long time;
        @NotNull
        private final byte[] data;

        public Entry(@NotNull String name, long time, @NotNull byte[] data) {
            this.name = name;
            this.time = time;
            this.data = data;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getTime() {
            return this.time;
        }

        @NotNull
        public final byte[] getData() {
            return this.data;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator$RelocateVisitor;", "Lorg/objectweb/asm/commons/ClassRemapper;", "writer", "Lorg/objectweb/asm/ClassWriter;", "remapper", "Lio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator$ClassNameRemapper;", "<init>", "(Lorg/objectweb/asm/ClassWriter;Lio/github/rothes/esu/core/util/artifact/relocator/PackageRelocator$ClassNameRemapper;)V", "core"})
    private static final class RelocateVisitor
    extends ClassRemapper {
        public RelocateVisitor(@NotNull ClassWriter writer, @NotNull ClassNameRemapper remapper) {
            super((ClassVisitor)writer, (Remapper)remapper);
        }
    }
}

