/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.velocity.user;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import io.github.rothes.esu.core.colorscheme.ColorScheme;
import io.github.rothes.esu.core.colorscheme.ColorSchemes;
import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.MultiLocaleConfiguration;
import io.github.rothes.esu.core.storage.StorageManager;
import io.github.rothes.esu.core.util.AdventureConverter;
import io.github.rothes.esu.lib.net.kyori.adventure.text.minimessage.MiniMessage;
import io.github.rothes.esu.lib.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import io.github.rothes.esu.velocity.InternalsKt;
import io.github.rothes.esu.velocity.user.VelocityUser;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\tJT\u0010,\u001a\u00020-\"\b\b\u0000\u0010.*\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H.012\u0019\u00102\u001a\u0015\u0012\u0004\u0012\u0002H.\u0012\u0006\u0012\u0004\u0018\u00010\u001b03\u00a2\u0006\u0002\b42\u0012\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020706\"\u000207H\u0016\u00a2\u0006\u0002\u00108J\u0013\u00109\u001a\u00020*2\b\u0010:\u001a\u0004\u0018\u00010;H\u0096\u0002J\b\u0010<\u001a\u00020\u0017H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR*\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00058F@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\tR\u0011\u0010\b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u001c\u0010\"\u001a\u0004\u0018\u00010\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001d\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010\u001bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001d\"\u0004\b(\u0010%R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010+\u00a8\u0006="}, d2={"Lio/github/rothes/esu/velocity/user/PlayerUser;", "Lio/github/rothes/esu/velocity/user/VelocityUser;", "uuid", "Ljava/util/UUID;", "initPlayer", "Lcom/velocitypowered/api/proxy/Player;", "<init>", "(Ljava/util/UUID;Lcom/velocitypowered/api/proxy/Player;)V", "player", "(Lcom/velocitypowered/api/proxy/Player;)V", "getUuid", "()Ljava/util/UUID;", "value", "playerCache", "getPlayerCache", "()Lcom/velocitypowered/api/proxy/Player;", "setPlayerCache$velocity", "getPlayer", "commandSender", "Lcom/velocitypowered/api/command/CommandSource;", "getCommandSender", "()Lcom/velocitypowered/api/command/CommandSource;", "dbId", "", "getDbId", "()I", "name", "", "getName", "()Ljava/lang/String;", "nameUnsafe", "getNameUnsafe", "clientLocale", "getClientLocale", "languageUnsafe", "getLanguageUnsafe", "setLanguageUnsafe", "(Ljava/lang/String;)V", "colorSchemeUnsafe", "getColorSchemeUnsafe", "setColorSchemeUnsafe", "isOnline", "", "()Z", "kick", "", "T", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "locales", "Lio/github/rothes/esu/core/configuration/MultiLocaleConfiguration;", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "params", "", "Lio/github/rothes/esu/lib/net/kyori/adventure/text/minimessage/tag/resolver/TagResolver;", "(Lio/github/rothes/esu/core/configuration/MultiLocaleConfiguration;Lkotlin/jvm/functions/Function1;[Lio/github/rothes/esu/lib/net/kyori/adventure/text/minimessage/tag/resolver/TagResolver;)V", "equals", "other", "", "hashCode", "velocity"})
@SourceDebugExtension(value={"SMAP\nPlayerUser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerUser.kt\nio/github/rothes/esu/velocity/user/PlayerUser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class PlayerUser
extends VelocityUser {
    @NotNull
    private final UUID uuid;
    @Nullable
    private Player playerCache;
    private final int dbId;
    @Nullable
    private String languageUnsafe;
    @Nullable
    private String colorSchemeUnsafe;

    public PlayerUser(@NotNull UUID uuid, @Nullable Player initPlayer) {
        this.uuid = uuid;
        this.playerCache = initPlayer;
        StorageManager.UserData userData = StorageManager.INSTANCE.getUserData(this.getUuid());
        this.dbId = userData.getDbId();
        this.setLanguageUnsafe(userData.getLanguage());
        this.setColorSchemeUnsafe(userData.getColorScheme());
    }

    public /* synthetic */ PlayerUser(UUID uUID, Player player, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            player = null;
        }
        this(uUID, player);
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public PlayerUser(@NotNull Player player) {
        this(player.getUniqueId(), player);
    }

    @Nullable
    public final Player getPlayerCache() {
        Player cache = this.playerCache;
        if (cache != null && cache.isActive()) {
            return cache;
        }
        Player get = (Player)OptionalsKt.getOrNull((Optional)InternalsKt.getPlugin().getServer().getPlayer(this.getUuid()));
        if (get != null) {
            this.playerCache = get;
            return get;
        }
        Player player = cache;
        if (player == null) {
            throw new IllegalStateException(("Player " + this.getUuid() + " is not online and there's no cached instance!").toString());
        }
        return player;
    }

    public final void setPlayerCache$velocity(@Nullable Player player) {
        this.playerCache = player;
    }

    @NotNull
    public final Player getPlayer() {
        Player player = this.getPlayerCache();
        Intrinsics.checkNotNull((Object)player);
        return player;
    }

    @Override
    @NotNull
    public CommandSource getCommandSender() {
        return (CommandSource)this.getPlayer();
    }

    @Override
    public int getDbId() {
        return this.dbId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getNameUnsafe();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @Nullable
    public String getNameUnsafe() {
        Player player = this.getPlayerCache();
        return player != null ? player.getUsername() : null;
    }

    @Override
    @NotNull
    public String getClientLocale() {
        Locale $this$_get_clientLocale__u24lambda_u240 = this.getPlayer().getPlayerSettings().getLocale();
        boolean bl = false;
        String string = $this$_get_clientLocale__u24lambda_u240.getLanguage();
        String string2 = $this$_get_clientLocale__u24lambda_u240.getCountry().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string + "_" + string2;
    }

    @Override
    @Nullable
    public String getLanguageUnsafe() {
        return this.languageUnsafe;
    }

    @Override
    public void setLanguageUnsafe(@Nullable String string) {
        this.languageUnsafe = string;
    }

    @Override
    @Nullable
    public String getColorSchemeUnsafe() {
        return this.colorSchemeUnsafe;
    }

    @Override
    public void setColorSchemeUnsafe(@Nullable String string) {
        this.colorSchemeUnsafe = string;
    }

    @Override
    public boolean isOnline() {
        Player player = this.getPlayerCache();
        return player != null ? player.isActive() : false;
    }

    @Override
    public <T extends ConfigurationPart> void kick(@NotNull MultiLocaleConfiguration<T> locales, @NotNull Function1<? super T, String> block, TagResolver ... params) {
        Player player = this.getPlayer();
        MiniMessage miniMessage = MiniMessage.miniMessage();
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        spreadBuilder.addSpread((Object)params);
        Object r = ColorSchemes.INSTANCE.getSchemes().get(this.getColorScheme(), PlayerUser::kick$lambda$0);
        Intrinsics.checkNotNull(r);
        spreadBuilder.add(r);
        player.disconnect(AdventureConverter.INSTANCE.getServer(miniMessage.deserialize(this.localed(locales, block), (TagResolver[])spreadBuilder.toArray((Object[])new TagResolver[spreadBuilder.size()]))));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type io.github.rothes.esu.velocity.user.PlayerUser");
        PlayerUser cfr_ignored_0 = (PlayerUser)object2;
        if (this.getDbId() != ((PlayerUser)other).getDbId()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getUuid(), (Object)((PlayerUser)other).getUuid());
    }

    public int hashCode() {
        int result = this.getDbId();
        result = 31 * result + this.getUuid().hashCode();
        return result;
    }

    private static final TagResolver kick$lambda$0(ColorScheme $this$get) {
        return $this$get.getTagResolver();
    }
}

