/*
 * Decompiled with CFR 0.152.
 */
package io.github.rothes.esu.bukkit.module.essentialcommands;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.misc.AllocatingRateLimiter;
import ca.spottedleaf.moonrise.common.util.MoonriseConstants;
import ca.spottedleaf.moonrise.patches.chunk_system.player.RegionizedPlayerChunkLoader;
import io.github.rothes.esu.bukkit.module.essentialcommands.BaseCommand;
import io.github.rothes.esu.bukkit.module.essentialcommands.PlayerChunkTickets;
import io.github.rothes.esu.bukkit.util.ComponentBukkitUtils;
import io.github.rothes.esu.core.command.annotation.ShortPerm;
import io.github.rothes.esu.core.configuration.ConfigurationPart;
import io.github.rothes.esu.core.configuration.data.MessageData;
import io.github.rothes.esu.core.module.CommonFeature;
import io.github.rothes.esu.core.module.Feature;
import io.github.rothes.esu.core.module.configuration.FeatureToggle;
import io.github.rothes.esu.core.user.User;
import io.github.rothes.esu.core.util.ComponentUtils;
import io.github.rothes.esu.lib.adventure.text.minimessage.tag.resolver.TagResolver;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.incendo.cloud.annotations.Command;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lio/github/rothes/esu/bukkit/module/essentialcommands/PlayerChunkTickets;", "Lio/github/rothes/esu/bukkit/module/essentialcommands/BaseCommand;", "Lio/github/rothes/esu/core/module/configuration/FeatureToggle$DefaultTrue;", "Lio/github/rothes/esu/bukkit/module/essentialcommands/PlayerChunkTickets$Lang;", "<init>", "()V", "checkUnavailable", "Lio/github/rothes/esu/core/module/Feature$AvailableCheck;", "onEnable", "", "Lang", "bukkit"})
public final class PlayerChunkTickets
extends BaseCommand<FeatureToggle.DefaultTrue, Lang> {
    @NotNull
    public static final PlayerChunkTickets INSTANCE = new PlayerChunkTickets();

    private PlayerChunkTickets() {
    }

    @Override
    @Nullable
    public Feature.AvailableCheck checkUnavailable() {
        Feature.AvailableCheck availableCheck = super.checkUnavailable();
        if (availableCheck == null) {
            PlayerChunkTickets it = this;
            boolean bl = false;
            try {
                Class<RegionizedPlayerChunkLoader.PlayerChunkLoaderData> clazz = RegionizedPlayerChunkLoader.PlayerChunkLoaderData.class;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return Feature.AvailableCheck.Companion.fail((Function1<? super User, MessageData>)((Function1)PlayerChunkTickets::checkUnavailable$lambda$0$0));
            }
            availableCheck = null;
        }
        return availableCheck;
    }

    @Override
    public void onEnable() {
        CommonFeature.registerCommands$default(this, new Object(){
            private final Class<RegionizedPlayerChunkLoader.PlayerChunkLoaderData> clazz;
            private final Field gen;
            private final Field load;
            {
                Field it;
                Field field;
                this.clazz = RegionizedPlayerChunkLoader.PlayerChunkLoaderData.class;
                Field field2 = field = this.clazz.getDeclaredField("chunkGenerateTicketLimiter");
                onEnable.1 var4_3 = this;
                boolean bl = false;
                it.setAccessible(true);
                var4_3.gen = field;
                it = field = this.clazz.getDeclaredField("chunkLoadTicketLimiter");
                var4_3 = this;
                boolean bl2 = false;
                it.setAccessible(true);
                var4_3.load = field;
            }

            public final Class<RegionizedPlayerChunkLoader.PlayerChunkLoaderData> getClazz() {
                return this.clazz;
            }

            @Command(value="tickDistance <num>")
            @ShortPerm(value="tickDistance")
            public final void tickDistance(User sender, int num) {
                if (!(2 <= num ? num < 33 : false)) {
                    sender.miniMessage("<ec>tickDistance should be in range of [2, 32]", new TagResolver[0]);
                    return;
                }
                for (World world : Bukkit.getWorlds()) {
                    this.getChunkLoader(world).setTickDistance(num);
                    sender.message(world.getName() + " to " + world.getSimulationDistance());
                }
            }

            @Command(value="viewDistance <num>")
            @ShortPerm(value="viewDistance")
            public final void viewDistance(User sender, int num) {
                if (num + 1 < 2 && num != -1) {
                    sender.miniMessage("<ec>viewDistance should be >= 2", new TagResolver[0]);
                    return;
                }
                if (this.checkMax(sender, num)) {
                    for (World world : Bukkit.getWorlds()) {
                        this.getChunkLoader(world).setLoadDistance(num + 1);
                        sender.message(world.getName() + " to " + world.getViewDistance());
                    }
                }
            }

            @Command(value="sendDistance <num>")
            @ShortPerm(value="sendDistance")
            public final void sendDistance(User sender, int num) {
                if (num < 0 && num != -1) {
                    sender.miniMessage("<ec>sendDistance should be >= 0", new TagResolver[0]);
                    return;
                }
                if (this.checkMax(sender, num)) {
                    for (World world : Bukkit.getWorlds()) {
                        if (world.getViewDistance() < num) {
                            sender.miniMessage("<ec>ViewDistance of " + world.getName() + " is " + world.getViewDistance() + ", you need it higher or eq than " + num, new TagResolver[0]);
                        }
                        this.getChunkLoader(world).setSendDistance(num);
                        sender.message(world.getName() + " to " + world.getSendViewDistance());
                    }
                }
            }

            private final boolean checkMax(User user, int num) {
                if (MoonriseConstants.MAX_VIEW_DISTANCE < num) {
                    user.miniMessage("<ec>Current MAX_VIEW_DISTANCE is " + MoonriseConstants.MAX_VIEW_DISTANCE, new TagResolver[0]);
                    try {
                        String prop = PlatformHooks.get().getBrand() + ".MaxViewDistance";
                        user.miniMessage("<ec>Add `-D" + prop + "=" + num + "` behind java in your server start commandline to override it", new TagResolver[0]);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        user.miniMessage("<ec>Your server version doesn't allow to override it safely, need a upgrade.", new TagResolver[0]);
                    }
                    return false;
                }
                return true;
            }

            private final RegionizedPlayerChunkLoader getChunkLoader(World $this$chunkLoader) {
                Intrinsics.checkNotNull((Object)$this$chunkLoader, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.CraftWorld");
                return ((CraftWorld)$this$chunkLoader).getHandle().moonrise$getPlayerChunkLoader();
            }

            @Command(value="genRateTop")
            @ShortPerm(value="genRateTop")
            public final void genRateTop(User sender) {
                this.rate(sender, this.gen, GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkGenerateRate, (Function1<? super Lang, Lang.ChunkRateTop>)((Function1)onEnable.1::genRateTop$lambda$1));
            }

            @Command(value="loadRateTop")
            @ShortPerm(value="loadRateTop")
            public final void loadRateTop(User sender) {
                this.rate(sender, this.load, GlobalConfiguration.get().chunkLoadingBasic.playerMaxChunkLoadRate, (Function1<? super Lang, Lang.ChunkRateTop>)((Function1)onEnable.1::loadRateTop$lambda$3));
            }

            /*
             * WARNING - void declaration
             */
            private final void rate(User sender, Field field, double maxRate, Function1<? super Lang, Lang.ChunkRateTop> langScope) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterator<Map.Entry<K, V>> $this$associateByTo$iv$iv$iv;
                void $this$mapValuesTo$iv$iv;
                Map $this$mapValues$iv;
                RegionizedPlayerChunkLoader.PlayerChunkLoaderData playerChunkLoaderData;
                Iterator<T> player;
                Map map;
                Object object;
                void $this$associateWithTo$iv$iv;
                Object $this$associateWith$iv = Bukkit.getOnlinePlayers();
                boolean $i$f$associateWith = false;
                LinkedHashMap<K, V> result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                Iterable iterable = $this$associateWith$iv;
                Map destination$iv$iv = result$iv;
                boolean $i$f$associateWithTo22 = false;
                for (T element$iv$iv : $this$associateWithTo$iv$iv) {
                    Player player2 = (Player)element$iv$iv;
                    object = element$iv$iv;
                    map = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type org.bukkit.craftbukkit.entity.CraftPlayer");
                    playerChunkLoaderData = ((CraftPlayer)player).getHandle().moonrise$getChunkLoader();
                    map.put(object, playerChunkLoaderData);
                }
                $this$associateWith$iv = destination$iv$iv;
                boolean $i$f$mapValues = false;
                result$iv = $this$mapValues$iv;
                Map destination$iv$iv2 = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $i$f$associateWithTo22 = $this$mapValuesTo$iv$iv.entrySet();
                Map destination$iv$iv$iv = destination$iv$iv2;
                boolean $i$f$associateByTo = false;
                player = $this$associateByTo$iv$iv$iv.iterator();
                while (player.hasNext()) {
                    Double d;
                    void entry;
                    void it$iv$iv;
                    T element$iv$iv$iv = player.next();
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Map map2 = destination$iv$iv$iv;
                    boolean bl = false;
                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                    object = it$iv$iv.getKey();
                    map = map2;
                    boolean bl2 = false;
                    if ((RegionizedPlayerChunkLoader.PlayerChunkLoaderData)entry.getValue() == null) {
                        d = null;
                    } else {
                        RegionizedPlayerChunkLoader.PlayerChunkLoaderData loaderData;
                        Object object2 = field.get(loaderData);
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type ca.spottedleaf.moonrise.common.misc.AllocatingRateLimiter");
                        AllocatingRateLimiter limiter = (AllocatingRateLimiter)object2;
                        d = maxRate - (double)limiter.previewAllocation(System.nanoTime(), maxRate, (long)maxRate);
                    }
                    playerChunkLoaderData = d;
                    map.put(object, playerChunkLoaderData);
                }
                $this$mapValues$iv = destination$iv$iv$iv;
                boolean $i$f$filter = false;
                $this$mapValuesTo$iv$iv = $this$filter$iv;
                destination$iv$iv2 = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                $this$associateByTo$iv$iv$iv = $this$filterTo$iv$iv.entrySet().iterator();
                while ($this$associateByTo$iv$iv$iv.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> entry = element$iv$iv = $this$associateByTo$iv$iv$iv.next();
                    boolean bl = false;
                    Double value = (Double)entry.getValue();
                    if (!(value != null && value > 0.0)) continue;
                    destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Iterable $this$sortedByDescending$iv = MapsKt.toList((Map)destination$iv$iv2);
                boolean $i$f$sortedByDescending = false;
                List map3 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)b;
                        boolean bl = false;
                        Comparable comparable = (Double)it.getSecond();
                        it = (Pair)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getSecond()));
                    }
                });
                if (map3.isEmpty()) {
                    sender.sendMessage(PlayerChunkTickets.INSTANCE.getLang(), arg_0 -> onEnable.1.rate$lambda$8(langScope, arg_0), new TagResolver[0]);
                } else {
                    sender.message(PlayerChunkTickets.INSTANCE.getLang(), arg_0 -> onEnable.1.rate$lambda$9(langScope, arg_0), new TagResolver[0]);
                    Iterable $this$forEach$iv = map3;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Pair pair = (Pair)element$iv;
                        boolean bl = false;
                        Player p = (Player)pair.component1();
                        Double v = (Double)pair.component2();
                        TagResolver[] tagResolverArray = new TagResolver[]{ComponentBukkitUtils.player$default(ComponentBukkitUtils.INSTANCE, p, null, 2, null), ComponentUtils.INSTANCE.unparsed("rate", v)};
                        sender.message(PlayerChunkTickets.INSTANCE.getLang(), arg_0 -> onEnable.1.rate$lambda$10$0(langScope, arg_0), tagResolverArray);
                    }
                }
            }

            private static final Lang.ChunkRateTop genRateTop$lambda$1(Lang $this$rate) {
                return $this$rate.getGenRateTop();
            }

            private static final Lang.ChunkRateTop loadRateTop$lambda$3(Lang $this$rate) {
                return $this$rate.getLoadRateTop();
            }

            private static final MessageData rate$lambda$8(Function1 $langScope, Lang $this$message) {
                return ((Lang.ChunkRateTop)$langScope.invoke((Object)$this$message)).getNoData();
            }

            private static final String rate$lambda$9(Function1 $langScope, Lang $this$message) {
                return ((Lang.ChunkRateTop)$langScope.invoke((Object)$this$message)).getHeader();
            }

            private static final String rate$lambda$10$0(Function1 $langScope, Lang $this$message) {
                return ((Lang.ChunkRateTop)$langScope.invoke((Object)$this$message)).getEntry();
            }
        }, null, 2, null);
    }

    private static final MessageData checkUnavailable$lambda$0$0(User it) {
        return MessageData.Companion.getMessage("Server not supported");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u0014B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/github/rothes/esu/bukkit/module/essentialcommands/PlayerChunkTickets$Lang;", "", "genRateTop", "Lio/github/rothes/esu/bukkit/module/essentialcommands/PlayerChunkTickets$Lang$ChunkRateTop;", "loadRateTop", "<init>", "(Lio/github/rothes/esu/bukkit/module/essentialcommands/PlayerChunkTickets$Lang$ChunkRateTop;Lio/github/rothes/esu/bukkit/module/essentialcommands/PlayerChunkTickets$Lang$ChunkRateTop;)V", "getGenRateTop", "()Lio/github/rothes/esu/bukkit/module/essentialcommands/PlayerChunkTickets$Lang$ChunkRateTop;", "getLoadRateTop", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ChunkRateTop", "bukkit"})
    public static final class Lang {
        @NotNull
        private final ChunkRateTop genRateTop;
        @NotNull
        private final ChunkRateTop loadRateTop;

        public Lang(@NotNull ChunkRateTop genRateTop, @NotNull ChunkRateTop loadRateTop) {
            this.genRateTop = genRateTop;
            this.loadRateTop = loadRateTop;
        }

        public /* synthetic */ Lang(ChunkRateTop chunkRateTop, ChunkRateTop chunkRateTop2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                chunkRateTop = new ChunkRateTop(MessageData.Companion.getMessage("<pc>There's no chunk generates at this moment."), "<pdc>[player]<pc>: <sc>[chunk generate tickets/sec]", null, 4, null);
            }
            if ((n & 2) != 0) {
                chunkRateTop2 = new ChunkRateTop(MessageData.Companion.getMessage("<pc>There's no chunk loads at this moment."), "<pdc>[player]<pc>: <sc>[chunk load tickets/sec]", null, 4, null);
            }
            this(chunkRateTop, chunkRateTop2);
        }

        @NotNull
        public final ChunkRateTop getGenRateTop() {
            return this.genRateTop;
        }

        @NotNull
        public final ChunkRateTop getLoadRateTop() {
            return this.loadRateTop;
        }

        @NotNull
        public final ChunkRateTop component1() {
            return this.genRateTop;
        }

        @NotNull
        public final ChunkRateTop component2() {
            return this.loadRateTop;
        }

        @NotNull
        public final Lang copy(@NotNull ChunkRateTop genRateTop, @NotNull ChunkRateTop loadRateTop) {
            return new Lang(genRateTop, loadRateTop);
        }

        public static /* synthetic */ Lang copy$default(Lang lang, ChunkRateTop chunkRateTop, ChunkRateTop chunkRateTop2, int n, Object object) {
            if ((n & 1) != 0) {
                chunkRateTop = lang.genRateTop;
            }
            if ((n & 2) != 0) {
                chunkRateTop2 = lang.loadRateTop;
            }
            return lang.copy(chunkRateTop, chunkRateTop2);
        }

        @NotNull
        public String toString() {
            return "Lang(genRateTop=" + this.genRateTop + ", loadRateTop=" + this.loadRateTop + ")";
        }

        public int hashCode() {
            int result = this.genRateTop.hashCode();
            result = result * 31 + this.loadRateTop.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Lang)) {
                return false;
            }
            Lang lang = (Lang)other;
            if (!Intrinsics.areEqual((Object)this.genRateTop, (Object)lang.genRateTop)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.loadRateTop, (Object)lang.loadRateTop);
        }

        public Lang() {
            this(null, null, 3, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lio/github/rothes/esu/bukkit/module/essentialcommands/PlayerChunkTickets$Lang$ChunkRateTop;", "Lio/github/rothes/esu/core/configuration/ConfigurationPart;", "noData", "Lio/github/rothes/esu/core/configuration/data/MessageData;", "header", "", "entry", "<init>", "(Lio/github/rothes/esu/core/configuration/data/MessageData;Ljava/lang/String;Ljava/lang/String;)V", "getNoData", "()Lio/github/rothes/esu/core/configuration/data/MessageData;", "getHeader", "()Ljava/lang/String;", "getEntry", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "bukkit"})
        public static final class ChunkRateTop
        implements ConfigurationPart {
            @NotNull
            private final MessageData noData;
            @NotNull
            private final String header;
            @NotNull
            private final String entry;

            public ChunkRateTop(@NotNull MessageData noData, @NotNull String header, @NotNull String entry) {
                this.noData = noData;
                this.header = header;
                this.entry = entry;
            }

            public /* synthetic */ ChunkRateTop(MessageData messageData, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    messageData = MessageData.Companion.getMessage("");
                }
                if ((n & 2) != 0) {
                    string = "";
                }
                if ((n & 4) != 0) {
                    string2 = "<tdc><player><tc>: <sdc><rate>";
                }
                this(messageData, string, string2);
            }

            @NotNull
            public final MessageData getNoData() {
                return this.noData;
            }

            @NotNull
            public final String getHeader() {
                return this.header;
            }

            @NotNull
            public final String getEntry() {
                return this.entry;
            }

            @NotNull
            public final MessageData component1() {
                return this.noData;
            }

            @NotNull
            public final String component2() {
                return this.header;
            }

            @NotNull
            public final String component3() {
                return this.entry;
            }

            @NotNull
            public final ChunkRateTop copy(@NotNull MessageData noData, @NotNull String header, @NotNull String entry) {
                return new ChunkRateTop(noData, header, entry);
            }

            public static /* synthetic */ ChunkRateTop copy$default(ChunkRateTop chunkRateTop, MessageData messageData, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    messageData = chunkRateTop.noData;
                }
                if ((n & 2) != 0) {
                    string = chunkRateTop.header;
                }
                if ((n & 4) != 0) {
                    string2 = chunkRateTop.entry;
                }
                return chunkRateTop.copy(messageData, string, string2);
            }

            @NotNull
            public String toString() {
                return "ChunkRateTop(noData=" + this.noData + ", header=" + this.header + ", entry=" + this.entry + ")";
            }

            public int hashCode() {
                int result = this.noData.hashCode();
                result = result * 31 + this.header.hashCode();
                result = result * 31 + this.entry.hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ChunkRateTop)) {
                    return false;
                }
                ChunkRateTop chunkRateTop = (ChunkRateTop)other;
                if (!Intrinsics.areEqual((Object)this.noData, (Object)chunkRateTop.noData)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.header, (Object)chunkRateTop.header)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.entry, (Object)chunkRateTop.entry);
            }

            public ChunkRateTop() {
                this(null, null, null, 7, null);
            }
        }
    }
}

